/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipFile;
import org.codehaus.plexus.components.io.attributes.PlexusIoResourceAttributes;
import org.codehaus.plexus.components.io.attributes.SimpleResourceAttributes;
import org.codehaus.plexus.components.io.resources.AbstractPlexusIoResource;
import org.codehaus.plexus.components.io.resources.PlexusIoResourceWithAttributes;

public class ZipResource
extends AbstractPlexusIoResource
implements PlexusIoResourceWithAttributes {
    private final ZipFile zipFile;
    private final ZipArchiveEntry entry;
    private PlexusIoResourceAttributes attributes;

    public ZipResource(ZipFile zipFile, ZipArchiveEntry entry) {
        super(entry.getName(), ZipResource.getLastModofied(entry), entry.isDirectory() ? -1L : entry.getSize(), !entry.isDirectory(), entry.isDirectory(), true);
        this.zipFile = zipFile;
        this.entry = entry;
    }

    private static long getLastModofied(ZipArchiveEntry entry) {
        long l = entry.getLastModifiedDate().getTime();
        return l == -1L ? 0L : l;
    }

    public synchronized PlexusIoResourceAttributes getAttributes() {
        int mode = this.entry.getUnixMode();
        mode = (mode & 0x8000) == 32768 ? (mode &= 0xFFFF7FFF) : (mode &= 0xFFFFBFFF);
        if (this.attributes == null) {
            this.attributes = new SimpleResourceAttributes(null, null, null, null, mode);
        }
        return this.attributes;
    }

    public synchronized void setAttributes(PlexusIoResourceAttributes attributes) {
        this.attributes = attributes;
    }

    public URL getURL() throws IOException {
        return null;
    }

    public InputStream getContents() throws IOException {
        return this.zipFile.getInputStream(this.entry);
    }
}

