/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.plexus.archiver.zip;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import org.codehaus.plexus.archiver.AbstractUnArchiver;
import org.codehaus.plexus.archiver.ArchiveFilterException;
import org.codehaus.plexus.archiver.ArchiverException;
import org.codehaus.plexus.archiver.util.ArchiveEntryUtils;
import org.codehaus.plexus.archiver.zip.ZipEntry;
import org.codehaus.plexus.archiver.zip.ZipFile;
import org.codehaus.plexus.components.io.resources.PlexusIoResource;
import org.codehaus.plexus.util.FileUtils;

public abstract class AbstractZipUnArchiver
extends AbstractUnArchiver {
    private static final String NATIVE_ENCODING = "native-encoding";
    private String encoding = "UTF8";

    public AbstractZipUnArchiver() {
    }

    public AbstractZipUnArchiver(File sourceFile) {
        super(sourceFile);
    }

    public void setEncoding(String encoding) {
        if (NATIVE_ENCODING.equals(encoding)) {
            encoding = null;
        }
        this.encoding = encoding;
    }

    protected void execute() throws ArchiverException {
        this.getLogger().debug("Expanding: " + this.getSourceFile() + " into " + this.getDestDirectory());
        ZipFile zf = null;
        try {
            zf = new ZipFile(this.getSourceFile(), this.encoding);
            Enumeration e = zf.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zf, ze);
                if (!this.isSelected(ze.getName(), fileInfo)) continue;
                this.extractFileIfIncluded(this.getSourceFile(), this.getDestDirectory(), zf.getInputStream(ze), ze.getName(), new Date(ze.getTime()), ze.isDirectory(), null);
            }
            this.getLogger().debug("expand complete");
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
        }
        finally {
            if (zf != null) {
                try {
                    zf.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private void extractFileIfIncluded(File sourceFile, File destDirectory, InputStream inputStream, String name, Date time, boolean isDirectory, Integer mode) throws IOException, ArchiverException {
        try {
            if (this.include(inputStream, name)) {
                this.extractFile(sourceFile, destDirectory, inputStream, name, time, isDirectory, mode);
            }
        }
        catch (ArchiveFilterException e) {
            throw new ArchiverException("Error verifying '" + name + "' for inclusion: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void extractFile(File srcF, File dir, InputStream compressedInputStream, String entryName, Date entryDate, boolean isDirectory, Integer mode) throws IOException, ArchiverException {
        File f = FileUtils.resolveFile((File)dir, (String)entryName);
        try {
            if (!this.isOverwrite() && f.exists() && f.lastModified() >= entryDate.getTime()) {
                return;
            }
            File dirF = f.getParentFile();
            if (dirF != null) {
                dirF.mkdirs();
            }
            if (isDirectory) {
                f.mkdirs();
            } else {
                byte[] buffer = new byte[1024];
                FileOutputStream fos = null;
                try {
                    int length;
                    fos = new FileOutputStream(f);
                    while ((length = compressedInputStream.read(buffer)) >= 0) {
                        fos.write(buffer, 0, length);
                    }
                    fos.close();
                    fos = null;
                }
                finally {
                    if (fos != null) {
                        try {
                            fos.close();
                        }
                        catch (IOException e) {}
                    }
                }
            }
            f.setLastModified(entryDate.getTime());
            if (!this.isIgnorePermissions() && mode != null) {
                ArchiveEntryUtils.chmod(f, mode, this.getLogger(), this.isUseJvmChmod());
            }
        }
        catch (FileNotFoundException ex) {
            this.getLogger().warn("Unable to expand to file " + f.getPath());
        }
    }

    protected void execute(String path, File outputDirectory) throws ArchiverException {
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(this.getSourceFile(), this.encoding);
            Enumeration e = zipFile.getEntries();
            while (e.hasMoreElements()) {
                ZipEntry ze = (ZipEntry)e.nextElement();
                ZipEntryFileInfo fileInfo = new ZipEntryFileInfo(zipFile, ze);
                if (!this.isSelected(ze.getName(), fileInfo) || !ze.getName().startsWith(path)) continue;
                this.extractFileIfIncluded(this.getSourceFile(), outputDirectory, zipFile.getInputStream(ze), ze.getName(), new Date(ze.getTime()), ze.isDirectory(), null);
            }
        }
        catch (IOException ioe) {
            throw new ArchiverException("Error while expanding " + this.getSourceFile().getAbsolutePath(), ioe);
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException e) {}
            }
        }
    }

    private static class ZipEntryFileInfo
    implements PlexusIoResource {
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;

        ZipEntryFileInfo(ZipFile zipFile, ZipEntry zipEntry) {
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
        }

        public String getName() {
            return this.zipEntry.getName();
        }

        public boolean isDirectory() {
            return this.zipEntry.isDirectory();
        }

        public boolean isFile() {
            return !this.zipEntry.isDirectory();
        }

        public InputStream getContents() throws IOException {
            return this.zipFile.getInputStream(this.zipEntry);
        }

        public long getLastModified() {
            long l = this.zipEntry.getTime();
            return l == 0L ? 0L : l;
        }

        public long getSize() {
            long l = this.zipEntry.getSize();
            return l == -1L ? -1L : l;
        }

        public URL getURL() throws IOException {
            return null;
        }

        public boolean isExisting() {
            return true;
        }
    }
}

