/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox;

import com.canoo.webtest.plugins.pdftest.htmlunit.PDFEncryptionPermission;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFField;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFInvalidPasswordException;
import com.canoo.webtest.plugins.pdftest.htmlunit.PDFPage;
import com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox.PDFBoxPDFFont;
import com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox.PDFBoxPDFLink;
import com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox.PdfBoxPDFBookmark;
import com.canoo.webtest.plugins.pdftest.htmlunit.pdfbox.PdfBoxPDFField;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebWindow;
import java.awt.geom.Rectangle2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pdfbox.cos.COSBase;
import org.pdfbox.cos.COSBoolean;
import org.pdfbox.cos.COSDictionary;
import org.pdfbox.cos.COSFloat;
import org.pdfbox.cos.COSInteger;
import org.pdfbox.cos.COSName;
import org.pdfbox.cos.COSNull;
import org.pdfbox.cos.COSString;
import org.pdfbox.exceptions.CryptographyException;
import org.pdfbox.exceptions.InvalidPasswordException;
import org.pdfbox.pdmodel.PDDocument;
import org.pdfbox.pdmodel.PDPage;
import org.pdfbox.pdmodel.common.PDRectangle;
import org.pdfbox.pdmodel.encryption.BadSecurityHandlerException;
import org.pdfbox.pdmodel.encryption.PDEncryptionDictionary;
import org.pdfbox.pdmodel.encryption.SecurityHandlersManager;
import org.pdfbox.pdmodel.encryption.StandardSecurityHandler;
import org.pdfbox.pdmodel.font.PDFont;
import org.pdfbox.pdmodel.interactive.action.type.PDAction;
import org.pdfbox.pdmodel.interactive.action.type.PDActionGoTo;
import org.pdfbox.pdmodel.interactive.action.type.PDActionURI;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.pdfbox.pdmodel.interactive.annotation.PDAnnotationLink;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.pdfbox.pdmodel.interactive.form.PDField;
import org.pdfbox.util.PDFTextStripper;
import org.pdfbox.util.PDFTextStripperByArea;
import org.pdfbox.util.TextPosition;

public class PdfBoxPDFPage
implements PDFPage {
    private PDDocument pdfDocument_;
    private List bookmarks_;
    private final WebWindow webWindow_;
    private final WebResponse webResponse_;
    private static final COSName INFO_PROPERTY_TITLE = COSName.getPDFName((String)"Title");
    private boolean cleanUpCalled;
    private static int counter = 0;
    private static int allocated = 0;
    private final byte[] bytes;

    public void cleanUp() throws IOException {
        this.cleanUpCalled = true;
        --allocated;
        if (this.pdfDocument_ != null) {
            this.pdfDocument_.close();
        }
    }

    public PdfBoxPDFPage(WebResponse webResponse, WebWindow webWindow) throws IOException {
        this.webWindow_ = webWindow;
        this.webResponse_ = webResponse;
        this.bytes = IOUtils.toByteArray((InputStream)webResponse.getContentAsStream());
        this.pdfDocument_ = this.loadPDFDocument();
        ++counter;
        ++allocated;
    }

    protected PDDocument loadPDFDocument() {
        try {
            return PDDocument.load((InputStream)new ByteArrayInputStream(this.bytes));
        }
        catch (IOException e) {
            this.getLog().warn((Object)("Failed parsing PDF document " + this.getUrl() + ": " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    protected final Log getLog() {
        return LogFactory.getLog(this.getClass());
    }

    private COSDictionary getInfoDictionary() {
        COSDictionary encryptProperties = this.getPDFDocument().getDocumentInformation().getDictionary();
        return encryptProperties != null ? encryptProperties : new COSDictionary();
    }

    private static void assertKeyExists(COSName key, COSDictionary properties) {
        if (properties.keyList().contains(key)) {
            return;
        }
        throw new IllegalArgumentException("Specified property key '" + key.getName() + "' does not exist.");
    }

    public String getDocumentTitle() {
        PdfBoxPDFPage.assertKeyExists(INFO_PROPERTY_TITLE, this.getInfoDictionary());
        COSString title = (COSString)this.getInfoDictionary().getItem(INFO_PROPERTY_TITLE);
        return title.getString();
    }

    public WebWindow getEnclosingWindow() {
        return this.webWindow_;
    }

    public WebResponse getWebResponse() {
        return this.webResponse_;
    }

    public URL getUrl() {
        return this.getWebResponse().getWebRequest().getUrl();
    }

    public void initialize() throws IOException {
    }

    public int getNumberOfPages() {
        return this.getPDFDocument().getNumberOfPages();
    }

    protected PDDocument getPDFDocument() {
        if (this.cleanUpCalled) {
            this.pdfDocument_ = this.loadPDFDocument();
            this.cleanUpCalled = false;
        }
        if (this.pdfDocument_ == null) {
            throw new RuntimeException("Can't work on pdf document as it couldn't get parsed");
        }
        return this.pdfDocument_;
    }

    public List getFields() {
        return this.getFields(TruePredicate.INSTANCE);
    }

    public void decrypt(String password) {
        try {
            this.getPDFDocument().decrypt(password);
        }
        catch (InvalidPasswordException e) {
            throw new PDFInvalidPasswordException(e);
        }
        catch (CryptographyException e) {
            throw new PDFInvalidPasswordException(e);
        }
        catch (Exception e) {
            throw new RuntimeException("Problem decrypting the document", e);
        }
    }

    public boolean isEncrypted() {
        return this.getPDFDocument().isEncrypted();
    }

    public String getText(int startPage, int endPage) {
        return this.getTextInternal(startPage, endPage);
    }

    protected String getTextInternal(int startPage, int endPage) {
        try {
            PDFTextStripper textStripper = new PDFTextStripper();
            textStripper.setStartPage(startPage);
            textStripper.setEndPage(endPage);
            return textStripper.getText(this.getPDFDocument());
        }
        catch (IOException e) {
            throw new RuntimeException("Problem extracting text", e);
        }
    }

    protected List getFields(Predicate filter) {
        ArrayList<PDFField> response;
        block5: {
            PDAcroForm acroForm = this.getPDFDocument().getDocumentCatalog().getAcroForm();
            response = new ArrayList<PDFField>();
            try {
                if (acroForm == null) break block5;
                List fields = acroForm.getFields();
                for (PDField field : fields) {
                    List kids = field.getKids();
                    if (kids != null && !kids.isEmpty()) {
                        for (PDField childField : kids) {
                            if (!filter.evaluate((Object)childField)) continue;
                            response.add(PdfBoxPDFField.wrap(childField));
                        }
                        continue;
                    }
                    if (!filter.evaluate((Object)field)) continue;
                    response.add(PdfBoxPDFField.wrap(field));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed reading fields", e);
            }
        }
        return response;
    }

    public List getFields(String name, PDFField.Type type) {
        return this.getFields(PdfBoxPDFField.FieldPredicate.buildNamePredicate(name));
    }

    public List getFields(String name, int pageNumber, PDFField.Type type) {
        PdfBoxPDFField.FieldPredicate predicateName = PdfBoxPDFField.FieldPredicate.buildNamePredicate(name);
        PdfBoxPDFField.FieldPredicate predicatePage = PdfBoxPDFField.FieldPredicate.buildPageNumberPredicate(pageNumber);
        AndPredicate predicate = new AndPredicate((Predicate)predicateName, (Predicate)predicatePage);
        return this.getFields((Predicate)predicate);
    }

    public boolean hasPermission(PDFEncryptionPermission permission) {
        PDEncryptionDictionary info;
        int bitValue;
        int PRINT_BIT = 3;
        int MODIFICATION_BIT = 4;
        int MODIFY_ANNOTATIONS_BIT = 6;
        int ASSEMBLE_DOCUMENT_BIT = 11;
        int DEGRADED_PRINT_BIT = 12;
        int EXTRACT_BIT = 5;
        int FILL_IN_FORM_BIT = 9;
        int EXTRACT_FOR_ACCESSIBILITY_BIT = 10;
        if (PDFEncryptionPermission.ASSEMBLY.equals((Object)permission)) {
            bitValue = 11;
        } else if (PDFEncryptionPermission.COPY.equals((Object)permission)) {
            bitValue = 5;
        } else if (PDFEncryptionPermission.DEGRADED_PRINTING.equals((Object)permission)) {
            bitValue = 12;
        } else if (PDFEncryptionPermission.FILL_IN.equals((Object)permission)) {
            bitValue = 9;
        } else if (PDFEncryptionPermission.MODIFY_ANNOTATIONS.equals((Object)permission)) {
            bitValue = 6;
        } else if (PDFEncryptionPermission.MODIFY_CONTENTS.equals((Object)permission)) {
            bitValue = 4;
        } else if (PDFEncryptionPermission.PRINTING.equals((Object)permission)) {
            bitValue = 3;
        } else if (PDFEncryptionPermission.SCREEN_READERS.equals((Object)permission)) {
            bitValue = 10;
        } else {
            throw new IllegalArgumentException("Unknown pdf permission: " + (Object)((Object)permission));
        }
        try {
            info = this.getPDFDocument().getEncryptionDictionary();
        }
        catch (IOException e) {
            throw new RuntimeException("Can't read permissions", e);
        }
        return (info.getPermissions() & 1 << bitValue - 1) != 0;
    }

    public String getEncryptProperty(String key) {
        COSDictionary encryptProperties = this.getPDFDocument().getDocument().getEncryptionDictionary();
        return PdfBoxPDFPage.stringValue(encryptProperties.getDictionaryObject(key));
    }

    static String stringValue(COSBase element) {
        if (element == null) {
            return null;
        }
        if (element instanceof COSString) {
            return ((COSString)element).getString();
        }
        if (element instanceof COSName) {
            return ((COSName)element).getName();
        }
        if (element instanceof COSBoolean) {
            return String.valueOf(((COSBoolean)element).getValue());
        }
        if (element instanceof COSInteger) {
            return String.valueOf(((COSInteger)element).intValue());
        }
        if (element instanceof COSFloat) {
            return String.valueOf(((COSFloat)element).floatValue());
        }
        if (element instanceof COSNull) {
            return "null";
        }
        return String.valueOf(element);
    }

    public int getEncryptionStrength() {
        try {
            return this.getPDFDocument().getEncryptionDictionary().getLength();
        }
        catch (IOException e) {
            throw new RuntimeException("Failed reading encryption strength", e);
        }
    }

    public String getInfoProperty(String key) {
        COSDictionary properties = this.getPDFDocument().getDocumentInformation().getDictionary();
        if (properties == null) {
            return null;
        }
        COSName pdfName = COSName.getPDFName((String)key);
        return PdfBoxPDFPage.stringValue(properties.getDictionaryObject(pdfName));
    }

    public boolean isUserPassword(String password) {
        try {
            return this.isPassword(password, true);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed verifying user password", e);
        }
    }

    private boolean isPassword(String password, boolean userPassword) throws IOException, BadSecurityHandlerException, CryptographyException {
        StandardSecurityHandler secHandler = this.getSecurityHandler();
        PDEncryptionDictionary dictionary = this.getPDFDocument().getEncryptionDictionary();
        int dicPermissions = dictionary.getPermissions();
        int dicRevision = dictionary.getRevision();
        int dicLength = dictionary.getLength() / 8;
        COSString id = (COSString)this.getPDFDocument().getDocument().getDocumentID().getObject(0);
        byte[] u = dictionary.getUserKey();
        byte[] o = dictionary.getOwnerKey();
        if (userPassword) {
            return secHandler.isUserPassword(password.getBytes(), u, o, dicPermissions, id.getBytes(), dicRevision, dicLength);
        }
        return secHandler.isOwnerPassword(password.getBytes(), u, o, dicPermissions, id.getBytes(), dicRevision, dicLength);
    }

    private StandardSecurityHandler getSecurityHandler() throws IOException, BadSecurityHandlerException {
        PDEncryptionDictionary dict = this.getPDFDocument().getEncryptionDictionary();
        StandardSecurityHandler secHandler = (StandardSecurityHandler)SecurityHandlersManager.getInstance().getSecurityHandler(dict.getFilter());
        return secHandler;
    }

    public boolean isOwnerPassword(String password) {
        try {
            return this.isPassword(password, false);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed verifying owner password", e);
        }
    }

    public List getBookmarks() {
        if (this.bookmarks_ == null) {
            this.bookmarks_ = this.extractBookmarks();
        }
        return this.bookmarks_;
    }

    private List extractBookmarks() {
        PDDocumentOutline outline = this.getPDFDocument().getDocumentCatalog().getDocumentOutline();
        ArrayList<PdfBoxPDFBookmark> result = new ArrayList<PdfBoxPDFBookmark>();
        if (outline != null) {
            for (PDOutlineItem child = outline.getFirstChild(); child != null; child = child.getNextSibling()) {
                PdfBoxPDFBookmark topBookmark = new PdfBoxPDFBookmark(child, null);
                result.add(topBookmark);
                result.addAll(topBookmark.getAllChildren());
            }
        }
        return result;
    }

    public List getFonts() {
        ArrayList<PDFBoxPDFFont> fonts = new ArrayList<PDFBoxPDFFont>();
        List pages = this.getPDFDocument().getDocumentCatalog().getAllPages();
        ListIterator iter = pages.listIterator();
        while (iter.hasNext()) {
            PDPage page = (PDPage)iter.next();
            try {
                for (PDFont font : page.findResources().getFonts().values()) {
                    fonts.add(new PDFBoxPDFFont(font, iter.nextIndex()));
                }
            }
            catch (IOException e) {
                throw new RuntimeException("Failed retrieving the fonts on page " + iter.nextIndex(), e);
            }
        }
        return fonts;
    }

    public List getFields(int pageNumber) {
        PdfBoxPDFField.FieldPredicate predicatePage = PdfBoxPDFField.FieldPredicate.buildPageNumberPredicate(pageNumber);
        return this.getFields(predicatePage);
    }

    public List getFields(String name, int pageNumber) {
        PdfBoxPDFField.FieldPredicate predicateName = PdfBoxPDFField.FieldPredicate.buildNamePredicate(name);
        PdfBoxPDFField.FieldPredicate predicatePage = PdfBoxPDFField.FieldPredicate.buildPageNumberPredicate(pageNumber);
        AndPredicate predicate = new AndPredicate((Predicate)predicateName, (Predicate)predicatePage);
        return this.getFields((Predicate)predicate);
    }

    public List getFields(String name) {
        return this.getFields(PdfBoxPDFField.FieldPredicate.buildNamePredicate(name));
    }

    public List getLinks() {
        ArrayList result = new ArrayList();
        List allPages = this.getPDFDocument().getDocumentCatalog().getAllPages();
        ListIterator iter = allPages.listIterator();
        while (iter.hasNext()) {
            PDPage page = (PDPage)iter.next();
            PdfBoxPDFPage.processPage(result, page, iter.nextIndex());
        }
        return result;
    }

    private static void processPage(List result, PDPage page, int pageNum) {
        try {
            PDFTextStripperByArea stripper = new PDFTextStripperByArea();
            ArrayList linkAnnotations = new ArrayList();
            ArrayList linkRegions = new ArrayList();
            PdfBoxPDFPage.extractAnnotations(page, stripper, linkAnnotations, linkRegions);
            stripper.extractRegions(page);
            HashMap uriMap = new HashMap();
            HashMap textMap = new HashMap();
            PdfBoxPDFPage.collateLinks(linkAnnotations, linkRegions, uriMap, textMap, stripper);
            for (Object key : uriMap.keySet()) {
                result.add(new PDFBoxPDFLink((String)textMap.get(key), (String)uriMap.get(key), pageNum));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void collateLinks(List linkAnnotations, List linkRegions, Map uriMap, Map textMap, PDFTextStripperByArea stripper) throws IOException {
        for (int j = 0; j < linkAnnotations.size(); ++j) {
            PDAnnotationLink link = (PDAnnotationLink)linkAnnotations.get(j);
            PDAction action = link.getAction();
            String urlText = stripper.getTextForRegion(Integer.toString(j));
            if (action instanceof PDActionURI) {
                PDActionURI uri = (PDActionURI)action;
                if (urlText.length() > 0) {
                    textMap.put(linkRegions.get(j), urlText);
                }
                uriMap.put(linkRegions.get(j), uri.getURI());
                continue;
            }
            if (!(action instanceof PDActionGoTo) || urlText.length() <= 0) continue;
            textMap.put(linkRegions.get(j), urlText);
        }
    }

    private static List extractAnnotations(PDPage page, PDFTextStripperByArea stripper, List linkAnnotations, List linkRegions) throws IOException {
        List annotations = page.getAnnotations();
        for (int j = 0; j < annotations.size(); ++j) {
            PDAnnotation annot = (PDAnnotation)annotations.get(j);
            if (!(annot instanceof PDAnnotationLink)) continue;
            PDRectangle rect = annot.getRectangle();
            float x = rect.getLowerLeftX() - 1.0f;
            float y = rect.getUpperRightY() - 1.0f;
            float width = rect.getWidth() + 2.0f;
            float height = rect.getHeight() + rect.getHeight() / 4.0f;
            int rotation = page.findRotation();
            if (rotation == 0) {
                PDRectangle pageSize = page.findMediaBox();
                y = pageSize.getHeight() - y;
            }
            Rectangle2D.Float awtRect = new Rectangle2D.Float(x, y, width, height);
            stripper.addRegion(Integer.toString(j), (Rectangle2D)awtRect);
            linkAnnotations.add(annot);
            linkRegions.add(awtRect);
        }
        return annotations;
    }

    public String getText(String fragmentSeparator, String lineSeparator, String pageSeparator, String mode) {
        return this.getText(0, this.getNumberOfPages(), fragmentSeparator, lineSeparator, pageSeparator, mode);
    }

    private String getText(int startPage, int endPage, String fragmentSeparator, String lineSeparator, String pageSeparator, String mode) {
        StringBuffer buf = new StringBuffer();
        if ("normal".equals(mode)) {
            buf.append(this.getTextInternal(startPage, endPage, lineSeparator, pageSeparator));
        } else {
            for (int page = startPage; page <= endPage; ++page) {
                List fragments = this.getFragments(page, fragmentSeparator, lineSeparator);
                String tmp = this.collateFragments(fragments, fragmentSeparator, lineSeparator);
                if (tmp.length() <= 0) continue;
                buf.append(tmp);
                buf.append(pageSeparator);
            }
        }
        return buf.toString();
    }

    private String getTextInternal(int startPage, int endPage, String lineSeparator, String pageSeparator) {
        StringWriter output = new StringWriter();
        try {
            PDFTextStripper textStripper = new PDFTextStripper();
            textStripper.setPageSeparator(pageSeparator);
            textStripper.setLineSeparator(lineSeparator);
            textStripper.setStartPage(startPage);
            textStripper.setEndPage(endPage);
            textStripper.writeText(this.getPDFDocument(), (Writer)output);
            String string = output.toString();
            return string;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while extracting text from document.", e);
        }
        finally {
            IOUtils.closeQuietly((Writer)output);
        }
    }

    public List getFragments(int page, String fragmentSeparator, String lineSeparator) {
        final ArrayList fragments = new ArrayList();
        StringWriter output = new StringWriter();
        try {
            PDFTextStripper textStripper = new PDFTextStripper(){

                protected void showCharacter(TextPosition textPosition) {
                    fragments.add(textPosition);
                }
            };
            textStripper.setLineSeparator(lineSeparator);
            textStripper.setStartPage(page);
            textStripper.setEndPage(page);
            textStripper.writeText(this.getPDFDocument(), (Writer)output);
            ArrayList arrayList = fragments;
            return arrayList;
        }
        catch (Exception e) {
            throw new RuntimeException("Error while extracting text from document.", e);
        }
        finally {
            IOUtils.closeQuietly((Writer)output);
        }
    }

    private String collateFragments(List fragments, String fragmentSeparator, String lineSeparator) {
        TreeMap linesOfText = new TreeMap();
        this.regroup(fragments, linesOfText);
        TreeMap linesOfString = new TreeMap();
        this.coalesce(linesOfText, linesOfString);
        return this.fragmentsToString(linesOfString, fragmentSeparator, lineSeparator);
    }

    private void coalesce(Map linesOfText, Map linesOfString) {
        for (Integer key : linesOfText.keySet()) {
            linesOfString.put(key, this.coalesceLine((Map)linesOfText.get(key)));
        }
    }

    private Map coalesceLine(Map input) {
        TreeMap<Integer, String> output = new TreeMap<Integer, String>();
        Iterator kit = input.keySet().iterator();
        TextPosition lastFragment = null;
        String lastString = null;
        Integer lastKey = null;
        while (kit.hasNext()) {
            Integer key = (Integer)kit.next();
            TextPosition thisFragment = (TextPosition)input.get(key);
            if (lastFragment != null && this.adjacent(lastFragment, thisFragment)) {
                lastFragment = thisFragment;
                lastString = lastString + thisFragment.getCharacter();
            } else {
                if (lastFragment != null) {
                    output.put(lastKey, lastString);
                }
                lastFragment = thisFragment;
                lastString = thisFragment.getCharacter();
                lastKey = key;
            }
            if (lastFragment == null) continue;
            output.put(lastKey, lastString);
        }
        return output;
    }

    private boolean adjacent(TextPosition lastFragment, TextPosition thisFragment) {
        int TOLERANCE = 2;
        return thisFragment.getX() - (lastFragment.getX() + lastFragment.getWidth() * lastFragment.getXScale()) < 2.0f;
    }

    private void regroup(List fragments, Map lines) {
        for (int i = 0; i < fragments.size(); ++i) {
            TextPosition textPosition = (TextPosition)fragments.get(i);
            Integer y = new Integer((int)textPosition.getY());
            Integer x = new Integer((int)textPosition.getX());
            TreeMap pieces = lines.containsKey(y) ? (TreeMap)lines.get(y) : new TreeMap();
            pieces.put(x, textPosition);
            lines.put(y, pieces);
        }
    }

    private String fragmentsToString(Map linesOfString, String fragmentSeparator, String lineSeparator) {
        StringBuffer buf = new StringBuffer();
        for (Map pieces : linesOfString.values()) {
            Iterator pit = pieces.values().iterator();
            while (pit.hasNext()) {
                String piece = (String)pit.next();
                buf.append(piece);
                if (!pit.hasNext()) continue;
                buf.append(fragmentSeparator);
            }
            buf.append(lineSeparator);
        }
        return buf.toString();
    }
}

