/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.plugins.emailtest;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.ContextHelper;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.interfaces.IContentFilter;
import com.canoo.webtest.plugins.emailtest.AbstractMessageOperationStep;
import javax.mail.Message;
import javax.mail.MessagingException;

public abstract class AbstractEmailFilter
extends AbstractMessageOperationStep
implements IContentFilter {
    private static final String DUMMY_FILTER_URLSTR = "http://dummyEmailFilterUrl";

    protected AbstractEmailFilter() {
        super(false);
    }

    protected void performOperation(Message message) throws MessagingException {
        Context context = this.getContext();
        try {
            this.filterContent(message);
        }
        catch (MessagingException e) {
            throw new StepFailedException("Error performing operation: " + e.getMessage(), this);
        }
        finally {
            context.saveResponseAsCurrent(context.getCurrentResponse());
            context.getConfig().setResultpath(this.getContext().getConfig().getWebTestResultDir());
            context.saveResponseAsCurrent(context.getCurrentResponse());
        }
    }

    protected abstract void filterContent(Message var1) throws MessagingException;

    public void setSave(String prefix) {
    }

    public void setSavePrefix(String prefix) {
    }

    public void setSaveResponse(String response) {
    }

    protected void defineAsCurrentResponse(byte[] responseBytes, String contentType) {
        ContextHelper.defineAsCurrentResponse(this.getContext(), responseBytes, contentType, DUMMY_FILTER_URLSTR);
    }

    protected void defineAsCurrentResponse(String response, String contentType) {
        this.defineAsCurrentResponse(response.getBytes(), contentType);
    }
}

