/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.steps.AbstractFilter;
import com.canoo.webtest.util.ConversionUtil;
import com.gargoylesoftware.htmlunit.WebResponse;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;

public class SelectLinesFilter
extends AbstractFilter {
    private static final String LS = System.getProperty("line.separator");
    private static final String LINE_STR = "(^.*$)";
    private String fStartRegex;
    private String fIncludeStart;
    private String fStopRegex;
    private String fIncludeStop;
    private String fRemove;
    private String fRepeat;
    private static final Pattern LINE_PATTERN = Pattern.compile("(^.*$)", 8);

    public void setStartRegex(String value) {
        this.fStartRegex = value;
    }

    public String getStartRegex() {
        return this.fStartRegex;
    }

    public void setIncludeStart(String flag) {
        this.fIncludeStart = flag;
    }

    public String getIncludeStart() {
        return this.fIncludeStart;
    }

    public void setStopRegex(String value) {
        this.fStopRegex = value;
    }

    public String getStopRegex() {
        return this.fStopRegex;
    }

    public void setIncludeStop(String flag) {
        this.fIncludeStop = flag;
    }

    public String getIncludeStop() {
        return this.fIncludeStop;
    }

    public void setRemove(String flag) {
        this.fRemove = flag;
    }

    public String getRemove() {
        return this.fRemove;
    }

    public void setRepeat(String flag) {
        this.fRepeat = flag;
    }

    public String getRepeat() {
        return this.fRepeat;
    }

    protected void verifyParameters() {
        super.verifyParameters();
        this.paramCheck(this.getStartRegex() == null && this.getStopRegex() == null, "One of 'startRegex' or 'stopRegex' must be set!");
        this.nullResponseCheck();
    }

    public void doExecute() throws Exception {
        WebResponse webResponse = this.getContext().getCurrentResponse().getWebResponse();
        String orig = webResponse.getContentAsString();
        String origType = webResponse.getContentType();
        boolean remove = ConversionUtil.convertToBoolean(this.getRemove(), false);
        boolean repeat = ConversionUtil.convertToBoolean(this.getRepeat(), false);
        boolean includeStart = ConversionUtil.convertToBoolean(this.getIncludeStart(), true);
        boolean includeStop = ConversionUtil.convertToBoolean(this.getIncludeStop(), true);
        Matcher matcher = LINE_PATTERN.matcher(orig);
        StringBuffer buf = new StringBuffer();
        boolean selecting = StringUtils.isEmpty((String)this.getStartRegex());
        boolean done = false;
        while (matcher.find()) {
            boolean adding = false;
            String line = matcher.group(0);
            if (selecting && includeStop) {
                adding = true;
            }
            if (selecting && !done && line.matches(this.getStopRegex())) {
                selecting = false;
                if (!repeat) {
                    done = true;
                }
            }
            if (!selecting && !done && line.matches(this.getStartRegex())) {
                selecting = true;
                if (includeStart) {
                    adding = true;
                }
            } else if (selecting) {
                adding = true;
            }
            if (adding == remove) continue;
            buf.append(line).append(LS);
        }
        this.defineAsCurrentResponse(buf.toString(), origType);
    }
}

