/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.extension;

import com.canoo.webtest.boundary.ResetScriptRunner;
import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.engine.StepFailedException;
import com.canoo.webtest.steps.Step;
import com.canoo.webtest.util.ConversionUtil;
import com.canoo.webtest.util.FileUtil;
import com.gargoylesoftware.htmlunit.html.HtmlPage;
import com.gargoylesoftware.htmlunit.xml.XmlPage;
import java.io.File;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Project;

public class ScriptStep
extends Step {
    private static final Logger LOG = Logger.getLogger(ScriptStep.class);
    private String fLanguage;
    private String fKeep;
    private File fSrc;
    private String fScriptText = "";

    public void doExecute() throws Exception {
        ResetScriptRunner runner;
        Context context = this.getContext();
        if (context.getRunner() == null) {
            runner = new ResetScriptRunner();
            runner.setLanguage(this.getLanguage());
            context.setRunner(runner);
            LOG.debug((Object)("Creating new Script Runner with language: " + this.fLanguage));
        } else {
            runner = context.getRunner();
            runner.reset();
        }
        this.buildScript();
        this.getProject().addReference("step", (Object)this);
        if (context.getCurrentResponse() == null) {
            LOG.warn((Object)"No response found. Previous invoke missing? Related scripting variables not created");
        } else {
            this.setupResponseScriptingVariables(context);
        }
        try {
            ScriptStep.executeByRunner(runner, this.getProject().replaceProperties(this.fScriptText), this, this.getProject());
        }
        catch (AssertionError ae) {
            String msg = "Assertion error during scriptStep: " + ((Throwable)((Object)ae)).getMessage();
            LOG.debug((Object)msg, (Throwable)((Object)ae));
            throw new StepFailedException(msg, this);
        }
        catch (BuildException be) {
            LOG.debug((Object)be.getMessage(), (Throwable)be);
            throw new StepExecutionException("Error invoking script: " + be.getMessage(), this);
        }
        finally {
            if (!this.isKeep()) {
                context.setRunner(null);
            }
        }
    }

    public static String evalScriptExpression(Context context, String expression, Step step) {
        ResetScriptRunner runner = context.getRunner();
        if (runner == null) {
            throw new StepExecutionException("Can't evaluate script property because no previous <scriptStep> with keep=true.", step);
        }
        runner.reset();
        try {
            return ScriptStep.evalByRunner(runner, expression, step);
        }
        catch (BuildException be) {
            throw new StepExecutionException("Error invoking script: " + be.getMessage(), step);
        }
    }

    public static void executeByRunner(ResetScriptRunner runner, String script, Step step, Project project) throws BuildException {
        runner.addText(script);
        runner.addBeans(project.getProperties());
        runner.addBeans(project.getUserProperties());
        runner.addBeans(project.getTargets());
        runner.addBeans(project.getReferences());
        runner.addBean("project", project);
        runner.addBean("self", step);
        runner.executeScript("WebTest");
    }

    public static String evalByRunner(ResetScriptRunner runner, String script, Step step) throws BuildException {
        runner.addText(script);
        runner.addBean("self", step);
        return runner.evalScript("WebTest");
    }

    private void buildScript() {
        if (this.fSrc != null) {
            this.fScriptText = this.fScriptText + FileUtil.readFileToString(this.fSrc, this);
        }
    }

    private void setupResponseScriptingVariables(Context context) {
        this.getProject().addReference("response", (Object)context.getCurrentResponse().getWebResponse());
        if (context.getCurrentResponse() instanceof HtmlPage) {
            this.getProject().addReference("document", (Object)((HtmlPage)context.getCurrentResponse()).getDocumentElement());
        } else if (context.getCurrentResponse() instanceof XmlPage) {
            this.getProject().addReference("document", (Object)((XmlPage)context.getCurrentResponse()).getXmlDocument());
        }
    }

    protected void verifyParameters() {
        super.verifyParameters();
        ResetScriptRunner runner = this.getContext().getRunner();
        if (runner == null) {
            this.emptyParamCheck(this.fLanguage, "language");
        } else {
            this.paramCheck(this.fLanguage != null && !this.fLanguage.equals(runner.getLanguage()), "You may not change 'language' to '" + this.fLanguage + "' after previously using the 'keep' attribute (was: " + runner.getLanguage() + ")");
        }
        this.paramCheck(this.fSrc == null && StringUtils.isEmpty((String)this.fScriptText), "Either \"src\" attribute or nested script text must be given.");
    }

    protected void addComputedParameters(Map map) {
        map.put("language", this.fLanguage);
        if (this.fSrc == null) {
            map.put("script", this.fScriptText);
        } else {
            map.put("src", this.fSrc);
        }
    }

    public void setLanguage(String language) {
        this.fLanguage = language;
    }

    public String getLanguage() {
        return this.fLanguage;
    }

    public void setSrc(File fileName) {
        this.fSrc = fileName;
    }

    public File getSrc() {
        return this.fSrc;
    }

    public void setKeep(String keep) {
        this.fKeep = keep;
    }

    public String getKeep() {
        return this.fKeep;
    }

    public boolean isKeep() {
        return ConversionUtil.convertToBoolean(this.fKeep, false);
    }

    public void addText(String text) {
        this.fScriptText = this.fScriptText + text;
    }
}

