/*
 * Decompiled with CFR 0.152.
 */
package com.canoo.webtest.boundary;

import com.canoo.webtest.engine.Context;
import com.canoo.webtest.engine.StepExecutionException;
import com.canoo.webtest.steps.Step;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;

public final class StreamBoundary {
    private static final Logger LOG = Logger.getLogger(StreamBoundary.class);

    private StreamBoundary() {
    }

    public static void closeInputStream(InputStream inStream) {
        if (inStream != null) {
            try {
                inStream.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Error closing stream: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void closeOutputStream(OutputStream outStream) {
        if (outStream != null) {
            try {
                outStream.close();
            }
            catch (IOException e) {
                LOG.warn((Object)("Error closing stream: " + e.getMessage()), (Throwable)e);
            }
        }
    }

    public static void tryCloseInputStreamWithFail(InputStream is, Step step) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new StepExecutionException("Error closing stream: " + e.getMessage(), step);
            }
        }
    }

    public static void tryCloseOutputStream(OutputStream os, Step step) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                throw new StepExecutionException("Error closing stream: " + e.getMessage(), step);
            }
        }
    }

    public static Object tryReadObject(ObjectInputStream ois, Step step) throws IOException {
        try {
            return ois.readObject();
        }
        catch (ClassNotFoundException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            throw new StepExecutionException("Error reading object from file: " + e.getMessage(), step);
        }
    }

    public static byte[] tryGetBytes(Context context, Step step) {
        try {
            return IOUtils.toByteArray((InputStream)context.getCurrentResponse().getWebResponse().getContentAsStream());
        }
        catch (IOException e) {
            throw new StepExecutionException("Error processing content: " + e.getMessage(), step);
        }
    }
}

