/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.was6;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:was6-maven-plugin:1.1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "WAS6 Maven Plugin", 0);
        this.append(sb, "Tools for working with IBM WebSphere 6.0.x and 6.1.x. This plugin works along with an installation of WebSphere Application Server or Process Server - standalone or ND installation, to provide automated tasks for: generating RMIC stubs, starting/stopping servers, installing/updating/uninstalling EARs to application servers, run serviceDeploy and run arbitrary scripts with wsadmin.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 14 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "was6:clean", 0);
            this.append(sb, "Cleans out temporary resources and generated sources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedClassesDirectory (Default: ${project.build.directory}/generated-classes/was6-maven-plugin)", 2);
                this.append(sb, "Directory to hold generated classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSourcesDirectory (Default: ${project.build.directory}/generated-sources/was6-maven-plugin)", 2);
                this.append(sb, "Directory to hold generated sources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "ejbdeploy".equals(this.goal)) {
            this.append(sb, "was6:ejbdeploy", 0);
            this.append(sb, "Generates EJB RMIC stub sources.\nThis goal will fork a parallel life cycle up to package phase. This is required because an archive is required as input to the underlying tasks.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compatible35", 2);
                this.append(sb, "Set to true to use WebSphere 3.5 compatible mapping rules.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dbname", 2);
                this.append(sb, "Specifies the name of the database to create.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dbschema", 2);
                this.append(sb, "Specifies the name of the database schema to create.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dbvendor", 2);
                this.append(sb, "Specifies the type of database the EJBs will use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dynamic", 2);
                this.append(sb, "Specifies to enable dynamic query support.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedClassesDirectory (Default: ${project.build.directory}/generated-classes/was6-maven-plugin)", 2);
                this.append(sb, "Directory to hold generated classes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "generatedSourcesDirectory (Default: ${project.build.directory}/generated-sources/was6-maven-plugin)", 2);
                this.append(sb, "Directory to hold generated sources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "jdkComplianceLevel (Default: ${project.build.java.target})", 2);
                this.append(sb, "JDK compliance level. Valid values are: 1.4 or 5.0 This parameter will only be taken into consideration if legacyMode is false. IBM didn't support this flag in earlier versions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "legacyMode (Default: false)", 2);
                this.append(sb, "Set this to true if you've got an old rational SDP version (7.0.0.4/interimfix 001), or an old WAS base/ND installation (lower than fixpack 007).", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noInform (Default: false)", 2);
                this.append(sb, "Set to true to disable informational messages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noValidate (Default: false)", 2);
                this.append(sb, "Set to true to disable validation messages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWarnings (Default: false)", 2);
                this.append(sb, "Set to true to disable warning and informational messages.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sqlj", 2);
                this.append(sb, "Set to true to generate SQL/J persistor code.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "endpointEnabler".equals(this.goal)) {
            this.append(sb, "was6:endpointEnabler", 0);
            this.append(sb, "Executes the endpoint enabler ant task on the EAR archive.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "earFile (Default: ${project.artifact.file})", 2);
                this.append(sb, "The earFile to process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "was6:help", 0);
            this.append(sb, "Display help information on was6-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0was6:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "installApp".equals(this.goal)) {
            this.append(sb, "was6:installApp", 0);
            this.append(sb, "Installs an EAR into WebSphere Application Server.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the application that you wish to administer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conntype (Default: NONE)", 2);
                this.append(sb, "Specifies the type of connection to be used. Valid values are: SOAP, RMI or NONE.", 3);
                this.append(sb, "", 0);
                this.append(sb, "earFile (Default: ${project.artifact.file})", 2);
                this.append(sb, "EAR archive to deploy.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "The host to connect to. This will also be used as the keys to lookup userId/password from settings.xml, if not specified in the username and/or password parameter in the plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Password to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "The port on the host to connect to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profile", 2);
                this.append(sb, "Optional script file to be executed before the main command or file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "The profile name of the desired server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Optional java properties file containing attributes to set in the JVM System properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "roles", 2);
                this.append(sb, "The security roles mapping information to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetCell", 2);
                this.append(sb, "The target cell for deployment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetCluster", 2);
                this.append(sb, "Name of target cluster to deploy to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetNode", 2);
                this.append(sb, "The target node for deployment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "targetServer", 2);
                this.append(sb, "The target server for deployment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateExisting (Default: true)", 2);
                this.append(sb, "Flag for updating existing application or installing a brand new.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "user ID to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "servicedeploy".equals(this.goal)) {
            this.append(sb, "was6:servicedeploy", 0);
            this.append(sb, "Executes the ServiceDeploy command against an archive file (Ear, Zip or Jar) to produce an ear file that can be deployed on Process Server.\nReference Documentation can be found IBM WebSphere Enterprise Service Bus, Version 6.1, IBM WebSphere Process Server, Version 6.1.\n", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classPath", 2);
                this.append(sb, "The classPath attribute is optional and controls which external archives (jar, rar, and zip) should be appended to the classpath. By default, no external archives are used during deployment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "clean", 2);
                this.append(sb, "The clean attribute attribute is optional and is passed to eclipse so that eclipse will regenerate its stored plugin configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "cleanStagingModules", 2);
                this.append(sb, "The cleanStagingModules attribute is optional and controls whether imported staging modules should be deleted before running the deployer. By default, imported staging modules are not deleted.", 3);
                this.append(sb, "", 0);
                this.append(sb, "debug", 2);
                this.append(sb, "The file that contains plugin-specific trace enablement settings. The debug attribute is optional and may be used to specify a trace .options file to enable eclipse-based tracing.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileEncoding", 2);
                this.append(sb, "The fileEncoding attribute is optional and specifies the default file encoding that should be used by eclipse.", 3);
                this.append(sb, "", 0);
                this.append(sb, "freeForm", 2);
                this.append(sb, "The freeForm attribute is optional and controls whether jsp and html files will be copied from the optional j2ee folder of an sca jar file and copied to the generated war file. By default, jsp and html files are not copied into the war file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreErrors", 2);
                this.append(sb, "The ignoreErrors attribute is optional and controls whether an ear file should be generated despite validation errors. By default, an ear file will not be generated if validation errors were flagged during deployment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "javaDebug", 2);
                this.append(sb, "The file that contains plugin-specific trace enablement settings. The javaDebug attribute is optional and may be used to indicate that all debug information should be included in generated class files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keep", 2);
                this.append(sb, "The keep attribute is optional and controls whether the generated eclipse workspace should be preserved when the deployer task is complete. By default, the generated eclipse workspace is deleted after deployment.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noJ2EEDeploy", 2);
                this.append(sb, "The noJ2EEDeploy attribute is optional and controls whether the J2EE deployers, including ejbDeploy, should be skipped during deployment. The J2EE deployers will execute by default.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputApplication (Default: ${project.artifact.file})", 2);
                this.append(sb, "The outputApplication attribute is optional and controls the name and location of the generated J2EE ear file. If this attribute is not specified, then the ear file will be named according to the sca module name and will be generated in the location from which the ANT process was launched.", 3);
                this.append(sb, "", 0);
                this.append(sb, "progressMonitor (Default: none)", 2);
                this.append(sb, "The progressMonitor attribute is optional and controls how progress should be displayed to the console. Legal values include none, meter, or message. The default progressMonitor is none.", 3);
                this.append(sb, "", 0);
                this.append(sb, "scaModule", 2);
                this.append(sb, "The scaModule attribute is required and specifies the .jar, .zip or .ear file that contains the application to be deployed. If the command is not issued from the path in which the file resides, this must be the full path for the file. The .zip file can be either a nested archive that contains jars of Libraries or Modules or it can be an Eclipse Project Interchange format file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipXsdValidate", 2);
                this.append(sb, "The skipXsdValidate attribute is optional and specifies that the XSD schema validation will be skipped. This parameter is not available in the base product, as it was introduced in a later fixpack as a workaround for various issues.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "vmArgs", 2);
                this.append(sb, "The vmArgs attribute is optional and may be used to specify jvm arguments for the deploy process. They are space separated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsAdmin".equals(this.goal)) {
            this.append(sb, "was6:wsAdmin", 0);
            this.append(sb, "The wsadmin goal executes the WebSphere command-line administration tool with the specified arguments.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "args", 2);
                this.append(sb, "Arguments passed to the script.", 3);
                this.append(sb, "", 0);
                this.append(sb, "command", 2);
                this.append(sb, "A single command to be passed to the script processor. Either specify this or script", 3);
                this.append(sb, "", 0);
                this.append(sb, "conntype (Default: SOAP)", 2);
                this.append(sb, "The Default type is SOAP. Valid values are SOAP, RMI, and NONE. NONE means that no server connection is made.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "The host attribute is optional and only specified if the conntype is specified. It contains the hostname of the machine to connect to", 3);
                this.append(sb, "", 0);
                this.append(sb, "jvmMaxMemory (Default: 256M)", 2);
                this.append(sb, "sets maximum size of the memory for the underlying VM.", 3);
                this.append(sb, "", 0);
                this.append(sb, "language", 2);
                this.append(sb, "The language to be used to interpret scripts. Valid values are: 'jacl', 'javascript' or 'jython'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Contains the password to authenticate with.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "The port on the host to connect to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profile", 2);
                this.append(sb, "A script file to be executed before the main command or file", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "Name of the server profile to use", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "A java properties file containing attributes to set in the JVM System properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "script", 2);
                this.append(sb, "A file containing a set of commands in a file to be passed to the script processor. Either specify this parameter or command", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "user", 2);
                this.append(sb, "Contains the user ID to authenticate with.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsDefaultBindings".equals(this.goal)) {
            this.append(sb, "was6:wsDefaultBindings", 0);
            this.append(sb, "This goal enables you to generate default IBM WebSphere Bindings for the specified EAR file. The goal provides options to control how the bindings are generated and mimics the options provided by the WebSphere Application Install wizards. The goal binds to the package phase by default.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dbPassword", 2);
                this.append(sb, "Specifies the password associated with the default data source.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dbUser", 2);
                this.append(sb, "Specifies the user associated with the default data source.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultConnectionFactory", 2);
                this.append(sb, "Specifies the default connection factory to be used for all EJB 2.x CMPs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "defaultDataSource", 2);
                this.append(sb, "Specifies an optional default data source JNDI name to be used for all EJB 1.x CMPs.", 3);
                this.append(sb, "", 0);
                this.append(sb, "earFile (Default: ${project.artifact.file})", 2);
                this.append(sb, "EAR archive to generate bindings for.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ejbJndiPrefix", 2);
                this.append(sb, "Specifies a prefix that is prepended to any generated EJB JNDI names. The default is 'ejb'.", 3);
                this.append(sb, "", 0);
                this.append(sb, "exportFile", 2);
                this.append(sb, "When specified, it points to a file that will be generated containing the bindings information. This file is in the custom strategy format.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "forceBindings (Default: false)", 2);
                this.append(sb, "When false, any pre-existing bindings will not be altered. When true, new bindings are completely generated.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "resAuth", 2);
                this.append(sb, "Specifies the resource authorization on the connection factory for EJB 2.x CMPs.\nLegal values are: PerConnFact or Container", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "strategy", 2);
                this.append(sb, "When specified, this attribute points to a custom strategy file that further affects the bindings. See the properties/dfltbndngs.dtd of your WebSphere installation for more details.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "virtualHost", 2);
                this.append(sb, "Specifies the virtual host for all wars in the application.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsListApps".equals(this.goal)) {
            this.append(sb, "was6:wsListApps", 0);
            this.append(sb, "Lists all the applications installed on a WebSphere Server or Cell. This goal is a wrapper for the AdminApp.list() command of the wsadmin tool. Refer to the wsadmin documentation for information on this operation.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "conntype", 2);
                this.append(sb, "Valid values are SOAP, RMI, JMS, and NONE. NONE means that no server connection is made.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "host", 2);
                this.append(sb, "The host attribute is optional and only specified if the conntype is specified. It contains the hostname of the machine to connect to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "The password to authenticate with.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "Only needed if the conntype is specified. It contains the port on the host to connect to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profile", 2);
                this.append(sb, "A script file to be executed before the main command or file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "The name of the server profile to be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "properties file containing attributes to set in the JVM System properties.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "user", 2);
                this.append(sb, "The user ID to authenticate with.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsStartApp".equals(this.goal)) {
            this.append(sb, "was6:wsStartApp", 0);
            this.append(sb, "The wsStartApplication goal enables you to start an existing or newly installed application on a WebSphere Server or in a WebSphere Cell.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the application that you wish to administer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conntype (Default: NONE)", 2);
                this.append(sb, "Specifies the type of connection to be used. Valid values are: SOAP, RMI or NONE.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "The host to connect to. This will also be used as the keys to lookup userId/password from settings.xml, if not specified in the username and/or password parameter in the plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "node", 2);
                this.append(sb, "Optional parameter specifying the name of the node containing the application you wish to stop.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Password to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "The port on the host to connect to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profile", 2);
                this.append(sb, "Optional script file to be executed before the main command or file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "The profile name of the desired server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Optional java properties file containing attributes to set in the JVM System properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "server (Default: server1)", 2);
                this.append(sb, "Optional parameter specifying the name of the server containing the application you wish to start.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "user ID to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsStartServer".equals(this.goal)) {
            this.append(sb, "was6:wsStartServer", 0);
            this.append(sb, "Starts a standalone server instance. This is not used to start a server controlled by DeploymentManager. Therefore, this goal is useful for the Base Application Server, and to start the Node Agent and/or DeploymentManager. If you wish to start a server managed by the Deployment Manager, use the wsadmin task to execute a scripting command.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Specifies the name of the file to log the server start information to. If none is specified maven default will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "If true, the task with return immediately without waiting for the server to start.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Optional. Specifies the password of the admin user to authenticate with for administrative access.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "The profile name of the desired server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "If true, the task will not print any status information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "replaceLog (Default: false)", 2);
                this.append(sb, "If true, the task with erase an existing log file, instead of appending", 3);
                this.append(sb, "", 0);
                this.append(sb, "script", 2);
                this.append(sb, "Specifies the name of a optional script file to execute during server startup.", 3);
                this.append(sb, "", 0);
                this.append(sb, "server (Default: server1)", 2);
                this.append(sb, "Name of the server to start.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "statusPort", 2);
                this.append(sb, "Optional. Specifies the TCP Port the server should send status messages to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout", 2);
                this.append(sb, "Optional. Wait the specified the amount of time in seconds to wait for the server to successfully start.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trace (Default: false)", 2);
                this.append(sb, "If true, the task with print trace information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Optional. Specifies the id of the admin user to authenticate with for administrative access.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsStopApp".equals(this.goal)) {
            this.append(sb, "was6:wsStopApp", 0);
            this.append(sb, "The wsStopApp goal enables you to stop an existing or newly installed application on a WebSphere Server or in a WebSphere Cell. This goal is a wrapper for the ApplicationManager.stopApplication() command of the wsadmin tool. Refer to the wsadmin documentation for information on this operation.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the application that you wish to administer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conntype (Default: NONE)", 2);
                this.append(sb, "Specifies the type of connection to be used. Valid values are: SOAP, RMI or NONE.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "The host to connect to. This will also be used as the keys to lookup userId/password from settings.xml, if not specified in the username and/or password parameter in the plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "node", 2);
                this.append(sb, "Optional parameter specifying the name of the node containing the application you wish to stop.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Password to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "The port on the host to connect to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profile", 2);
                this.append(sb, "Optional script file to be executed before the main command or file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "The profile name of the desired server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Optional java properties file containing attributes to set in the JVM System properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "server (Default: server1)", 2);
                this.append(sb, "Optional parameter specifying the name of the server containing the application you wish to stop.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "user ID to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsStopServer".equals(this.goal)) {
            this.append(sb, "was6:wsStopServer", 0);
            this.append(sb, "This goal enables you to stop a standalone server instance. This is not used to stop a server controlled by DeploymentManager. Therefore, this task is useful for the Base Application Server, and to stop the Node Agent and/or DeploymentManager. If you wish to stop a server managed by the Deployment Manager, use the wsadmin task to execute a scripting command.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "conntype (Default: SOAP)", 2);
                this.append(sb, "Specifies the type of connection to be used. Valid values are: SOAP or RMI", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Specifies the name of the file to log the server start information to. If none is specified maven default will be used.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noWait (Default: false)", 2);
                this.append(sb, "If true, the task with return immediately without waiting for the server to start.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Optional. Specifies the password of the admin user to authenticate with for administrative access.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "Admin port of the server you wish to stop.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "The profile name of the desired server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "If true, the task will not print any status information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "replaceLog (Default: false)", 2);
                this.append(sb, "If true, the task with erase an existing log file, instead of appending", 3);
                this.append(sb, "", 0);
                this.append(sb, "server (Default: server1)", 2);
                this.append(sb, "Name of the server to start.", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "statusPort", 2);
                this.append(sb, "Optional. Specifies the TCP Port the server should send status messages to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "timeout", 2);
                this.append(sb, "Optional. Wait the specified the amount of time in seconds to wait for the server to successfully start.", 3);
                this.append(sb, "", 0);
                this.append(sb, "trace (Default: false)", 2);
                this.append(sb, "If true, the task with print trace information.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "Optional. Specifies the id of the admin user to authenticate with for administrative access.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "wsUninstallApp".equals(this.goal)) {
            this.append(sb, "was6:wsUninstallApp", 0);
            this.append(sb, "Enables you to uninstall an existing application from a WebSphere Server or Cell. This goal builds upon the wsadmin task and shares many of the same attributes. This task is a wrapper for the AdminApp.uninstall() command of the wsadmin tool.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "applicationName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The name of the application that you wish to administer.", 3);
                this.append(sb, "", 0);
                this.append(sb, "conntype (Default: NONE)", 2);
                this.append(sb, "Specifies the type of connection to be used. Valid values are: SOAP, RMI or NONE.", 3);
                this.append(sb, "", 0);
                this.append(sb, "failOnError (Default: true)", 2);
                this.append(sb, "Fail build on errors.", 3);
                this.append(sb, "", 0);
                this.append(sb, "host (Default: localhost)", 2);
                this.append(sb, "The host to connect to. This will also be used as the keys to lookup userId/password from settings.xml, if not specified in the username and/or password parameter in the plugin.", 3);
                this.append(sb, "", 0);
                this.append(sb, "logFile", 2);
                this.append(sb, "Optional log file to log execution of ws_ant to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "password", 2);
                this.append(sb, "Password to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "port", 2);
                this.append(sb, "The port on the host to connect to.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profile", 2);
                this.append(sb, "Optional script file to be executed before the main command or file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "profileName", 2);
                this.append(sb, "The profile name of the desired server.", 3);
                this.append(sb, "", 0);
                this.append(sb, "properties", 2);
                this.append(sb, "Optional java properties file containing attributes to set in the JVM System properties", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip (Default: false)", 2);
                this.append(sb, "Skip execution.", 3);
                this.append(sb, "", 0);
                this.append(sb, "username", 2);
                this.append(sb, "user ID to authenticate with. This takes precedence over values defined in settings.xml.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Specifies a verbose execution to help debug.", 3);
                this.append(sb, "", 0);
                this.append(sb, "wasHome (Default: ${env.WAS_HOME})", 2);
                this.append(sb, "Root install location of WebSphere 6.1", 3);
                this.append(sb, "", 0);
                this.append(sb, "workingDirectory", 2);
                this.append(sb, "Working directory for plugin.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

