/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.wagon.shared;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.apache.maven.artifact.repository.metadata.Metadata;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Reader;
import org.apache.maven.artifact.repository.metadata.io.xpp3.MetadataXpp3Writer;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.codehaus.mojo.wagon.shared.MavenRepoMerger;
import org.codehaus.mojo.wagon.shared.WagonDownload;
import org.codehaus.mojo.wagon.shared.WagonFileSet;
import org.codehaus.mojo.wagon.shared.WagonUpload;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class DefaultMavenRepoMerger
implements MavenRepoMerger {
    private WagonDownload downloader;
    private WagonUpload uploader;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(Wagon src, Wagon target, boolean optimize, Log logger) throws WagonException, IOException {
        File downloadSrcDir = DefaultMavenRepoMerger.createTempDirectory("wagon-maven-plugin");
        WagonFileSet srcFileSet = new WagonFileSet();
        srcFileSet.setDownloadDirectory(downloadSrcDir);
        String[] excludes = new String[]{".*/**", "archetype-catalog.xml*"};
        srcFileSet.setExcludes(excludes);
        try {
            this.downloader.download(src, srcFileSet, logger);
            DirectoryScanner scanner = new DirectoryScanner();
            scanner.setBasedir(downloadSrcDir);
            String[] includes = new String[]{"**/maven-metadata.xml"};
            scanner.setIncludes(includes);
            scanner.scan();
            String[] files = scanner.getIncludedFiles();
            for (int i = 0; i < files.length; ++i) {
                File srcMetadaFile = new File(downloadSrcDir, files[i] + ".rip");
                try {
                    target.get(files[i].replace('\\', '/'), srcMetadaFile);
                }
                catch (ResourceDoesNotExistException e) {
                    continue;
                }
                try {
                    this.mergeMetadata(srcMetadaFile, logger);
                    continue;
                }
                catch (XmlPullParserException e) {
                    throw new IOException("Metadata file is corrupt " + files[i] + " Reason: " + e.getMessage());
                }
            }
            FileSet tobeUploadedFileSet = new FileSet();
            tobeUploadedFileSet.setDirectory(downloadSrcDir.getAbsolutePath());
            this.uploader.upload(target, tobeUploadedFileSet, optimize, logger);
        }
        finally {
            FileUtils.deleteDirectory((File)downloadSrcDir);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeMetadata(File existingMetadata, Log logger) throws IOException, XmlPullParserException {
        FileWriter stagedMetadataWriter = null;
        FileReader existingMetadataReader = null;
        FileReader stagedMetadataReader = null;
        File stagedMetadataFile = null;
        try {
            MetadataXpp3Reader xppReader = new MetadataXpp3Reader();
            MetadataXpp3Writer xppWriter = new MetadataXpp3Writer();
            existingMetadataReader = new FileReader(existingMetadata);
            Metadata existing = xppReader.read((Reader)existingMetadataReader);
            stagedMetadataFile = new File(existingMetadata.getParentFile(), "maven-metadata.xml");
            stagedMetadataReader = new FileReader(stagedMetadataFile);
            Metadata staged = xppReader.read((Reader)stagedMetadataReader);
            existing.merge(staged);
            stagedMetadataWriter = new FileWriter(stagedMetadataFile);
            xppWriter.write((Writer)stagedMetadataWriter, existing);
            logger.info((CharSequence)("Merging metadata file: " + stagedMetadataFile));
        }
        catch (Throwable throwable) {
            IOUtil.close(stagedMetadataWriter);
            IOUtil.close(stagedMetadataReader);
            IOUtil.close(existingMetadataReader);
            existingMetadata.delete();
            throw throwable;
        }
        IOUtil.close((Writer)stagedMetadataWriter);
        IOUtil.close((Reader)stagedMetadataReader);
        IOUtil.close((Reader)existingMetadataReader);
        existingMetadata.delete();
        try {
            File newMd5 = new File(stagedMetadataFile.getParentFile(), "maven-metadata.xml.md5");
            FileUtils.fileWrite((String)newMd5.getAbsolutePath(), (String)this.checksum(stagedMetadataFile, "md5"));
            File newSha1 = new File(stagedMetadataFile.getParentFile(), "maven-metadata.xml.sha1");
            FileUtils.fileWrite((String)newSha1.getAbsolutePath(), (String)this.checksum(stagedMetadataFile, "sha1"));
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private String checksum(File file, String type) throws IOException, NoSuchAlgorithmException {
        int i;
        MessageDigest md5 = MessageDigest.getInstance(type);
        FileInputStream is = new FileInputStream(file);
        byte[] buf = new byte[8192];
        while ((i = ((InputStream)is).read(buf)) > 0) {
            md5.update(buf, 0, i);
        }
        IOUtil.close((InputStream)is);
        return this.encode(md5.digest());
    }

    private String encode(byte[] binaryData) {
        if (binaryData.length != 16 && binaryData.length != 20) {
            int bitLength = binaryData.length * 8;
            throw new IllegalArgumentException("Unrecognised length for binary data: " + bitLength + " bits");
        }
        String retValue = "";
        for (int i = 0; i < binaryData.length; ++i) {
            String t = Integer.toHexString(binaryData[i] & 0xFF);
            retValue = t.length() == 1 ? retValue + "0" + t : retValue + t;
        }
        return retValue.trim();
    }

    public static File createTempDirectory(String prefix) throws IOException {
        File temp = File.createTempFile(prefix, Long.toString(System.nanoTime()));
        if (!temp.delete()) {
            throw new IOException("Could not delete temp file: " + temp.getAbsolutePath());
        }
        if (!temp.mkdir()) {
            throw new IOException("Could not create temp directory: " + temp.getAbsolutePath());
        }
        return temp;
    }
}

