/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Collection;
import java.util.Iterator;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.metadata.ArtifactMetadataRetrievalException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsDependencyUpdaterMojo;
import org.codehaus.mojo.versions.api.ArtifactVersions;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UseNextVersionsMojo
extends AbstractVersionsDependencyUpdaterMojo {
    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        try {
            if (this.getProject().getDependencyManagement() != null && this.isProcessingDependencyManagement()) {
                this.useNextVersions(pom, this.getProject().getDependencyManagement().getDependencies());
            }
            if (this.isProcessingDependencies()) {
                this.useNextVersions(pom, this.getProject().getDependencies());
            }
        }
        catch (ArtifactMetadataRetrievalException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private void useNextVersions(ModifiedPomXMLEventReader pom, Collection dependencies) throws XMLStreamException, MojoExecutionException, ArtifactMetadataRetrievalException {
        Iterator i = dependencies.iterator();
        while (i.hasNext()) {
            Dependency dep = (Dependency)i.next();
            if (this.isExcludeReactor() && this.isProducedByReactor(dep)) {
                this.getLog().info((CharSequence)("Ignoring reactor dependency: " + this.toString(dep)));
                continue;
            }
            String version = dep.getVersion();
            Artifact artifact = this.toArtifact(dep);
            if (!this.isIncluded(artifact)) continue;
            this.getLog().debug((CharSequence)("Looking for newer versions of " + this.toString(dep)));
            ArtifactVersions versions = this.getHelper().lookupArtifactVersions(artifact, Boolean.TRUE.equals(this.allowSnapshots));
            ArtifactVersion[] newer = versions.getNewerVersions(version, false);
            if (newer.length <= 0) continue;
            String newVersion = newer[0].toString();
            if (!PomHelper.setDependencyVersion(pom, dep.getGroupId(), dep.getArtifactId(), version, newVersion)) continue;
            this.getLog().info((CharSequence)("Updated " + this.toString(dep) + " to version " + newVersion));
        }
    }
}

