/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.versions;

import java.util.Iterator;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.codehaus.mojo.versions.AbstractVersionsUpdaterMojo;
import org.codehaus.mojo.versions.Property;
import org.codehaus.mojo.versions.api.PomHelper;
import org.codehaus.mojo.versions.api.PropertyVersions;
import org.codehaus.mojo.versions.rewriting.ModifiedPomXMLEventReader;

public class UpdatePropertiesMojo
extends AbstractVersionsUpdaterMojo {
    private Property[] properties;
    private String includeProperties = null;
    private String excludeProperties = null;
    private Boolean autoLinkItems;

    protected void update(ModifiedPomXMLEventReader pom) throws MojoExecutionException, MojoFailureException, XMLStreamException {
        Map propertyVersions = this.getHelper().getVersionPropertiesMap(this.getProject(), this.properties, this.includeProperties, this.excludeProperties, !Boolean.FALSE.equals(this.autoLinkItems));
        Iterator i = propertyVersions.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            Property property = (Property)entry.getKey();
            PropertyVersions version = (PropertyVersions)entry.getValue();
            String currentVersion = this.getProject().getProperties().getProperty(property.getName());
            if (currentVersion == null) continue;
            ArtifactVersion winner = version.getNewestVersion(currentVersion, property, this.allowSnapshots, this.reactorProjects, this.getHelper());
            if (winner == null || currentVersion.equals(winner.toString())) {
                this.getLog().info((CharSequence)("Property ${" + property.getName() + "}: Leaving unchanged as " + currentVersion));
                continue;
            }
            if (!PomHelper.setPropertyVersion(pom, version.getProfileId(), property.getName(), winner.toString())) continue;
            this.getLog().info((CharSequence)("Updated ${" + property.getName() + "} from " + currentVersion + " to " + winner));
        }
    }
}

