/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.tidy;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.stax2.XMLInputFactory2;

public class PomTidy {
    private static final String LS = System.getProperty("line.separator");
    private static final SectionSorter PROJECT_SORTER = new SectionSorter("/project", new NodeGroup("modelVersion"), new NodeGroup("parent"), new NodeGroup("groupId", "artifactId", "version", "packaging"), new NodeGroup("name", "description", "url", "inceptionYear", "organization", "licenses"), new NodeGroup("developers", "contributors"), new NodeGroup("mailingLists"), new NodeGroup("prerequisites"), new NodeGroup("modules"), new NodeGroup("scm", "issueManagement", "ciManagement", "distributionManagement"), new NodeGroup("properties"), new NodeGroup("repositories", "pluginRepositories"), new NodeGroup("dependencyManagement", "dependencies"), new NodeGroup("build"), new NodeGroup("reporting"), new NodeGroup("profiles"));
    private static final SectionSorter BUILD_SORTER = new SectionSorter("/project/build", new NodeGroup("defaultGoal", "sourceDirectory", "scriptSourceDirectory", "testSourceDirectory", "directory", "outputDirectory", "testOutputDirectory", "finalName", "filters", "resources", "testResources", "pluginManagement", "plugins", "extensions"));

    public String tidy(String pom) throws XMLStreamException {
        pom = this.addXmlHeader(pom);
        pom = BUILD_SORTER.sortSections(pom);
        return PROJECT_SORTER.sortSections(pom);
    }

    private String addXmlHeader(String input) throws XMLStreamException {
        if (input.indexOf("<?xml") != 0) {
            return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" + LS + input;
        }
        return input;
    }

    private static class NodeGroup {
        final List<String> nodes;

        NodeGroup(String ... nodes) {
            this.nodes = Arrays.asList(nodes);
        }
    }

    private static class IndentCalculator {
        final boolean useTab;

        IndentCalculator(boolean useTab) {
            this.useTab = useTab;
        }

        int getIndent(String input, int lastEnd, int pos) {
            String posChar;
            int indent = 0;
            while (pos > lastEnd && StringUtils.isWhitespace((String)(posChar = input.substring(pos, pos + 1))) && !"\n".equals(posChar) && !"\r".equals(posChar)) {
                if ("\t".equals(posChar) == this.useTab) {
                    ++indent;
                }
                --pos;
            }
            return indent;
        }
    }

    private static class SectionSorter {
        static final IndentCalculator SPACE_INDENT_CALCULATOR = new IndentCalculator(false);
        static final IndentCalculator TAB_INDENT_CALCULATOR = new IndentCalculator(true);
        final String scope;
        final NodeGroup[] groups;
        final String[] sequence;

        SectionSorter(String scope, NodeGroup ... groups) {
            this.scope = scope;
            this.groups = groups;
            this.sequence = this.calculateSequence(groups);
        }

        String[] calculateSequence(NodeGroup[] groups) {
            ArrayList<String> sequence = new ArrayList<String>();
            for (NodeGroup group : groups) {
                sequence.addAll(group.nodes);
            }
            return sequence.toArray(new String[sequence.size()]);
        }

        String sortSections(String input) throws XMLStreamException {
            XMLInputFactory inputFactory = XMLInputFactory2.newInstance();
            inputFactory.setProperty("org.codehaus.stax2.preserveLocation", Boolean.TRUE);
            int first = Integer.MAX_VALUE;
            int last = Integer.MIN_VALUE;
            String outdent = "";
            int[] starts = new int[this.sequence.length];
            int[] ends = new int[this.sequence.length];
            block0: for (int i = 0; i < this.sequence.length; ++i) {
                Pattern matchScopeRegex = Pattern.compile("\\Q" + this.scope + "\\E");
                Pattern matchTargetRegex = Pattern.compile("\\Q" + this.scope + "\\E/\\Q" + this.sequence[i] + "\\E");
                Stack<String> stack = new Stack<String>();
                String path = "";
                boolean inMatchScope = false;
                int start = -1;
                ends[i] = -1;
                starts[i] = -1;
                XMLEventReader pom = inputFactory.createXMLEventReader(new StringReader(input));
                while (pom.hasNext()) {
                    XMLEvent event = pom.nextEvent();
                    if (event.isStartElement()) {
                        stack.push(path);
                        String elementName = event.asStartElement().getName().getLocalPart();
                        path = path + "/" + elementName;
                        if (matchScopeRegex.matcher(path).matches()) {
                            inMatchScope = true;
                            start = -1;
                        } else if (inMatchScope && matchTargetRegex.matcher(path).matches()) {
                            start = event.getLocation().getCharacterOffset();
                        }
                    }
                    if (!event.isEndElement()) continue;
                    if (matchTargetRegex.matcher(path).matches() && start != -1) {
                        starts[i] = start;
                        ends[i] = pom.peek().getLocation().getCharacterOffset();
                        first = Math.min(first, starts[i]);
                        last = Math.max(last, ends[i]);
                        continue block0;
                    }
                    if (matchScopeRegex.matcher(path).matches()) {
                        String before = input.substring(0, event.getLocation().getCharacterOffset());
                        int posLineStart = Math.max(before.lastIndexOf(10), before.lastIndexOf(10));
                        outdent = before.substring(posLineStart + 1);
                        inMatchScope = false;
                        start = -1;
                    }
                    path = (String)stack.pop();
                }
            }
            int spaceIndentTotal = 0;
            int tabIndentTotal = 0;
            int indentCount = 0;
            int lastEnd = 0;
            for (int i = 0; i < this.sequence.length; ++i) {
                if (starts[i] == -1) continue;
                int pos = starts[i] - 1;
                spaceIndentTotal += SPACE_INDENT_CALCULATOR.getIndent(input, lastEnd, pos);
                tabIndentTotal += TAB_INDENT_CALCULATOR.getIndent(input, lastEnd, pos);
                ++indentCount;
            }
            int averageSpaceIndent = indentCount == 0 ? 2 : spaceIndentTotal / indentCount;
            int averageTabIndent = indentCount == 0 ? 0 : tabIndentTotal / indentCount;
            String indent = StringUtils.repeat((String)"\t", (int)averageTabIndent) + StringUtils.repeat((String)" ", (int)averageSpaceIndent);
            if (first > last) {
                return input;
            }
            StringBuilder output = new StringBuilder(input.length() + 1024);
            output.append(input.substring(0, first).trim());
            int i = 0;
            boolean firstGroupStarted = false;
            for (NodeGroup group : this.groups) {
                boolean groupStarted = false;
                for (int j = i; j < i + group.nodes.size(); ++j) {
                    if (starts[j] == -1) continue;
                    if (firstGroupStarted && !groupStarted) {
                        output.append(LS);
                    }
                    this.addTextIfNotEmpty(output, indent, this.getPrecedingText(input, starts[j], ends));
                    this.addTextIfNotEmpty(output, indent, input.substring(starts[j], ends[j]));
                    groupStarted = true;
                    firstGroupStarted = true;
                }
                i += group.nodes.size();
            }
            this.addTextIfNotEmpty(output, outdent, input.substring(last));
            output.append(LS);
            return output.toString();
        }

        private String getPrecedingText(String pom, int start, int[] ends) {
            int l = -1;
            for (int k = 0; k < this.sequence.length; ++k) {
                if (ends[k] == -1 || l != -1 && ends[l] >= ends[k] || ends[k] >= start) continue;
                l = k;
            }
            if (l != -1) {
                return pom.substring(ends[l], start);
            }
            return "";
        }

        private void addTextIfNotEmpty(StringBuilder output, String indent, String text) {
            String trimmedText = text.trim();
            if (trimmedText.length() != 0) {
                output.append(LS);
                output.append(indent);
                output.append(trimmedText);
            }
        }
    }
}

