/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.surefire;

import java.io.File;
import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.ResourceBundle;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.mojo.surefire.ReportTestCase;
import org.codehaus.mojo.surefire.ReportTestSuite;
import org.codehaus.mojo.surefire.SurefireReportParser;

public class SurefireReportGenerator {
    private SurefireReportParser report;
    private List testSuites;

    public SurefireReportGenerator(File reportsDirectory) {
        this.report = new SurefireReportParser(reportsDirectory);
    }

    public void doGenerateReport(ResourceBundle bundle, Sink sink) throws MavenReportException {
        this.testSuites = this.report.parseXMLReportFiles();
        try {
            sink.head();
            sink.text(bundle.getString("report.surefire.description"));
            sink.head_();
            sink.body();
            this.constructSummarySection(bundle, sink);
            this.constructPackagesSection(bundle, sink);
            this.constructTestCasesSection(bundle, sink);
            this.constructFailureDetails(sink, this.testSuites, bundle);
            this.sinkLineBreak(sink);
            sink.body_();
            sink.flush();
            sink.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void constructSummarySection(ResourceBundle bundle, Sink sink) {
        Map summary = this.report.getSummary(this.testSuites);
        sink.sectionTitle1();
        this.sinkAnchor(sink, "Summary");
        sink.text(bundle.getString("report.surefire.label.summary"));
        sink.sectionTitle1_();
        this.constructHotLinks(sink, bundle);
        this.sinkLineBreak(sink);
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.surefire.label.tests"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.errors"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.failures"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.successrate"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.time"));
        sink.tableRow_();
        sink.tableRow();
        this.sinkCell(sink, (String)summary.get("totalTests"));
        this.sinkCell(sink, (String)summary.get("totalErrors"));
        this.sinkCell(sink, (String)summary.get("totalFailures"));
        this.sinkCell(sink, (String)summary.get("totalPercentage") + "%");
        this.sinkCell(sink, (String)summary.get("totalElapsedTime"));
        sink.tableRow_();
        sink.table_();
        sink.lineBreak();
        sink.rawText(bundle.getString("report.surefire.text.note1"));
        this.sinkLineBreak(sink);
    }

    private void constructPackagesSection(ResourceBundle bundle, Sink sink) {
        List testSuiteList;
        String packageName;
        HashMap suitePackages = this.report.getSuitesGroupByPackage(this.testSuites);
        DecimalFormat decFormat = new DecimalFormat("##0.00");
        if (suitePackages.isEmpty()) {
            return;
        }
        sink.sectionTitle1();
        this.sinkAnchor(sink, "Package_List");
        sink.text(bundle.getString("report.surefire.label.packagelist"));
        sink.sectionTitle1_();
        this.constructHotLinks(sink, bundle);
        this.sinkLineBreak(sink);
        sink.table();
        sink.tableRow();
        this.sinkHeader(sink, bundle.getString("report.surefire.label.package"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.tests"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.errors"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.failures"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.successrate"));
        this.sinkHeader(sink, bundle.getString("report.surefire.label.time"));
        sink.tableRow_();
        Iterator packIter = suitePackages.keySet().iterator();
        while (packIter.hasNext()) {
            sink.tableRow();
            packageName = (String)packIter.next();
            testSuiteList = (List)suitePackages.get(packageName);
            Map packageSummary = this.report.getSummary(testSuiteList);
            this.sinkCellLink(sink, packageName, "#" + packageName);
            this.sinkCell(sink, (String)packageSummary.get("totalTests"));
            this.sinkCell(sink, (String)packageSummary.get("totalErrors"));
            this.sinkCell(sink, (String)packageSummary.get("totalFailures"));
            this.sinkCell(sink, (String)packageSummary.get("totalPercentage") + "%");
            this.sinkCell(sink, (String)packageSummary.get("totalElapsedTime"));
            sink.tableRow_();
        }
        sink.table_();
        sink.lineBreak();
        sink.rawText(bundle.getString("report.surefire.text.note2"));
        packIter = suitePackages.keySet().iterator();
        while (packIter.hasNext()) {
            packageName = (String)packIter.next();
            testSuiteList = (List)suitePackages.get(packageName);
            Iterator suiteIterator = testSuiteList.iterator();
            sink.sectionTitle2();
            this.sinkAnchor(sink, packageName);
            sink.text(packageName);
            sink.sectionTitle2_();
            sink.table();
            sink.tableRow();
            this.sinkHeader(sink, "");
            this.sinkHeader(sink, bundle.getString("report.surefire.label.class"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.tests"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.errors"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.failures"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.successrate"));
            this.sinkHeader(sink, bundle.getString("report.surefire.label.time"));
            sink.tableRow_();
            while (suiteIterator.hasNext()) {
                ReportTestSuite suite = (ReportTestSuite)suiteIterator.next();
                sink.tableRow();
                sink.tableCell();
                sink.link("#" + suite.getPackageName() + suite.getName());
                if (suite.getNumberOfErrors() > 0) {
                    this.sinkIcon("error", sink);
                } else if (suite.getNumberOfFailures() > 0) {
                    this.sinkIcon("junit.framework", sink);
                } else {
                    this.sinkIcon("success", sink);
                }
                sink.link_();
                sink.tableCell_();
                this.sinkCellLink(sink, suite.getName(), "#" + suite.getPackageName() + suite.getName());
                this.sinkCell(sink, Integer.toString(suite.getNumberOfTests()));
                this.sinkCell(sink, Integer.toString(suite.getNumberOfErrors()));
                this.sinkCell(sink, Integer.toString(suite.getNumberOfFailures()));
                String percentage = this.report.computePercentage(suite.getNumberOfTests(), suite.getNumberOfErrors(), suite.getNumberOfFailures());
                this.sinkCell(sink, percentage + "%");
                this.sinkCell(sink, decFormat.format(suite.getTimeElapsed()));
                sink.tableRow_();
            }
            sink.table_();
        }
        this.sinkLineBreak(sink);
    }

    private void constructTestCasesSection(ResourceBundle bundle, Sink sink) {
        if (this.testSuites.isEmpty()) {
            return;
        }
        DecimalFormat decFormat = new DecimalFormat("##0.00");
        sink.sectionTitle1();
        this.sinkAnchor(sink, "Test_Cases");
        sink.text(bundle.getString("report.surefire.label.testcases"));
        sink.sectionTitle1_();
        this.constructHotLinks(sink, bundle);
        ListIterator suiteIterator = this.testSuites.listIterator();
        while (suiteIterator.hasNext()) {
            ReportTestSuite suite = (ReportTestSuite)suiteIterator.next();
            List testCases = suite.getTestCases();
            ListIterator caseIterator = testCases.listIterator();
            sink.sectionTitle2();
            this.sinkAnchor(sink, suite.getPackageName() + suite.getName());
            sink.text(suite.getName());
            sink.sectionTitle2_();
            sink.table();
            while (caseIterator.hasNext()) {
                ReportTestCase testCase = (ReportTestCase)caseIterator.next();
                sink.tableRow();
                sink.tableCell();
                if (testCase.getFailure() != null) {
                    sink.link("#" + testCase.getFullName());
                    this.sinkIcon((String)testCase.getFailure().get("type"), sink);
                    sink.link_();
                } else {
                    this.sinkIcon("success", sink);
                }
                sink.tableCell_();
                this.sinkCell(sink, testCase.getName());
                this.sinkCell(sink, decFormat.format(testCase.getTime()));
                sink.tableRow_();
                if (testCase.getFailure() == null) continue;
                sink.tableRow();
                this.sinkCell(sink, "");
                this.sinkCell(sink, (String)testCase.getFailure().get("message"));
                this.sinkCell(sink, "");
                sink.tableRow_();
            }
            sink.table_();
        }
        this.sinkLineBreak(sink);
    }

    private void constructFailureDetails(Sink sink, List testSuiteList, ResourceBundle bundle) {
        List failureList = this.report.getFailureDetails(testSuiteList);
        if (failureList.isEmpty()) {
            return;
        }
        Iterator failIter = failureList.iterator();
        if (failIter != null) {
            sink.sectionTitle1();
            this.sinkAnchor(sink, "Failure_Details");
            sink.text(bundle.getString("report.surefire.label.failuredetails"));
            sink.sectionTitle1_();
            this.constructHotLinks(sink, bundle);
            this.sinkLineBreak(sink);
            sink.table();
            while (failIter.hasNext()) {
                ReportTestCase tCase = (ReportTestCase)failIter.next();
                sink.tableRow();
                sink.tableCell();
                this.sinkIcon((String)tCase.getFailure().get("type"), sink);
                sink.tableCell_();
                this.sinkCellAnchor(sink, tCase.getName(), tCase.getFullName());
                sink.tableRow_();
                sink.tableRow();
                this.sinkCell(sink, "");
                this.sinkCell(sink, (String)tCase.getFailure().get("message"));
                sink.tableRow_();
                sink.tableRow();
                this.sinkCell(sink, "");
                this.sinkCell(sink, (String)tCase.getFailure().get("type") + ": " + (String)tCase.getFailure().get("message") + " " + (String)tCase.getFailure().get("detail"));
                sink.tableRow_();
            }
            sink.table_();
        }
        this.sinkLineBreak(sink);
    }

    private void constructHotLinks(Sink sink, ResourceBundle bundle) {
        if (this.testSuites.isEmpty()) {
            return;
        }
        sink.section2();
        sink.rawText("[");
        this.sinkLink(sink, bundle.getString("report.surefire.label.summary"), "#Summary");
        sink.rawText("]");
        sink.rawText("[");
        this.sinkLink(sink, bundle.getString("report.surefire.label.packagelist"), "#Package_List");
        sink.rawText("]");
        sink.rawText("[");
        this.sinkLink(sink, bundle.getString("report.surefire.label.testcases"), "#Test_Cases");
        sink.rawText("]");
        sink.section2_();
    }

    private void sinkLineBreak(Sink sink) {
        sink.table();
        sink.tableRow();
        sink.tableRow_();
        sink.tableRow();
        sink.tableRow_();
        sink.table_();
    }

    private void sinkIcon(String type, Sink sink) {
        sink.figure();
        if (type.startsWith("junit.framework")) {
            sink.figureGraphics("images/icon_warning_sml.gif");
        } else if (type.startsWith("success")) {
            sink.figureGraphics("images/icon_success_sml.gif");
        } else {
            sink.figureGraphics("images/icon_error_sml.gif");
        }
        sink.figure_();
    }

    private void sinkHeader(Sink sink, String header) {
        sink.tableHeaderCell();
        sink.text(header);
        sink.tableHeaderCell_();
    }

    private void sinkCell(Sink sink, String text) {
        sink.tableCell();
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkLink(Sink sink, String text, String link) {
        sink.link(link);
        sink.text(text);
        sink.link_();
    }

    private void sinkCellLink(Sink sink, String text, String link) {
        sink.tableCell();
        this.sinkLink(sink, text, link);
        sink.tableCell_();
    }

    private void sinkCellAnchor(Sink sink, String text, String anchor) {
        sink.tableCell();
        this.sinkAnchor(sink, anchor);
        sink.text(text);
        sink.tableCell_();
    }

    private void sinkAnchor(Sink sink, String anchor) {
        sink.anchor(anchor);
        sink.anchor_();
    }
}

