/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.sonar;

import java.io.IOException;
import java.util.Collections;
import org.apache.maven.artifact.repository.DefaultRepositoryRequest;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.MavenPluginManager;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.sonar.MavenPluginManagerHelper;
import org.codehaus.mojo.sonar.ServerMetadata;
import org.codehaus.plexus.configuration.PlexusConfiguration;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class Bootstraper {
    private ServerMetadata server;
    private MavenPluginManager pluginManager;
    private MavenPluginManagerHelper mavenPluginManagerHelper;

    public Bootstraper(ServerMetadata server, MavenPluginManager pluginManager, MavenPluginManagerHelper mavenPluginManagerHelper) {
        this.server = server;
        this.pluginManager = pluginManager;
        this.mavenPluginManagerHelper = mavenPluginManagerHelper;
    }

    public void start(MavenProject project, MavenSession session) throws IOException, MojoExecutionException {
        this.executeMojo(project, session);
    }

    private void executeMojo(MavenProject project, MavenSession session) throws MojoExecutionException {
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            DefaultRepositoryRequest repositoryRequest = new DefaultRepositoryRequest();
            repositoryRequest.setLocalRepository(session.getLocalRepository());
            repositoryRequest.setRemoteRepositories(project.getPluginArtifactRepositories());
            Plugin plugin = this.createSonarPlugin();
            PluginDescriptor pluginDescriptor = this.mavenPluginManagerHelper.getPluginDescriptor(plugin, session);
            String goal = "sonar";
            MojoDescriptor mojoDescriptor = pluginDescriptor.getMojo(goal);
            if (mojoDescriptor == null) {
                throw new MojoExecutionException("Unknown mojo goal: " + goal);
            }
            MojoExecution mojoExecution = new MojoExecution(plugin, goal, "sonar" + goal);
            mojoExecution.setConfiguration(this.convert(mojoDescriptor));
            mojoExecution.setMojoDescriptor(mojoDescriptor);
            this.mavenPluginManagerHelper.setupPluginRealm(pluginDescriptor, session, Thread.currentThread().getContextClassLoader(), Collections.<String>emptyList());
            Mojo mojo = (Mojo)this.pluginManager.getConfiguredMojo(Mojo.class, session, mojoExecution);
            Thread.currentThread().setContextClassLoader((ClassLoader)pluginDescriptor.getClassRealm());
            mojo.execute();
        }
        catch (Exception e) {
            throw new MojoExecutionException("Can not execute SonarQube analysis", e);
        }
        finally {
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    private Xpp3Dom convert(MojoDescriptor mojoDescriptor) {
        Xpp3Dom dom = new Xpp3Dom("configuration");
        PlexusConfiguration c = mojoDescriptor.getMojoConfiguration();
        PlexusConfiguration[] ces = c.getChildren();
        if (ces != null) {
            for (PlexusConfiguration ce : ces) {
                String value = ce.getValue(null);
                String defaultValue = ce.getAttribute("default-value", null);
                if (value == null && defaultValue == null) continue;
                Xpp3Dom e = new Xpp3Dom(ce.getName());
                e.setValue(value);
                if (defaultValue != null) {
                    e.setAttribute("default-value", defaultValue);
                }
                dom.addChild(e);
            }
        }
        return dom;
    }

    private Plugin createSonarPlugin() throws IOException {
        Plugin plugin = new Plugin();
        plugin.setGroupId("org.codehaus.sonar");
        plugin.setArtifactId("sonar-maven3-plugin");
        plugin.setVersion(this.server.getVersion());
        return plugin;
    }
}

