/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.ship;

import java.io.File;
import java.io.LineNumberReader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.maven.artifact.manager.WagonConfigurationException;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.settings.Proxy;
import org.apache.maven.settings.Settings;
import org.apache.maven.wagon.ResourceDoesNotExistException;
import org.apache.maven.wagon.TransferFailedException;
import org.apache.maven.wagon.UnsupportedProtocolException;
import org.apache.maven.wagon.Wagon;
import org.apache.maven.wagon.WagonException;
import org.apache.maven.wagon.authorization.AuthorizationException;
import org.apache.maven.wagon.events.SessionListener;
import org.apache.maven.wagon.events.TransferListener;
import org.apache.maven.wagon.observers.Debug;
import org.apache.maven.wagon.proxy.ProxyInfo;
import org.apache.maven.wagon.repository.Repository;
import org.codehaus.mojo.ship.ScriptEngine;
import org.codehaus.mojo.ship.ScriptException;

public class WagonScriptEngine
implements ScriptEngine {
    private final Pattern syntax = Pattern.compile("\\s*[pP][uU][tT]\\s+([^\\s]+)\\s+[iI][nN]\\s+([^\\s]+)(?:\\s+[iI][dD]\\s+([^\\s]+))?\\s*");

    public String getExtension() {
        return "wagon";
    }

    public static Object lookupGlobalVariable(Map globalVariables, String key, Class clazz) throws ScriptException {
        if (!globalVariables.containsKey(key)) {
            throw new ScriptException("Missing required global variable '" + key + "'");
        }
        Object result = globalVariables.get(key);
        if (result == null) {
            return result;
        }
        if (clazz.isAssignableFrom(result.getClass())) {
            return result;
        }
        throw new ScriptException("Required global variable '" + key + "' must implement " + clazz.getName());
    }

    public Object eval(String script, Map globalVariables) throws ScriptException {
        Map artifacts = (Map)WagonScriptEngine.lookupGlobalVariable(globalVariables, "artifacts", Map.class);
        WagonManager wagonManager = (WagonManager)WagonScriptEngine.lookupGlobalVariable(globalVariables, "wagonManager", WagonManager.class);
        Settings settings = (Settings)WagonScriptEngine.lookupGlobalVariable(globalVariables, "settings", Settings.class);
        Log log = (Log)WagonScriptEngine.lookupGlobalVariable(globalVariables, "log", Log.class);
        ArrayList<Transfer> commands = new ArrayList<Transfer>();
        try {
            String line;
            LineNumberReader reader = new LineNumberReader(new StringReader(script));
            while (null != (line = reader.readLine())) {
                String name;
                Matcher matcher = this.syntax.matcher(line);
                if (!matcher.matches()) continue;
                String artifactId = matcher.group(1);
                String url = matcher.group(2);
                File artifact = (File)artifacts.get(artifactId);
                if (artifact == null) {
                    throw new ScriptException("Unknown artifact " + artifactId + " at line " + reader.getLineNumber());
                }
                String serverId = matcher.group(3);
                if (serverId == null) {
                    serverId = "serverId";
                }
                if (url.endsWith("/") || url.endsWith("\\")) {
                    name = artifact.getName();
                } else {
                    int i = Math.max(url.lastIndexOf(47), url.lastIndexOf(92));
                    if (i == -1) {
                        throw new ScriptException("Cannot parse destination " + url + " at line " + reader.getLineNumber());
                    }
                    name = url.substring(i + 1);
                    url = url.substring(0, i);
                }
                commands.add(new Transfer(artifact, serverId, url, name));
            }
            Iterator i = commands.iterator();
            while (i.hasNext()) {
                Transfer command = (Transfer)i.next();
                Wagon wagon = null;
                try {
                    log.info((CharSequence)("Opening connection to " + command.getUrl() + " with server credentials for id " + command.getServerId()));
                    wagon = WagonScriptEngine.createWagon(command.getServerId(), command.getUrl(), wagonManager, settings, log);
                    try {
                        log.info((CharSequence)("Transferring " + command.getArtifact() + " to " + command.getUrl() + " as " + command.getName()));
                        wagon.put(command.getArtifact(), command.getName());
                    }
                    catch (TransferFailedException e) {
                        throw new ScriptException("Unable to transfer " + command.getArtifact() + " to " + command.getUrl() + " as " + command.getName(), e);
                    }
                    catch (ResourceDoesNotExistException e) {
                        throw new ScriptException("Unable to transfer " + command.getArtifact() + " to " + command.getUrl() + " as " + command.getName(), e);
                    }
                    catch (AuthorizationException e) {
                        throw new ScriptException("Unauthorized to transfer " + command.getArtifact() + " to " + command.getUrl() + " as " + command.getName(), e);
                    }
                }
                catch (UnsupportedProtocolException e) {
                    throw new ScriptException("Unsupported protocol for " + command.getUrl(), e);
                }
                catch (WagonConfigurationException e) {
                    throw new ScriptException("Unable to configure a Wagon instance for " + command.getUrl(), e);
                }
                catch (WagonException e) {
                    throw new ScriptException("Unable to create a Wagon instance for " + command.getUrl(), e);
                }
                finally {
                    if (wagon == null) continue;
                    wagon.disconnect();
                }
            }
            return Boolean.TRUE;
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (ScriptException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new ScriptException(e);
        }
    }

    public static Wagon createWagon(String id, String url, WagonManager wagonManager, Settings settings, Log logger) throws WagonException, UnsupportedProtocolException, WagonConfigurationException {
        ProxyInfo proxyInfo;
        Wagon wagon = null;
        Repository repository = new Repository(id, url);
        wagon = wagonManager.getWagon(repository);
        if (logger.isDebugEnabled()) {
            Debug debug = new Debug();
            wagon.addSessionListener((SessionListener)debug);
            wagon.addTransferListener((TransferListener)debug);
        }
        if ((proxyInfo = WagonScriptEngine.getProxyInfo(settings)) != null) {
            wagon.connect(repository, wagonManager.getAuthenticationInfo(repository.getId()), proxyInfo);
        } else {
            wagon.connect(repository, wagonManager.getAuthenticationInfo(repository.getId()));
        }
        return wagon;
    }

    public static ProxyInfo getProxyInfo(Settings settings) {
        ProxyInfo proxyInfo = null;
        if (settings != null && settings.getActiveProxy() != null) {
            Proxy settingsProxy = settings.getActiveProxy();
            proxyInfo = new ProxyInfo();
            proxyInfo.setHost(settingsProxy.getHost());
            proxyInfo.setType(settingsProxy.getProtocol());
            proxyInfo.setPort(settingsProxy.getPort());
            proxyInfo.setNonProxyHosts(settingsProxy.getNonProxyHosts());
            proxyInfo.setUserName(settingsProxy.getUsername());
            proxyInfo.setPassword(settingsProxy.getPassword());
        }
        return proxyInfo;
    }

    private static final class Transfer {
        private final File artifact;
        private final String serverId;
        private final String url;
        private final String name;

        private Transfer(File artifact, String serverId, String url, String name) {
            this.artifact = artifact;
            this.serverId = serverId;
            this.url = url;
            this.name = name;
        }

        public File getArtifact() {
            return this.artifact;
        }

        public String getServerId() {
            return this.serverId;
        }

        public String getUrl() {
            return this.url;
        }

        public String getName() {
            return this.name;
        }
    }
}

