/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.rmic;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:rmic-maven-plugin:1.2.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "RMI Compiler Maven Plugin", 0);
        this.append(sb, "RMI Compiler Maven Plugin", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 4 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "rmic:help", 0);
            this.append(sb, "Display help information on rmic-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0rmic:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "package".equals(this.goal)) {
            this.append(sb, "rmic:package", 0);
            this.append(sb, "Creates a jar containing the rmic generated classes.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classifier (Default: client)", 2);
                this.append(sb, "Classifier to append to the jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "The file patterns to exclude from the jar.", 3);
                this.append(sb, "", 0);
                this.append(sb, "finalName (Default: ${project.build.finalName})", 2);
                this.append(sb, "The base name of the generated jar. This name does not include the classifier or the extension.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "The file patterns to include in the jar. By default, all classes ending with _Stub.class will be included.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/rmi-classes)", 2);
                this.append(sb, "This directory contains the output of rmic (where the Stub classes are located). This is not the directory where the jar file will be written.", 3);
                this.append(sb, "", 0);
                this.append(sb, "target (Default: ${project.build.directory})", 2);
                this.append(sb, "The directory to which the generated jar should be written.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "rmic".equals(this.goal)) {
            this.append(sb, "rmic:rmic", 0);
            this.append(sb, "Compiles rmi stubs and skeleton classes from a remote implementation class.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "classesDirectory (Default: ${project.build.outputDirectory})", 2);
                this.append(sb, "Directory tree where the compiled Remote classes are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "compilerId (Default: sun)", 2);
                this.append(sb, "The id of the rmi compiler to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclusions when searching for classes to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "idl (Default: false)", 2);
                this.append(sb, "Create IDL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "iiop (Default: false)", 2);
                this.append(sb, "Create stubs for IIOP.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of inclusions when searching for classes to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keep (Default: false)", 2);
                this.append(sb, "Do not delete intermediate generated source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noLocalStubs", 2);
                this.append(sb, "Do not create stubs optimized for same process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noValueMethods", 2);
                this.append(sb, "Do not generate methods for valuetypes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nowarn", 2);
                this.append(sb, "Turn off rmic warnings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/rmi-classes)", 2);
                this.append(sb, "Specifies where to place rmic generated class files. If the generated files need to be included in the main project artifact, this parameter can be set to ${project.build.outputDirectory}.", 3);
                this.append(sb, "", 0);
                this.append(sb, "poa (Default: false)", 2);
                this.append(sb, "Enable poa generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "A List of Source configurations to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "Time in milliseconds between automatic recompilations. A value of 0 means that up to date rmic output classes will not be recompiled until the source classes change.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the rmi protocol to which the stubs should be compiled. Valid values include 1.1, 1.2, compat. See the rmic documentation for more information. If nothing is specified the underlying rmi compiler will choose the default value. For example, in sun jdk 1.5 the default is 1.2.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "test-rmic".equals(this.goal)) {
            this.append(sb, "rmic:test-rmic", 0);
            this.append(sb, "Compiles rmi stubs and skeleton classes from a remote implementation class. By default runs against files in the test-classes directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "compilerId (Default: sun)", 2);
                this.append(sb, "The id of the rmi compiler to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "A list of exclusions when searching for classes to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "idl (Default: false)", 2);
                this.append(sb, "Create IDL.", 3);
                this.append(sb, "", 0);
                this.append(sb, "iiop (Default: false)", 2);
                this.append(sb, "Create stubs for IIOP.", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "A list of inclusions when searching for classes to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "keep (Default: false)", 2);
                this.append(sb, "Do not delete intermediate generated source files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noLocalStubs", 2);
                this.append(sb, "Do not create stubs optimized for same process.", 3);
                this.append(sb, "", 0);
                this.append(sb, "noValueMethods", 2);
                this.append(sb, "Do not generate methods for valuetypes.", 3);
                this.append(sb, "", 0);
                this.append(sb, "nowarn", 2);
                this.append(sb, "Turn off rmic warnings.", 3);
                this.append(sb, "", 0);
                this.append(sb, "poa (Default: false)", 2);
                this.append(sb, "Enable poa generation.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sources", 2);
                this.append(sb, "A List of Source configurations to compile.", 3);
                this.append(sb, "", 0);
                this.append(sb, "staleMillis (Default: 0)", 2);
                this.append(sb, "Time in milliseconds between automatic recompilations. A value of 0 means that up to date rmic output classes will not be recompiled until the source classes change.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testClassesDirectory (Default: ${project.build.testOutputDirectory})", 2);
                this.append(sb, "Directory tree where the compiled Remote classes are located.", 3);
                this.append(sb, "", 0);
                this.append(sb, "testOutputDirectory (Default: ${project.build.directory}/rmi-test-classes)", 2);
                this.append(sb, "Specifies where to place rmic generated class files. If the generated files need to be included in the project test artifact, this parameter can be set to ${project.build.testOutputDirectory}.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Enable verbose output.", 3);
                this.append(sb, "", 0);
                this.append(sb, "version", 2);
                this.append(sb, "The version of the rmi protocol to which the stubs should be compiled. Valid values include 1.1, 1.2, compat. See the rmic documentation for more information. If nothing is specified the underlying rmi compiler will choose the default value. For example, in sun jdk 1.5 the default is 1.2.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

