/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.model;

import java.util.Calendar;
import java.util.Date;

public class Copyright {
    protected static final String COPYRIGHT_TO_STRING_FORMAT = "Copyright (C) %1$s %2$s";
    protected String holder;
    protected int firstYear;
    protected Integer lastYear;

    public static Copyright newCopyright(Integer inceptionYear, Integer lastYear, String holder) {
        int firstYear = inceptionYear == null ? lastYear : inceptionYear;
        if (lastYear == null || firstYear >= lastYear) {
            lastYear = null;
        }
        Copyright result = new Copyright(firstYear, lastYear, holder);
        return result;
    }

    public static Copyright newCopyright(Integer inceptionYear, String holder) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date());
        Integer lastYear = cal.get(1);
        return Copyright.newCopyright(inceptionYear, lastYear, holder);
    }

    public Copyright() {
    }

    public Copyright(Copyright copyright) {
        this(copyright.getFirstYear(), copyright.getLastYear(), copyright.getHolder());
    }

    public Copyright(int firstYear, Integer lastYear, String holder) {
        this.firstYear = firstYear;
        this.lastYear = lastYear;
        this.holder = holder;
    }

    public String getHolder() {
        return this.holder;
    }

    public Integer getFirstYear() {
        return this.firstYear;
    }

    public Integer getLastYear() {
        return this.lastYear;
    }

    public String getYears() {
        String years = this.getLastYear() == null ? String.valueOf(this.getFirstYear()) : this.getFirstYear() + " - " + this.getLastYear();
        return years;
    }

    public String getText() {
        String copyright = String.format(COPYRIGHT_TO_STRING_FORMAT, this.getYears(), this.getHolder());
        return copyright;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Copyright)) {
            return false;
        }
        Copyright copyright = (Copyright)o;
        if (this.firstYear != copyright.firstYear) {
            return false;
        }
        if (this.holder != null ? !this.holder.equals(copyright.holder) : copyright.holder != null) {
            return false;
        }
        return !(this.lastYear != null ? !this.lastYear.equals(copyright.lastYear) : copyright.lastYear != null);
    }

    public int hashCode() {
        int result = this.holder != null ? this.holder.hashCode() : 0;
        result = 31 * result + this.firstYear;
        result = 31 * result + (this.lastYear != null ? this.lastYear.hashCode() : 0);
        return result;
    }

    public String toString() {
        return this.getText();
    }
}

