/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import org.codehaus.mojo.license.header.FileHeader;
import org.codehaus.mojo.license.header.FileHeaderFilter;
import org.codehaus.mojo.license.header.transformer.FileHeaderTransformer;
import org.nuiton.processor.Processor;
import org.nuiton.processor.filters.Filter;

public class FileHeaderProcessor
extends Processor {
    private final FileHeaderFilter filter;

    public FileHeaderProcessor(FileHeaderFilter filter, FileHeader fileHeader, FileHeaderTransformer transformer) {
        if (filter == null) {
            throw new IllegalStateException("no file header filter set.");
        }
        if (fileHeader == null) {
            throw new IllegalStateException("no file header set.");
        }
        if (transformer == null) {
            throw new IllegalStateException("no file header transformer set.");
        }
        this.filter = filter;
        this.setInputFilter((Filter)filter);
        filter.setFileHeader(fileHeader);
        filter.setTransformer(transformer);
        filter.resetContent();
    }

    public String addHeader(String content) {
        return this.filter.getTransformer().addHeader(this.filter.getFullHeaderContent(), content);
    }

    public boolean isTouched() {
        return this.filter.isTouched();
    }

    public boolean isModified() {
        return this.filter.isModified();
    }

    public boolean isDetectHeader() {
        return this.filter.isDetectHeader();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void process(String inputContent, File outputFile) throws IOException {
        this.filter.reset();
        StringReader input = new StringReader(inputContent);
        try {
            FileWriter output = new FileWriter(outputFile);
            try {
                this.process(input, output);
                Object var6_5 = null;
            }
            catch (Throwable throwable) {
                Object var6_6 = null;
                output.close();
                throw throwable;
            }
            output.close();
            Object var8_8 = null;
            input.close();
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            input.close();
            throw throwable;
        }
    }

    public String getFileHeaderDescription() {
        return this.filter.getFileHeader().getDescription();
    }

    public void updateDescription(String description) {
        this.filter.getFileHeader().setDescription(description);
        this.filter.resetContent();
    }
}

