/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:license-maven-plugin:1.1", 0);
        this.append(sb, "", 0);
        this.append(sb, "License Maven Plugin", 0);
        this.append(sb, "Maven plugin to download and collect license files from project dependencies.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 9 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "add-third-party".equals(this.goal)) {
            this.append(sb, "license:add-third-party", 0);
            this.append(sb, "Goal to generate the third-party license file. This file contains a list of the dependencies and their licenses. Each dependency and it's license is displayed on a single line in the format\n\n\u00a0\u00a0(<license-name>)\u00a0<project-name>\u00a0<groupId>:<artifactId>:<version>\u00a0-\u00a0<project-url>\nIt will also copy it in the class-path (says add the generated directory as a resource of the build).", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "acceptPomPackaging (Default: false)", 2);
                this.append(sb, "To execute or not this mojo if project packaging is pom. Note: The default value is false.", 3);
                this.append(sb, "Expression: ${license.acceptPomPackaging}", 3);
                this.append(sb, "", 0);
                this.append(sb, "bundleThirdPartyPath (Default: META-INF/${project.artifactId}-THIRD-PARTY.txt)", 2);
                this.append(sb, "The path of the bundled third party file to produce when generateBundle is on. Note: This option is not available for pom module types.", 3);
                this.append(sb, "Expression: ${license.bundleThirdPartyPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "deployMissingFile (Default: true)", 2);
                this.append(sb, "Deploy the third party missing file in maven repository.", 3);
                this.append(sb, "Expression: ${license.deployMissingFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files. Note: If nothing is filled here, we will use the system property file.encoding.", 3);
                this.append(sb, "Expression: ${license.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedArtifacts", 2);
                this.append(sb, "A filter to exclude some ArtifactsIds", 3);
                this.append(sb, "Expression: ${license.excludedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "A filter to exclude some GroupIds", 3);
                this.append(sb, "Expression: ${license.excludedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedLicenses", 2);
                this.append(sb, "To specify some licenses to exclude (separated by |). If a such license is found then build will failed when property failIfWarning is setted on.", 3);
                this.append(sb, "Expression: ${license.excludedLicenses}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedScopes (Default: system)", 2);
                this.append(sb, "A filter to exclude some scopes.", 3);
                this.append(sb, "Expression: ${license.excludedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfWarning (Default: false)", 2);
                this.append(sb, "A flag to fail the build if at least one dependency was detected without a license.", 3);
                this.append(sb, "Expression: ${license.failIfWarning}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileTemplate (Default: /org/codehaus/mojo/license/third-party-file.ftl)", 2);
                this.append(sb, "Template used to build the third-party file. (This template use freemarker).", 3);
                this.append(sb, "Expression: ${license.fileTemplate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "To force generation of the third-party file even if every thing is up to date.", 3);
                this.append(sb, "Expression: ${license.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateBundle (Default: false)", 2);
                this.append(sb, "A flag to copy a bundled version of the third-party file. This is usefull to avoid for a final application collision name of third party file. The file will be copied at the bundleThirdPartyPath location.", 3);
                this.append(sb, "Expression: ${license.generateBundle}", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupByLicense (Default: false)", 2);
                this.append(sb, "Deprecated. since 1.1, please use the correct value for the parameter fileTemplate", 3);
                this.append(sb, "", 0);
                this.append(sb, "A flag to change the grouping of the generated THIRD-PARTY file. By default, group by dependecies. If sets to true, the it will group by license type. Note: This parameter is deprecated, please now use the correct template for this purpose (value /org/codehaus/mojo/license/third-party-file-groupByLicense.ftl to parameter fileTemplate)", 3);
                this.append(sb, "Expression: ${license.groupByLicense}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedArtifacts", 2);
                this.append(sb, "A filter to include only some ArtifactsIds", 3);
                this.append(sb, "Expression: ${license.includedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "A filter to include only some GroupIds", 3);
                this.append(sb, "Expression: ${license.includedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedLicenses", 2);
                this.append(sb, "To specify some licenses to include (separated by |). If this parameter is filled and a license is not in this whitelist then build will failed when property failIfWarning is setted on.", 3);
                this.append(sb, "Expression: ${license.includedLicenses}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedScopes", 2);
                this.append(sb, "A filter to include only some scopes, if let empty then all scopes will be used (no filter).", 3);
                this.append(sb, "Expression: ${license.includedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTransitiveDependencies (Default: true)", 2);
                this.append(sb, "Include transitive dependencies when downloading license files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseMerges", 2);
                this.append(sb, "To merge licenses in final file. Each entry represents a merge (first license is main license to keep), licenses are separated by |. Example :\n<licenseMerges>\n<licenseMerge>The\u00a0Apache\u00a0Software\u00a0License|Version\u00a02.0,Apache\u00a0License,\u00a0Version\u00a02.0</licenseMerge>\n</licenseMerges>\n</pre>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "missingFile (Default: src/license/THIRD-PARTY.properties)", 2);
                this.append(sb, "The file where to fill the license for dependencies with unknwon license.", 3);
                this.append(sb, "Expression: ${license.missingFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/license)", 2);
                this.append(sb, "Directory where to generate files.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2);
                this.append(sb, "File where to wirte the third-party file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.thirdPartyFilename}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useMissingFile (Default: false)", 2);
                this.append(sb, "A flag to use the missing licenses file to consolidate the THID-PARTY file.", 3);
                this.append(sb, "Expression: ${license.useMissingFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useRepositoryMissingFiles (Default: true)", 2);
                this.append(sb, "Load from repositories third party missing files.", 3);
                this.append(sb, "Expression: ${license.useRepositoryMissingFiles}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode. Note: Verbose mode is always on if you starts a debug maven instance (says via -X).", 3);
                this.append(sb, "Expression: ${license.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "aggregate-add-third-party".equals(this.goal)) {
            this.append(sb, "license:aggregate-add-third-party", 0);
            this.append(sb, "This aggregator goal (will be executed only once and only on pom projects) executed the add-third-party on all his modules (in a parellel build cycle) then aggreates all the third-party files in final one in the pom project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "bundleThirdPartyPath (Default: META-INF/${project.artifactId}-THIRD-PARTY.txt)", 2);
                this.append(sb, "The path of the bundled third party file to produce when generateBundle is on. Note: This option is not available for pom module types.", 3);
                this.append(sb, "Expression: ${license.bundleThirdPartyPath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files. Note: If nothing is filled here, we will use the system property file.encoding.", 3);
                this.append(sb, "Expression: ${license.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedLicenses", 2);
                this.append(sb, "To specify some licenses to exclude (separated by |). If a such license is found then build will failed when property failIfWarning is setted on.", 3);
                this.append(sb, "Expression: ${license.excludedLicenses}", 3);
                this.append(sb, "", 0);
                this.append(sb, "failIfWarning (Default: false)", 2);
                this.append(sb, "A flag to fail the build if at least one dependency was detected without a license.", 3);
                this.append(sb, "Expression: ${license.failIfWarning}", 3);
                this.append(sb, "", 0);
                this.append(sb, "fileTemplate (Default: /org/codehaus/mojo/license/third-party-file.ftl)", 2);
                this.append(sb, "Template used to build the third-party file. (This template use freemarker).", 3);
                this.append(sb, "Expression: ${license.fileTemplate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "To force generation of the third-party file even if every thing is up to date.", 3);
                this.append(sb, "Expression: ${license.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateBundle (Default: false)", 2);
                this.append(sb, "A flag to copy a bundled version of the third-party file. This is usefull to avoid for a final application collision name of third party file. The file will be copied at the bundleThirdPartyPath location.", 3);
                this.append(sb, "Expression: ${license.generateBundle}", 3);
                this.append(sb, "", 0);
                this.append(sb, "groupByLicense (Default: false)", 2);
                this.append(sb, "Deprecated. since 1.1, please use the correct value for the parameter fileTemplate", 3);
                this.append(sb, "", 0);
                this.append(sb, "A flag to change the grouping of the generated THIRD-PARTY file. By default, group by dependecies. If sets to true, the it will group by license type. Note: This parameter is deprecated, please now use the correct template for this purpose (value /org/codehaus/mojo/license/third-party-file-groupByLicense.ftl to parameter fileTemplate)", 3);
                this.append(sb, "Expression: ${license.groupByLicense}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedLicenses", 2);
                this.append(sb, "To specify some licenses to include (separated by |). If this parameter is filled and a license is not in this whitelist then build will failed when property failIfWarning is setted on.", 3);
                this.append(sb, "Expression: ${license.includedLicenses}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseMerges", 2);
                this.append(sb, "To merge licenses in final file. Each entry represents a merge (first license is main license to keep), licenses are separated by |. Example :\n<licenseMerges>\n<licenseMerge>The\u00a0Apache\u00a0Software\u00a0License|Version\u00a02.0,Apache\u00a0License,\u00a0Version\u00a02.0</licenseMerge>\n</licenseMerges>\n</pre>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "missingFile (Default: src/license/THIRD-PARTY.properties)", 2);
                this.append(sb, "The file where to fill the license for dependencies with unknwon license.", 3);
                this.append(sb, "Expression: ${license.missingFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-sources/license)", 2);
                this.append(sb, "Directory where to generate files.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "thirdPartyFilename (Default: THIRD-PARTY.txt)", 2);
                this.append(sb, "File where to wirte the third-party file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.thirdPartyFilename}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useMissingFile (Default: false)", 2);
                this.append(sb, "A flag to use the missing licenses file to consolidate the THID-PARTY file.", 3);
                this.append(sb, "Expression: ${license.useMissingFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode. Note: Verbose mode is always on if you starts a debug maven instance (says via -X).", 3);
                this.append(sb, "Expression: ${license.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "comment-style-list".equals(this.goal)) {
            this.append(sb, "license:comment-style-list", 0);
            this.append(sb, "Displays all the available comment style to box file headers.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail", 2);
                this.append(sb, "A flag to display also the content of each license.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files. Note: If nothing is filled here, we will use the system property file.encoding.", 3);
                this.append(sb, "Expression: ${license.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode. Note: Verbose mode is always on if you starts a debug maven instance (says via -X).", 3);
                this.append(sb, "Expression: ${license.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "download-licenses".equals(this.goal)) {
            this.append(sb, "license:download-licenses", 0);
            this.append(sb, "Download the license files of all the current project's dependencies, and generate a summary file containing a list of all dependencies and their licenses.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "excludedScopes (Default: system)", 2);
                this.append(sb, "A filter to exclude some scopes.", 3);
                this.append(sb, "Expression: ${license.excludedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedScopes", 2);
                this.append(sb, "A filter to include only some scopes, if let empty then all scopes will be used (no filter).", 3);
                this.append(sb, "Expression: ${license.includedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTransitiveDependencies (Default: true)", 2);
                this.append(sb, "Include transitive dependencies when downloading license files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licensesConfigFile (Default: ${project.basedir}/src/license/licenses.xml)", 2);
                this.append(sb, "Input file containing a mapping between each dependency and it's license information.", 3);
                this.append(sb, "Expression: ${licensesConfigFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licensesOutputDirectory (Default: ${project.build.directory}/generated-resources/licenses)", 2);
                this.append(sb, "The directory to which the dependency licenses should be written.", 3);
                this.append(sb, "Expression: ${licensesOutputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licensesOutputFile (Default: ${project.build.directory}/generated-resources/licenses.xml)", 2);
                this.append(sb, "The output file containing a mapping between each dependency and it's license information.", 3);
                this.append(sb, "Expression: ${licensesOutputFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "offline (Default: ${settings.offline})", 2);
                this.append(sb, "Settings offline flag (will not download anything if setted to true).", 3);
                this.append(sb, "", 0);
                this.append(sb, "quiet (Default: false)", 2);
                this.append(sb, "Don't show warnings about bad or missing license files.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "license:help", 0);
            this.append(sb, "Display help information on license-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0license:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "Expression: ${goal}", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "Expression: ${indentSize}", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "Expression: ${lineLength}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "license-list".equals(this.goal)) {
            this.append(sb, "license:license-list", 0);
            this.append(sb, "Display all available licenses.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail", 2);
                this.append(sb, "A flag to display also the content of each license.", 3);
                this.append(sb, "Expression: ${detail}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files. Note: If nothing is filled here, we will use the system property file.encoding.", 3);
                this.append(sb, "Expression: ${license.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraResolver", 2);
                this.append(sb, "the url of an extra license repository.", 3);
                this.append(sb, "Expression: ${extraResolver}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode. Note: Verbose mode is always on if you starts a debug maven instance (says via -X).", 3);
                this.append(sb, "Expression: ${license.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "third-party-report".equals(this.goal)) {
            this.append(sb, "license:third-party-report", 0);
            this.append(sb, "Generates a report of all third-parties detected in the module.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files. Note: If nothing is filled here, we will use the system property file.encoding.", 3);
                this.append(sb, "Expression: ${license.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedArtifacts", 2);
                this.append(sb, "A filter to exclude some ArtifactsIds", 3);
                this.append(sb, "Expression: ${license.excludedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedGroups", 2);
                this.append(sb, "A filter to exclude some GroupIds", 3);
                this.append(sb, "Expression: ${license.excludedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludedScopes (Default: system)", 2);
                this.append(sb, "A filter to exclude some scopes.", 3);
                this.append(sb, "Expression: ${license.excludedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedArtifacts", 2);
                this.append(sb, "A filter to include only some ArtifactsIds", 3);
                this.append(sb, "Expression: ${license.includedArtifacts}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedGroups", 2);
                this.append(sb, "A filter to include only some GroupIds", 3);
                this.append(sb, "Expression: ${license.includedGroups}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includedScopes", 2);
                this.append(sb, "A filter to include only some scopes, if let empty then all scopes will be used (no filter).", 3);
                this.append(sb, "Expression: ${license.includedScopes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includeTransitiveDependencies (Default: true)", 2);
                this.append(sb, "Include transitive dependencies when downloading license files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseMerges", 2);
                this.append(sb, "To merge licenses in final file. Each entry represents a merge (first license is main license to keep), licenses are separated by |. Example :\n<licenseMerges>\n<licenseMerge>The\u00a0Apache\u00a0Software\u00a0License|Version\u00a02.0,Apache\u00a0License,\u00a0Version\u00a02.0</licenseMerge>\n</licenseMerges>\n</pre>\n", 3);
                this.append(sb, "", 0);
                this.append(sb, "missingFile (Default: src/license/THIRD-PARTY.properties)", 2);
                this.append(sb, "The file where to fill the license for dependencies with unknwon license.", 3);
                this.append(sb, "Expression: ${license.missingFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory})", 2);
                this.append(sb, "The output directory for the report. Note that this parameter is only evaluated if the goal is run directly from the command line. If the goal is run indirectly as part of a site generation, the output directory configured in the Maven Site Plugin is used instead.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "skip", 2);
                this.append(sb, "Skip to generate the report.", 3);
                this.append(sb, "Expression: ${license.skip}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useMissingFile (Default: false)", 2);
                this.append(sb, "A flag to use the missing licenses file to consolidate the THID-PARTY file.", 3);
                this.append(sb, "Expression: ${license.useMissingFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "useRepositoryMissingFiles (Default: true)", 2);
                this.append(sb, "Load from repositories third party missing files.", 3);
                this.append(sb, "Expression: ${license.useRepositoryMissingFiles}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode. Note: Verbose mode is always on if you starts a debug maven instance (says via -X).", 3);
                this.append(sb, "Expression: ${license.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-file-header".equals(this.goal)) {
            this.append(sb, "license:update-file-header", 0);
            this.append(sb, "The goal to update (or add) the header on project source files. This goal replace the update-header goal which can not deal with Copyright. This goal use a specific project file descriptor project.xml to describe all files to update for a whole project.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "addSvnKeyWords (Default: false)", 2);
                this.append(sb, "A flag to add svn:keywords on new header. Will add svn keywords :\nId,\u00a0HeadURL\nNote: This parameter is used by the descriptionTemplate, so if you change this template, the parameter could be no more used (depends what you put in your own template...).", 3);
                this.append(sb, "Expression: ${license.addSvnKeyWords}", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUpdateCopyright (Default: false)", 2);
                this.append(sb, "A flag to authorize update of the copyright part of the header. Note: By default, do NOT authorize it since copyright part should be handled by developpers (holder can change on each file for example).", 3);
                this.append(sb, "Expression: ${license.canUpdateCopyright}", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUpdateDescription (Default: false)", 2);
                this.append(sb, "A flag to authorize update of the description part of the header. Note: By default, do NOT authorize it since description can change on each file).", 3);
                this.append(sb, "Expression: ${license.canUpdateDescription}", 3);
                this.append(sb, "", 0);
                this.append(sb, "canUpdateLicense (Default: true)", 2);
                this.append(sb, "A flag to authorize update of the license part of the header. Note: By default, authorize it since license part should always be generated by the plugin.", 3);
                this.append(sb, "Expression: ${license.canUpdateLicense}", 3);
                this.append(sb, "", 0);
                this.append(sb, "clearAfterOperation (Default: true)", 2);
                this.append(sb, "A flag to clear everything after execution. Note: This property should ONLY be used for test purpose.", 3);
                this.append(sb, "Expression: ${license.clearAfterOperation}", 3);
                this.append(sb, "", 0);
                this.append(sb, "descriptionTemplate (Default: /org/codehaus/mojo/license/default-file-header-description.ftl)", 2);
                this.append(sb, "Template used to build the description scetion of the license header. (This template use freemarker).", 3);
                this.append(sb, "Expression: ${license.descriptionTemplate}", 3);
                this.append(sb, "", 0);
                this.append(sb, "dryRun (Default: false)", 2);
                this.append(sb, "A flag to test plugin but modify no file.", 3);
                this.append(sb, "Expression: ${dryRun}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files. Note: If nothing is filled here, we will use the system property file.encoding.", 3);
                this.append(sb, "Expression: ${license.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "excludes", 2);
                this.append(sb, "Specific files to excludes, separated by a comma. By default, thoses file type are excluded:\n-\tmodelisation\n-\timages\nNote: This parameter is not useable if you are still using a project file descriptor.", 3);
                this.append(sb, "Expression: ${license.excludes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "extraExtensions", 2);
                this.append(sb, "To associate extra extension files to an existing comment style. Keys of the map are the extension of extra files to treate, and the value is the comment style you want to associate. For example, to treate file with extensions java2 and jdata as java files (says using the java comment style, declare this in your plugin configuration :\n<extraExtensions>\n<java2>java</java2>\n<jdata>java</jdata>\n</extraExtensions>\nNote: This parameter is not useable if you are still using a project file descriptor.", 3);
                this.append(sb, "", 0);
                this.append(sb, "ignoreTag", 2);
                this.append(sb, "A tag to place on files that will be ignored by the plugin. Sometimes, it is necessary to do this when file is under a specific license. Note: If no sets, will use the default tag %%Ignore-License", 3);
                this.append(sb, "Expression: ${license.ignoreTag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "inceptionYear (Default: ${project.inceptionYear})", 2);
                this.append(sb, "Inception year of the project. Will be used as first year of copyright section in new header.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.inceptionYear}", 3);
                this.append(sb, "", 0);
                this.append(sb, "includes", 2);
                this.append(sb, "Specific files to includes, separated by a comma. By default, it is '** /*'. Note: This parameter is not useable if you are still using a project file descriptor.", 3);
                this.append(sb, "Expression: ${license.includes}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "A flag to keep a backup of every modified file.", 3);
                this.append(sb, "Expression: ${license.keepBackup}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Name of the license to use in the project.", 3);
                this.append(sb, "Expression: ${license.licenseName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseResolver", 2);
                this.append(sb, "To specify an external extra licenses repository resolver (says the base url of the repository where the license.properties is present).", 3);
                this.append(sb, "Expression: ${license.licenseResolver}", 3);
                this.append(sb, "", 0);
                this.append(sb, "organizationName (Default: ${project.organization.name})", 2);
                this.append(sb, "Name of project's organization. Will be used as copyrigth's holder in new header.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.organizationName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "processEndTag", 2);
                this.append(sb, "To overwrite the processEndTag used to build header model. See http://mojo.codehaus.org/license-maven-plugin/header.html#Configuration .", 3);
                this.append(sb, "Expression: ${license.processEndTag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "processStartTag", 2);
                this.append(sb, "To overwrite the processStartTag used to build header model. See http://mojo.codehaus.org/license-maven-plugin/header.html#Configuration .", 3);
                this.append(sb, "Expression: ${license.processStartTag}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "projectName (Default: ${project.name})", 2);
                this.append(sb, "Name of project (or module). Will be used as description section of new header.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.projectName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "roots", 2);
                this.append(sb, "To specify the base dir from which we apply the license. Should be on form 'root1,root2,rootn'. By default, the main roots are 'src, target/generated-sources, target/processed-sources'. Note: If some of these roots do not exist, they will be simply ignored. Note: This parameter is not useable if you are still using a project file descriptor.", 3);
                this.append(sb, "Expression: ${license.roots}", 3);
                this.append(sb, "", 0);
                this.append(sb, "sectionDelimiter", 2);
                this.append(sb, "To overwrite the sectionDelimiter used to build header model. See http://mojo.codehaus.org/license-maven-plugin/header.html#Configuration .", 3);
                this.append(sb, "Expression: ${license.sectionDelimiter}", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipUpdateLicense (Default: false)", 2);
                this.append(sb, "A flag to skip the goal.", 3);
                this.append(sb, "Expression: ${license.skipUpdateLicense}", 3);
                this.append(sb, "", 0);
                this.append(sb, "updateCopyright (Default: false)", 2);
                this.append(sb, "A flag to update copyright application time (change copyright last year if required) according to the last commit made on the processed file. Note that this functionnality is still not effective.", 3);
                this.append(sb, "Expression: ${license.updateCopyright}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode. Note: Verbose mode is always on if you starts a debug maven instance (says via -X).", 3);
                this.append(sb, "Expression: ${license.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "update-project-license".equals(this.goal)) {
            this.append(sb, "license:update-project-license", 0);
            this.append(sb, "Updates (or creates) the main project license file according to the given license defines as licenseName. Can also generate a bundled license file (to avoid collision names in class-path). This file is by default generated in META-INF class-path directory.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "bundleLicensePath (Default: META-INF/${project.artifactId}-LICENSE.txt)", 2);
                this.append(sb, "The path of the bundled license file to produce when generateBundle is on. Note: This option is not available for pom module types.", 3);
                this.append(sb, "Expression: ${license.bundleLicensePath}", 3);
                this.append(sb, "", 0);
                this.append(sb, "encoding (Default: ${project.build.sourceEncoding})", 2);
                this.append(sb, "Encoding used to read and writes files. Note: If nothing is filled here, we will use the system property file.encoding.", 3);
                this.append(sb, "Expression: ${license.encoding}", 3);
                this.append(sb, "", 0);
                this.append(sb, "force (Default: false)", 2);
                this.append(sb, "A flag to force to generate project license file even if it is up-to-date.", 3);
                this.append(sb, "Expression: ${license.force}", 3);
                this.append(sb, "", 0);
                this.append(sb, "generateBundle (Default: false)", 2);
                this.append(sb, "A flag to copy the main license file in a bundled place. This is usefull for final application to have a none confusing location to seek for the application license. If Sets to true, will copy the license file to the bundleLicensePath to outputDirectory. Note: This option is not available for pom module types.", 3);
                this.append(sb, "Expression: ${license.generateBundle}", 3);
                this.append(sb, "", 0);
                this.append(sb, "keepBackup (Default: false)", 2);
                this.append(sb, "A flag to keep a backup of every modified file.", 3);
                this.append(sb, "Expression: ${license.keepBackup}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseFile (Default: ${basedir}/LICENSE.txt)", 2);
                this.append(sb, "Project license file to synchronize with main license defined in descriptor file.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "Expression: ${license.licenceFile}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseName", 2);
                this.append(sb, "Name of the license to use in the project.", 3);
                this.append(sb, "Expression: ${license.licenseName}", 3);
                this.append(sb, "", 0);
                this.append(sb, "licenseResolver", 2);
                this.append(sb, "To specify an external extra licenses repository resolver (says the base url of the repository where the license.properties is present).", 3);
                this.append(sb, "Expression: ${license.licenseResolver}", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: target/generated-sources/license)", 2);
                this.append(sb, "The directory where to generate license resources. Note: This option is not available for pom module types.", 3);
                this.append(sb, "Expression: ${license.outputDirectory}", 3);
                this.append(sb, "", 0);
                this.append(sb, "project (Default: ${project})", 2);
                this.append(sb, "The reacted project.", 3);
                this.append(sb, "Required: Yes", 3);
                this.append(sb, "", 0);
                this.append(sb, "skipUpdateProjectLicense (Default: false)", 2);
                this.append(sb, "A flag to skip the goal.", 3);
                this.append(sb, "Expression: ${license.skipUpdateProjectLicense}", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: ${maven.verbose})", 2);
                this.append(sb, "Flag to activate verbose mode. Note: Verbose mode is always on if you starts a debug maven instance (says via -X).", 3);
                this.append(sb, "Expression: ${license.verbose}", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

