/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.api.DefaultThirdPartyHelper;
import org.codehaus.mojo.license.api.DependenciesTool;
import org.codehaus.mojo.license.api.ThirdPartyHelper;
import org.codehaus.mojo.license.api.ThirdPartyTool;
import org.codehaus.mojo.license.api.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;
import org.codehaus.mojo.license.utils.FileUtil;
import org.codehaus.mojo.license.utils.MojoHelper;
import org.codehaus.mojo.license.utils.SortedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAddThirdPartyMojo
extends AbstractLicenseMojo {
    private File outputDirectory;
    private String thirdPartyFilename;
    private boolean useMissingFile;
    private File missingFile;
    private List<String> licenseMerges;
    private String includedLicenses;
    private String excludedLicenses;
    private String bundleThirdPartyPath;
    private boolean generateBundle;
    private boolean force;
    private boolean failIfWarning;
    @Deprecated
    private boolean groupByLicense;
    private String fileTemplate;
    private ArtifactRepository localRepository;
    private List remoteRepositories;
    private ThirdPartyTool thirdPartyTool;
    private DependenciesTool dependenciesTool;
    private ThirdPartyHelper helper;
    private SortedMap<String, MavenProject> projectDependencies;
    private LicenseMap licenseMap;
    private SortedSet<MavenProject> unsafeDependencies;
    private File thirdPartyFile;
    private SortedProperties unsafeMappings;
    private boolean doGenerate;
    private boolean doGenerateBundle;

    protected abstract SortedMap<String, MavenProject> loadDependencies();

    protected abstract SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException;

    @Override
    protected void init() throws Exception {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        this.thirdPartyFile = new File(this.getOutputDirectory(), this.thirdPartyFilename);
        long buildTimestamp = this.getBuildTimestamp();
        if (this.isVerbose()) {
            log.info((CharSequence)("Build start   at : " + buildTimestamp));
            log.info((CharSequence)("third-party file : " + this.thirdPartyFile.lastModified()));
        }
        boolean bl = this.doGenerate = this.isForce() || !this.thirdPartyFile.exists() || buildTimestamp > this.thirdPartyFile.lastModified();
        if (this.groupByLicense) {
            this.fileTemplate = "/org/codehaus/mojo/license/third-party-file-groupByLicense.ftl";
        }
        if (this.generateBundle) {
            File bundleFile = FileUtil.getFile(this.getOutputDirectory(), this.bundleThirdPartyPath);
            if (this.isVerbose()) {
                log.info((CharSequence)("bundle third-party file : " + bundleFile.lastModified()));
            }
            this.doGenerateBundle = this.isForce() || !bundleFile.exists() || buildTimestamp > bundleFile.lastModified();
        } else {
            this.doGenerateBundle = false;
        }
        this.projectDependencies = this.loadDependencies();
        this.licenseMap = this.getHelper().createLicenseMap(this.projectDependencies);
        this.unsafeDependencies = this.getHelper().getProjectsWithNoLicense(this.licenseMap);
        if (!CollectionUtils.isEmpty(this.unsafeDependencies) && this.isUseMissingFile() && this.isDoGenerate()) {
            this.unsafeMappings = this.createUnsafeMapping();
        }
        this.getHelper().mergeLicenses(this.licenseMerges, this.licenseMap);
    }

    protected ThirdPartyHelper getHelper() {
        if (this.helper == null) {
            this.helper = new DefaultThirdPartyHelper(this.getProject(), this.getEncoding(), this.isVerbose(), this.dependenciesTool, this.thirdPartyTool, this.localRepository, this.remoteRepositories, this.getLog());
        }
        return this.helper;
    }

    public List<String> getExcludedLicenses() {
        String[] split = this.excludedLicenses == null ? new String[]{} : this.excludedLicenses.split("\\s*\\|\\s*");
        return Arrays.asList(split);
    }

    public List<String> getIncludedLicenses() {
        String[] split = this.includedLicenses == null ? new String[]{} : this.includedLicenses.split("\\s*\\|\\s*");
        return Arrays.asList(split);
    }

    protected boolean checkUnsafeDependencies() {
        boolean unsafe;
        SortedSet<MavenProject> unsafeDeps = this.getUnsafeDependencies();
        boolean bl = unsafe = !CollectionUtils.isEmpty(unsafeDeps);
        if (unsafe) {
            Log log = this.getLog();
            log.warn((CharSequence)("There is " + unsafeDeps.size() + " dependencies with no license :"));
            for (MavenProject dep : unsafeDeps) {
                log.warn((CharSequence)(" - " + MojoHelper.getArtifactId(dep.getArtifact())));
            }
        }
        return unsafe;
    }

    protected boolean checkForbiddenLicenses() {
        boolean safe;
        Set licenses;
        List<String> whiteLicenses = this.getIncludedLicenses();
        List<String> blackLicenses = this.getExcludedLicenses();
        HashSet<String> unsafeLicenses = new HashSet<String>();
        if (CollectionUtils.isNotEmpty(blackLicenses)) {
            licenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Excluded licenses (blacklist): " + blackLicenses));
            for (String excludeLicense : blackLicenses) {
                if (!licenses.contains(excludeLicense)) continue;
                unsafeLicenses.add(excludeLicense);
            }
        }
        if (CollectionUtils.isNotEmpty(whiteLicenses)) {
            licenses = this.getLicenseMap().keySet();
            this.getLog().info((CharSequence)("Included licenses (whitelist): " + whiteLicenses));
            for (String license : licenses) {
                if (whiteLicenses.contains(license)) continue;
                unsafeLicenses.add(license);
            }
        }
        if (!(safe = CollectionUtils.isEmpty(unsafeLicenses))) {
            Log log = this.getLog();
            log.warn((CharSequence)("There is " + unsafeLicenses.size() + " forbidden licenses used:"));
            for (String unsafeLicense : unsafeLicenses) {
                SortedSet deps = (SortedSet)this.getLicenseMap().get(unsafeLicense);
                StringBuilder sb = new StringBuilder();
                sb.append("License ").append(unsafeLicense).append("used by ").append(deps.size()).append(" dependencies:");
                for (MavenProject dep : deps) {
                    sb.append("\n -").append(MojoHelper.getArtifactName(dep));
                }
                log.warn((CharSequence)sb.toString());
            }
        }
        return safe;
    }

    protected void writeThirdPartyFile() throws IOException {
        if (this.doGenerate) {
            this.thirdPartyTool.writeThirdPartyFile(this.getLicenseMap(), this.thirdPartyFile, this.isVerbose(), this.getEncoding(), this.fileTemplate);
        }
        if (this.doGenerateBundle) {
            this.thirdPartyTool.writeBundleThirdPartyFile(this.thirdPartyFile, this.outputDirectory, this.bundleThirdPartyPath);
        }
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public boolean isFailIfWarning() {
        return this.failIfWarning;
    }

    public SortedMap<String, MavenProject> getProjectDependencies() {
        return this.projectDependencies;
    }

    public SortedSet<MavenProject> getUnsafeDependencies() {
        return this.unsafeDependencies;
    }

    public LicenseMap getLicenseMap() {
        return this.licenseMap;
    }

    public boolean isUseMissingFile() {
        return this.useMissingFile;
    }

    public File getMissingFile() {
        return this.missingFile;
    }

    public SortedProperties getUnsafeMappings() {
        return this.unsafeMappings;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isDoGenerate() {
        return this.doGenerate;
    }

    public boolean isDoGenerateBundle() {
        return this.doGenerateBundle;
    }
}

