/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license.header.transformer;

import org.codehaus.mojo.license.header.transformer.AbstractFileHeaderTransformer;

public class PropertiesFileHeaderTransformer
extends AbstractFileHeaderTransformer {
    public static final String NAME = "properties";
    public static final String DESCRIPTION = "header transformer with properties file comment style";
    public static final String COMMENT_LINE_PREFIX = "# ";
    public static final String COMMENT_START_TAG = "###";
    public static final String COMMENT_END_TAG = "###";
    protected final String linesep = System.getProperty("line.separator");

    public PropertiesFileHeaderTransformer() {
        super(NAME, DESCRIPTION, "###", "###", COMMENT_LINE_PREFIX);
    }

    public String[] getDefaultAcceptedExtensions() {
        return new String[]{NAME, "sh", "py", "rb", "pl", "pm"};
    }

    public String addHeader(String header, String content) {
        String result;
        int endProlog;
        String prolog = null;
        int startProlog = content.indexOf("#!");
        if (startProlog > -1 && (endProlog = content.indexOf(this.linesep)) > -1) {
            prolog = content.substring(0, endProlog + this.linesep.length());
        }
        if (prolog == null) {
            result = super.addHeader(header, content);
        } else {
            content = content.substring(prolog.length());
            result = super.addHeader(prolog + '\n' + header, content);
        }
        return result;
    }
}

