/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractAddThirdPartyMojo;
import org.codehaus.mojo.license.DependenciesTool;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.MavenProjectDependenciesConfigurator;
import org.codehaus.mojo.license.SortedProperties;
import org.codehaus.mojo.license.ThirdPartyToolException;
import org.codehaus.mojo.license.model.LicenseMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddThirdPartyMojo
extends AbstractAddThirdPartyMojo
implements MavenProjectDependenciesConfigurator {
    protected ArtifactRepository localRepository;
    protected List remoteRepositories;
    protected boolean deployMissingFile;
    protected boolean useRepositoryMissingFiles;
    private DependenciesTool dependenciesTool;
    private boolean doGenerateMissing;

    @Override
    protected boolean checkPackaging() {
        return this.rejectPackaging("pom");
    }

    @Override
    protected SortedMap<String, MavenProject> loadDependencies() {
        return this.dependenciesTool.loadProjectDependencies(this.getProject(), this, this.localRepository, this.remoteRepositories, AddThirdPartyMojo.getArtifactCache());
    }

    @Override
    protected SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException, ThirdPartyToolException {
        SortedProperties unsafeMappings = this.getThridPartyTool().loadUnsafeMapping(this.getLicenseMap(), AddThirdPartyMojo.getArtifactCache(), this.getEncoding(), this.getMissingFile());
        SortedSet<MavenProject> unsafeDependencies = this.getUnsafeDependencies();
        if (CollectionUtils.isNotEmpty(unsafeDependencies) && this.isUseRepositoryMissingFiles()) {
            ArrayList<MavenProject> projects = new ArrayList<MavenProject>(this.getProjectDependencies().values());
            projects.remove(this.getProject());
            projects.removeAll(unsafeDependencies);
            SortedProperties resolvedUnsafeMapping = this.getThridPartyTool().loadThirdPartyDescriptorsForUnsafeMapping(this.getEncoding(), projects, unsafeDependencies, this.getLicenseMap(), this.localRepository, this.remoteRepositories);
            unsafeMappings.putAll((Map<?, ?>)resolvedUnsafeMapping);
        }
        if (this.isVerbose()) {
            this.getLog().info((CharSequence)("found " + unsafeMappings.size() + " unsafe mappings"));
        }
        boolean generateMissingfile = this.computeDoGenerateMissingFile(unsafeMappings, unsafeDependencies);
        this.setDoGenerateMissing(generateMissingfile);
        if (generateMissingfile && this.isVerbose()) {
            StringBuilder sb = new StringBuilder();
            sb.append("Will use from missing file ");
            sb.append(unsafeMappings.size());
            sb.append(" dependencies :");
            for (Map.Entry<Object, Object> entry : unsafeMappings.entrySet()) {
                String id = (String)entry.getKey();
                String license = (String)entry.getValue();
                sb.append("\n - ").append(id).append(" - ").append(license);
            }
            this.getLog().info((CharSequence)sb.toString());
        } else if (this.isUseMissingFile() && !unsafeMappings.isEmpty()) {
            this.getLog().info((CharSequence)("Missing file " + this.getMissingFile() + " is up-to-date."));
        }
        return unsafeMappings;
    }

    protected boolean computeDoGenerateMissingFile(SortedProperties unsafeMappings, SortedSet<MavenProject> unsafeDependencies) throws IOException {
        if (!this.isUseMissingFile()) {
            return false;
        }
        if (this.isForce()) {
            return !CollectionUtils.isEmpty(unsafeMappings.keySet());
        }
        if (!CollectionUtils.isEmpty(unsafeDependencies)) {
            return true;
        }
        File missingFile = this.getMissingFile();
        if (!missingFile.exists()) {
            return true;
        }
        SortedProperties oldUnsafeMappings = new SortedProperties(this.getEncoding());
        oldUnsafeMappings.load(missingFile);
        return !unsafeMappings.equals(oldUnsafeMappings);
    }

    @Override
    protected boolean checkSkip() {
        if (!(this.isDoGenerate() || this.isDoGenerateBundle() || this.isDoGenerateMissing())) {
            this.getLog().info((CharSequence)"All files are up to date, skip goal execution.");
            return false;
        }
        return true;
    }

    @Override
    protected void doAction() throws Exception {
        boolean unsafe = this.checkUnsafeDependencies();
        this.writeThirdPartyFile();
        if (this.isDoGenerateMissing()) {
            this.writeMissingFile();
        }
        if (unsafe && this.isFailIfWarning()) {
            throw new MojoFailureException("There is some dependencies with no license, please fill the file " + this.getMissingFile());
        }
        if (!unsafe && this.isUseMissingFile() && MapUtils.isEmpty((Map)this.getUnsafeMappings()) && this.getMissingFile().exists()) {
            this.getLog().info((CharSequence)("There is no dependency to put in missing file, delete it at " + this.getMissingFile()));
            FileUtil.deleteFile(this.getMissingFile());
        }
        if (!unsafe && this.isDeployMissingFile() && MapUtils.isNotEmpty((Map)this.getUnsafeMappings())) {
            File file = this.getMissingFile();
            this.getLog().info((CharSequence)("Will deploy third party file from " + file));
            this.getThridPartyTool().attachThirdPartyDescriptor(this.getProject(), file);
        }
        this.addResourceDir(this.getOutputDirectory(), "**/*.txt");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeMissingFile() throws IOException {
        Log log = this.getLog();
        LicenseMap licenseMap = this.getLicenseMap();
        File file = this.getMissingFile();
        FileUtil.createDirectoryIfNecessary(file.getParentFile());
        log.info((CharSequence)("Regenerate missing license file " + file));
        FileOutputStream writer = new FileOutputStream(file);
        try {
            StringBuilder sb = new StringBuilder(" Generated by " + this.getClass().getName());
            ArrayList licenses = new ArrayList(licenseMap.keySet());
            licenses.remove(LicenseMap.getUnknownLicenseMessage());
            if (!licenses.isEmpty()) {
                sb.append("\n-------------------------------------------------------------------------------");
                sb.append("\n Already used licenses in project :");
                for (String license : licenses) {
                    sb.append("\n - ").append(license);
                }
            }
            sb.append("\n-------------------------------------------------------------------------------");
            sb.append("\n Please fill the missing licenses for dependencies :\n\n");
            this.getUnsafeMappings().store(writer, sb.toString());
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            writer.close();
            throw throwable;
        }
        writer.close();
    }

    public boolean isDoGenerateMissing() {
        return this.doGenerateMissing;
    }

    public void setDoGenerateMissing(boolean doGenerateMissing) {
        this.doGenerateMissing = doGenerateMissing;
    }

    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    public List getRemoteRepositories() {
        return this.remoteRepositories;
    }

    @Override
    public boolean isIncludeTransitiveDependencies() {
        return this.includeTransitiveDependencies;
    }

    public boolean isDeployMissingFile() {
        return this.deployMissingFile;
    }

    public boolean isUseRepositoryMissingFiles() {
        return this.useRepositoryMissingFiles;
    }
}

