/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.license;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.commons.collections.CollectionUtils;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectBuildingException;
import org.codehaus.mojo.license.AbstractLicenseMojo;
import org.codehaus.mojo.license.ArtifactHelper;
import org.codehaus.mojo.license.FileUtil;
import org.codehaus.mojo.license.LicenseMap;
import org.codehaus.mojo.license.SortedProperties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAddThirdPartyMojo
extends AbstractLicenseMojo {
    protected File outputDirectory;
    protected String thirdPartyFilename;
    protected boolean useMissingFile;
    protected File missingFile;
    protected List<String> licenseMerges;
    protected String bundleThirdPartyPath;
    protected boolean generateBundle;
    protected boolean force;
    protected boolean failIfWarning;
    protected boolean groupByLicense;
    protected String excludedGroups;
    protected String includedGroups;
    protected String excludedArtifacts;
    protected String includedArtifacts;
    protected boolean includeTransitiveDependencies;
    private LicenseMap licenseMap;
    private SortedSet<MavenProject> unsafeDependencies;
    private File thirdPartyFile;
    private SortedProperties unsafeMappings;
    private boolean doGenerate;
    private boolean doGenerateBundle;
    public static final String NO_DEPENDENCIES_MESSAGE = "the project has no dependencies.";
    private static SortedMap<String, MavenProject> artifactCache;

    public static SortedMap<String, MavenProject> getArtifactCache() {
        if (artifactCache == null) {
            artifactCache = new TreeMap<String, MavenProject>();
        }
        return artifactCache;
    }

    protected abstract SortedMap<String, MavenProject> loadDependencies();

    protected abstract SortedProperties createUnsafeMapping() throws ProjectBuildingException, IOException;

    @Override
    protected void init() throws Exception {
        Log log = this.getLog();
        if (log.isDebugEnabled()) {
            this.setVerbose(true);
        }
        File file = new File(this.getOutputDirectory(), this.getThirdPartyFilename());
        this.setThirdPartyFile(file);
        long buildTimestamp = this.getBuildTimestamp();
        if (this.isVerbose()) {
            log.info((CharSequence)("Build start   at : " + buildTimestamp));
            log.info((CharSequence)("third-party file : " + file.lastModified()));
        }
        this.setDoGenerate(this.isForce() || !file.exists() || buildTimestamp > file.lastModified());
        if (this.isGenerateBundle()) {
            File bundleFile = FileUtil.getFile(this.getOutputDirectory(), this.getBundleThirdPartyPath());
            if (this.isVerbose()) {
                log.info((CharSequence)("bundle third-party file : " + bundleFile.lastModified()));
            }
            this.setDoGenerateBundle(this.isForce() || !bundleFile.exists() || buildTimestamp > bundleFile.lastModified());
        } else {
            this.setDoGenerateBundle(false);
        }
        SortedMap<String, MavenProject> projectDependencies = this.loadDependencies();
        this.licenseMap = this.createLicenseMap(projectDependencies);
        this.unsafeDependencies = this.licenseMap.getUnsafeDependencies();
        if (!CollectionUtils.isEmpty(this.unsafeDependencies) && this.isUseMissingFile() && this.isDoGenerate()) {
            this.unsafeMappings = this.createUnsafeMapping();
        }
        if (!CollectionUtils.isEmpty(this.licenseMerges)) {
            for (String merge : this.licenseMerges) {
                merge = merge.trim();
                if (this.isVerbose()) {
                    this.getLog().info((CharSequence)("Will merge [" + merge + "]"));
                }
                String[] split = merge.split("\\|");
                this.licenseMap.mergeLicenses(split);
            }
        }
    }

    protected LicenseMap createLicenseMap(SortedMap<String, MavenProject> dependencies) {
        LicenseMap licenseMap = new LicenseMap();
        licenseMap.setLog(this.getLog());
        for (MavenProject project : dependencies.values()) {
            licenseMap.addLicense(project, project.getLicenses());
        }
        return licenseMap;
    }

    protected boolean checkUnsafeDependencies() {
        boolean unsafe;
        SortedSet<MavenProject> unsafeDependencies = this.getUnsafeDependencies();
        boolean bl = unsafe = !CollectionUtils.isEmpty(unsafeDependencies);
        if (unsafe) {
            Log log = this.getLog();
            log.warn((CharSequence)("There is " + unsafeDependencies.size() + " dependencies with no license :"));
            for (MavenProject dep : unsafeDependencies) {
                log.warn((CharSequence)(" - " + ArtifactHelper.getArtifactId(dep.getArtifact())));
            }
        }
        return unsafe;
    }

    protected void writeThirdPartyFile() throws IOException {
        Log log = this.getLog();
        LicenseMap licenseMap = this.getLicenseMap();
        File target = this.getThirdPartyFile();
        if (this.isDoGenerate()) {
            StringBuilder sb = new StringBuilder();
            if (licenseMap.isEmpty()) {
                sb.append(NO_DEPENDENCIES_MESSAGE);
            } else if (this.isGroupByLicense()) {
                sb.append("List of third-party dependencies grouped by their license type.");
                for (String licenseName : licenseMap.keySet()) {
                    SortedSet projects = (SortedSet)licenseMap.get(licenseName);
                    sb.append("\n\n").append(licenseName).append(" : ");
                    for (MavenProject mavenProject : projects) {
                        String s = ArtifactHelper.getArtifactName(mavenProject);
                        sb.append("\n  * ").append(s);
                    }
                }
            } else {
                SortedMap<MavenProject, String[]> map = licenseMap.toDependencyMap();
                sb.append("List of ").append(map.size()).append(" third-party dependencies.\n");
                ArrayList<String> lines = new ArrayList<String>();
                for (Map.Entry<MavenProject, String[]> entry : map.entrySet()) {
                    String artifact = ArtifactHelper.getArtifactName(entry.getKey());
                    StringBuilder buffer = new StringBuilder();
                    for (String license : entry.getValue()) {
                        buffer.append(" (").append(license).append(")");
                    }
                    String licenses = buffer.toString();
                    String line = licenses + " " + artifact;
                    lines.add(line);
                }
                Collections.sort(lines);
                for (String line : lines) {
                    sb.append('\n').append(line);
                }
                lines.clear();
            }
            String content = sb.toString();
            log.info((CharSequence)("Writing third-party file to " + target));
            if (this.isVerbose()) {
                log.info((CharSequence)content);
            }
            FileUtil.writeString(target, content, this.getEncoding());
        }
        if (this.isDoGenerateBundle()) {
            File bundleTarget = FileUtil.getFile(this.getOutputDirectory(), this.getBundleThirdPartyPath());
            log.info((CharSequence)("Writing bundled third-party file to " + bundleTarget));
            FileUtil.copyFile(target, bundleTarget);
        }
    }

    public boolean isGroupByLicense() {
        return this.groupByLicense;
    }

    public void setGroupByLicense(boolean groupByLicense) {
        this.groupByLicense = groupByLicense;
    }

    public File getOutputDirectory() {
        return this.outputDirectory;
    }

    public String getThirdPartyFilename() {
        return this.thirdPartyFilename;
    }

    public String getBundleThirdPartyPath() {
        return this.bundleThirdPartyPath;
    }

    public boolean isGenerateBundle() {
        return this.generateBundle;
    }

    public boolean isFailIfWarning() {
        return this.failIfWarning;
    }

    public SortedSet<MavenProject> getUnsafeDependencies() {
        return this.unsafeDependencies;
    }

    public File getThirdPartyFile() {
        return this.thirdPartyFile;
    }

    public LicenseMap getLicenseMap() {
        return this.licenseMap;
    }

    public void setOutputDirectory(File outputDirectory) {
        this.outputDirectory = outputDirectory;
    }

    public void setThirdPartyFilename(String thirdPartyFilename) {
        this.thirdPartyFilename = thirdPartyFilename;
    }

    public void setBundleThirdPartyPath(String bundleThirdPartyPath) {
        this.bundleThirdPartyPath = bundleThirdPartyPath;
    }

    public void setGenerateBundle(boolean generateBundle) {
        this.generateBundle = generateBundle;
    }

    public void setThirdPartyFile(File thirdPartyFile) {
        this.thirdPartyFile = thirdPartyFile;
    }

    public boolean isUseMissingFile() {
        return this.useMissingFile;
    }

    public File getMissingFile() {
        return this.missingFile;
    }

    public void setUseMissingFile(boolean useMissingFile) {
        this.useMissingFile = useMissingFile;
    }

    public void setMissingFile(File missingFile) {
        this.missingFile = missingFile;
    }

    public void setFailIfWarning(boolean failIfWarning) {
        this.failIfWarning = failIfWarning;
    }

    public SortedProperties getUnsafeMappings() {
        return this.unsafeMappings;
    }

    public boolean isForce() {
        return this.force;
    }

    public boolean isDoGenerate() {
        return this.doGenerate;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public void setDoGenerate(boolean doGenerate) {
        this.doGenerate = doGenerate;
    }

    public boolean isDoGenerateBundle() {
        return this.doGenerateBundle;
    }

    public void setDoGenerateBundle(boolean doGenerateBundle) {
        this.doGenerateBundle = doGenerateBundle;
    }

    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(String excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public String getIncludedGroups() {
        return this.includedGroups;
    }

    public void setIncludedGroups(String includedGroups) {
        this.includedGroups = includedGroups;
    }

    public String getExcludedArtifacts() {
        return this.excludedArtifacts;
    }

    public void setExcludedArtifacts(String excludedArtifacts) {
        this.excludedArtifacts = excludedArtifacts;
    }

    public String getIncludedArtifacts() {
        return this.includedArtifacts;
    }

    public void setIncludedArtifacts(String includedArtifacts) {
        this.includedArtifacts = includedArtifacts;
    }
}

