/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma.task;

import com.vladium.emma.instr.InstrProcessor;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import org.codehaus.mojo.emma.task.AbstractTask;

public class InstrumentTask
extends AbstractTask {
    private File[] instrumentationPaths = new File[0];
    private boolean merge;
    private File metadataFile;
    private String[] filters = new String[0];

    public void execute() throws IOException {
        InstrProcessor processor = InstrProcessor.create();
        processor.setInstrOutDir(this.getOutputDirectory().getCanonicalPath());
        processor.setMetaOutFile(this.metadataFile.getCanonicalPath());
        processor.setMetaOutMerge(Boolean.valueOf(this.merge));
        processor.setOutMode(InstrProcessor.OutMode.OUT_MODE_FULLCOPY);
        String[] paths = this.getCanonicalPaths(this.instrumentationPaths);
        if (paths != null) {
            processor.setInstrPath(paths, true);
        }
        if (this.filters != null) {
            ArrayList<String> nonNullFilters = new ArrayList<String>(this.filters.length);
            for (int i = 0; i < this.filters.length; ++i) {
                if (this.filters[i] == null) continue;
                nonNullFilters.add(this.filters[i]);
            }
            processor.setInclExclFilter(nonNullFilters.toArray(new String[nonNullFilters.size()]));
        }
        Properties props = new Properties();
        if (this.isVerbose()) {
            props.setProperty("verbosity.level", "verbose");
        }
        processor.setPropertyOverrides(props);
        processor.run();
    }

    public File[] getInstrumentationPaths() {
        return this.instrumentationPaths;
    }

    public void setInstrumentationPaths(File[] instrumentationPaths) {
        this.instrumentationPaths = instrumentationPaths;
    }

    public boolean isMerge() {
        return this.merge;
    }

    public void setMerge(boolean merge) {
        this.merge = merge;
    }

    public File getMetadataFile() {
        return this.metadataFile;
    }

    public void setMetadataFile(File metadataFile) {
        this.metadataFile = metadataFile;
    }

    public String[] getFilters() {
        return this.filters;
    }

    public void setFilters(String[] filters) {
        this.filters = filters;
    }
}

