/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;

public class HelpMojo
extends AbstractMojo {
    private boolean detail;
    private String goal;
    private int lineLength;
    private int indentSize;

    public void execute() throws MojoExecutionException {
        if (this.lineLength <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'lineLength' should be positive, using '80' as default.");
            this.lineLength = 80;
        }
        if (this.indentSize <= 0) {
            this.getLog().warn((CharSequence)"The parameter 'indentSize' should be positive, using '2' as default.");
            this.indentSize = 2;
        }
        StringBuffer sb = new StringBuffer();
        this.append(sb, "org.codehaus.mojo:emma-maven-plugin:1.0-alpha-3", 0);
        this.append(sb, "", 0);
        this.append(sb, "Emma Maven Plugin", 0);
        this.append(sb, "EMMA plugin for Maven 2. Measures test code coverage using EMMA.", 1);
        this.append(sb, "", 0);
        if (this.goal == null || this.goal.length() <= 0) {
            this.append(sb, "This plugin has 5 goals:", 0);
            this.append(sb, "", 0);
        }
        if (this.goal == null || this.goal.length() <= 0 || "check".equals(this.goal)) {
            this.append(sb, "emma:check", 0);
            this.append(sb, "Check last intrumentation results.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "check", 2);
                this.append(sb, "Check configuration.", 3);
                this.append(sb, "", 0);
                this.append(sb, "coverageFile (Default: ${project.reporting.outputDirectory}/emma/coverage.xml)", 2);
                this.append(sb, "Location to XML coverage file.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dataFiles", 2);
                this.append(sb, "Class coverage data files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "metadataFile (Default: ${project.build.directory}/coverage.em)", 2);
                this.append(sb, "Location to store class coverage metadata.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/emma)", 2);
                this.append(sb, "Location to store EMMA generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Sets EMMA verbosity level to verbose.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "clean".equals(this.goal)) {
            this.append(sb, "emma:clean", 0);
            this.append(sb, "Clean EMMA generated resources.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "dataFiles", 2);
                this.append(sb, "Class coverage data files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "metadataFile (Default: ${project.build.directory}/coverage.em)", 2);
                this.append(sb, "Location to store class coverage metadata.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-classes/emma)", 2);
                this.append(sb, "Location to store EMMA generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Sets EMMA verbosity level to verbose.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "emma".equals(this.goal)) {
            this.append(sb, "emma:emma", 0);
            this.append(sb, "Instruments, tests, and generates an EMMA report.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "columns (Default: name,class,method,block,line)", 2);
                this.append(sb, "Specifies which report columns and in which order to use for report generation, as a comma-separated list of column ids.", 3);
                this.append(sb, "", 0);
                this.append(sb, "dataFiles", 2);
                this.append(sb, "Class coverage data files.", 3);
                this.append(sb, "", 0);
                this.append(sb, "depth (Default: method)", 2);
                this.append(sb, "Specifies the amount of detail to be included in the generated coverage reports. Valid values are: all, package, source, class, method.", 3);
                this.append(sb, "", 0);
                this.append(sb, "metadataFile (Default: ${project.build.directory}/coverage.em)", 2);
                this.append(sb, "Location to store class coverage metadata.", 3);
                this.append(sb, "", 0);
                this.append(sb, "metrics (Default: method:70,block:70,line:80,class:100)", 2);
                this.append(sb, "Specifies the threshold coverage metrics values for a given set of columns.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.reporting.outputDirectory}/emma)", 2);
                this.append(sb, "Output directory for the report.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputEncoding (Default: ${project.reporting.outputEncoding})", 2);
                this.append(sb, "Report encoding.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sort (Default: +block,+name,+method,+class)", 2);
                this.append(sb, "Specifies report column sorting order, as a comma-separated list of columns ids prefixed with '+' for ascending or '-' for descending directions.", 3);
                this.append(sb, "", 0);
                this.append(sb, "sourcePaths", 2);
                this.append(sb, "Source locations.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Sets EMMA verbosity level to verbose.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "help".equals(this.goal)) {
            this.append(sb, "emma:help", 0);
            this.append(sb, "Display help information on emma-maven-plugin.\nCall\n\u00a0\u00a0mvn\u00a0emma:help\u00a0-Ddetail=true\u00a0-Dgoal=<goal-name>\nto display parameter details.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "detail (Default: false)", 2);
                this.append(sb, "If true, display all settable properties for each goal.", 3);
                this.append(sb, "", 0);
                this.append(sb, "goal", 2);
                this.append(sb, "The name of the goal for which to show help. If unspecified, all goals will be displayed.", 3);
                this.append(sb, "", 0);
                this.append(sb, "indentSize (Default: 2)", 2);
                this.append(sb, "The number of spaces per indentation level, should be positive.", 3);
                this.append(sb, "", 0);
                this.append(sb, "lineLength (Default: 80)", 2);
                this.append(sb, "The maximum length of a display line, should be positive.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.goal == null || this.goal.length() <= 0 || "instrument".equals(this.goal)) {
            this.append(sb, "emma:instrument", 0);
            this.append(sb, "Offline class instrumentor.", 1);
            this.append(sb, "", 0);
            if (this.detail) {
                this.append(sb, "Available parameters:", 1);
                this.append(sb, "", 0);
                this.append(sb, "filters", 2);
                this.append(sb, "Instrumentation filters.", 3);
                this.append(sb, "", 0);
                this.append(sb, "instrumentationPaths", 2);
                this.append(sb, "Specifies the instrumentation paths to use.", 3);
                this.append(sb, "", 0);
                this.append(sb, "merge (Default: true)", 2);
                this.append(sb, "Indicates whether the metadata should be merged into the destination metadataFile, if any.", 3);
                this.append(sb, "", 0);
                this.append(sb, "metadataFile (Default: ${project.build.directory}/coverage.em)", 2);
                this.append(sb, "Location to store class coverage metadata.", 3);
                this.append(sb, "", 0);
                this.append(sb, "outputDirectory (Default: ${project.build.directory}/generated-classes/emma)", 2);
                this.append(sb, "Location to store EMMA generated resources.", 3);
                this.append(sb, "", 0);
                this.append(sb, "verbose (Default: false)", 2);
                this.append(sb, "Sets EMMA verbosity level to verbose.", 3);
                this.append(sb, "", 0);
            }
        }
        if (this.getLog().isInfoEnabled()) {
            this.getLog().info((CharSequence)sb.toString());
        }
    }

    private static String repeat(String str, int repeat) {
        StringBuffer buffer = new StringBuffer(repeat * str.length());
        for (int i = 0; i < repeat; ++i) {
            buffer.append(str);
        }
        return buffer.toString();
    }

    private void append(StringBuffer sb, String description, int indent) {
        Iterator it = HelpMojo.toLines(description, indent, this.indentSize, this.lineLength).iterator();
        while (it.hasNext()) {
            sb.append(it.next().toString()).append('\n');
        }
    }

    private static List toLines(String text, int indent, int indentSize, int lineLength) {
        ArrayList lines = new ArrayList();
        String ind = HelpMojo.repeat("\t", indent);
        String[] plainLines = text.split("(\r\n)|(\r)|(\n)");
        for (int i = 0; i < plainLines.length; ++i) {
            HelpMojo.toLines(lines, ind + plainLines[i], indentSize, lineLength);
        }
        return lines;
    }

    private static void toLines(List lines, String line, int indentSize, int lineLength) {
        int lineIndent = HelpMojo.getIndentLevel(line);
        StringBuffer buf = new StringBuffer(256);
        String[] tokens = line.split(" +");
        for (int i = 0; i < tokens.length; ++i) {
            String token = tokens[i];
            if (i > 0) {
                if (buf.length() + token.length() >= lineLength) {
                    lines.add(buf.toString());
                    buf.setLength(0);
                    buf.append(HelpMojo.repeat(" ", lineIndent * indentSize));
                } else {
                    buf.append(' ');
                }
            }
            for (int j = 0; j < token.length(); ++j) {
                char c = token.charAt(j);
                if (c == '\t') {
                    buf.append(HelpMojo.repeat(" ", indentSize - buf.length() % indentSize));
                    continue;
                }
                if (c == '\u00a0') {
                    buf.append(' ');
                    continue;
                }
                buf.append(c);
            }
        }
        lines.add(buf.toString());
    }

    private static int getIndentLevel(String line) {
        int i;
        int level = 0;
        for (i = 0; i < line.length() && line.charAt(i) == '\t'; ++i) {
            ++level;
        }
        for (i = level + 1; i <= level + 4 && i < line.length(); ++i) {
            if (line.charAt(i) != '\t') continue;
            ++level;
            break;
        }
        return level;
    }
}

