/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.emma;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;

class EmmaUtils {
    private EmmaUtils() {
    }

    public static File[] fixDataFileLocations(MavenProject project, File[] dataFiles) {
        if (dataFiles == null) {
            return new File[0];
        }
        ArrayList<File> newDataFiles = new ArrayList<File>(dataFiles.length);
        for (int i = 0; i < dataFiles.length; ++i) {
            File src = dataFiles[i];
            if (!src.exists()) continue;
            if (src.getParentFile().equals(project.getBasedir())) {
                File dst = new File(project.getBuild().getDirectory(), "coverage-" + i + ".ec");
                try {
                    FileUtils.rename((File)src, (File)dst);
                }
                catch (IOException e) {
                    IllegalStateException e2 = new IllegalStateException("Failed to move coverage data file: " + src.getAbsolutePath());
                    e2.initCause(e);
                    throw e2;
                }
                newDataFiles.add(dst);
                continue;
            }
            newDataFiles.add(src);
        }
        return newDataFiles.toArray(new File[newDataFiles.size()]);
    }
}

