/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart.time;

import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import org.codehaus.mojo.dashboard.report.plugin.beans.CoberturaReportBean;
import org.codehaus.mojo.dashboard.report.plugin.chart.time.AbstractTimeChartStrategy;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.labels.StandardXYItemLabelGenerator;
import org.jfree.chart.labels.XYItemLabelGenerator;
import org.jfree.data.time.TimeSeries;

public class CoberturaTimeChartStrategy
extends AbstractTimeChartStrategy {
    private TimeSeries linecoverSerie;
    private TimeSeries branchcoverSerie;

    public CoberturaTimeChartStrategy(ResourceBundle bundle, String title, List results, String timeUnit, Date startDate, Date endDate) {
        super(bundle, title, results, timeUnit, startDate, endDate);
    }

    public void fillDataset() {
        this.linecoverSerie = new TimeSeries(this.bundle.getString("report.cobertura.label.linecover"), this.periodClass);
        this.branchcoverSerie = new TimeSeries(this.bundle.getString("report.cobertura.label.branchcover"), this.periodClass);
        Iterator iter = this.mResults.iterator();
        while (iter.hasNext()) {
            CoberturaReportBean cober = (CoberturaReportBean)iter.next();
            Date date = cober.getDateGeneration();
            this.linecoverSerie.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), cober.getLineCoverRate());
            this.branchcoverSerie.addOrUpdate(this.getChartDate(this.timePeriod.normalize(date)), cober.getBranchCoverRate());
        }
        this.defaultdataset.addSeries(this.linecoverSerie);
        this.defaultdataset.addSeries(this.branchcoverSerie);
    }

    public NumberAxis getRangeAxis() {
        NumberAxis valueaxis = new NumberAxis();
        valueaxis.setLowerMargin(0.0);
        valueaxis.setUpperMargin(0.099);
        valueaxis.setRangeWithMargins(0.0, 1.0);
        valueaxis.setLabel(this.getYAxisLabel());
        valueaxis.setNumberFormatOverride(NumberFormat.getPercentInstance());
        return valueaxis;
    }

    public String getYAxisLabel() {
        return this.bundle.getString("report.cobertura.label.coverage");
    }

    public XYItemLabelGenerator getLabelGenerator() {
        StandardXYItemLabelGenerator labelgenerator = new StandardXYItemLabelGenerator("{2}", (DateFormat)this.timePeriod.getDateFormat(), NumberFormat.getPercentInstance(Locale.getDefault()));
        return labelgenerator;
    }
}

