/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.chart;

import java.awt.Font;
import java.awt.Paint;
import org.codehaus.mojo.dashboard.report.plugin.chart.AbstractChartRenderer;
import org.codehaus.mojo.dashboard.report.plugin.chart.IChartStrategy;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.plot.PiePlot;
import org.jfree.data.general.PieDataset;
import org.jfree.util.Rotation;

public class PieChartRenderer
extends AbstractChartRenderer {
    private static final int FONT_SIZE = 10;
    private static final double INTERIOR_GAP = 0.33;
    private static final double LABEL_GAP = 0.02;
    private static final double START_ANGLE = 45.0;

    public PieChartRenderer(IChartStrategy strategy) {
        super(strategy);
    }

    public PieChartRenderer(IChartStrategy strategy, int width, int height) {
        super(strategy, width, height);
    }

    public void createChart() {
        PieDataset dataset = (PieDataset)this.datasetStrategy.getDataset();
        this.report = ChartFactory.createPieChart((String)this.datasetStrategy.getTitle(), (PieDataset)dataset, (boolean)true, (boolean)true, (boolean)false);
        PiePlot plot = (PiePlot)this.report.getPlot();
        plot.setCircular(false);
        plot.setDirection(Rotation.ANTICLOCKWISE);
        plot.setInteriorGap(0.33);
        plot.setLabelFont(new Font("Lucida", 0, 10));
        plot.setLabelGap(0.02);
        plot.setNoDataMessage("No data available");
        plot.setStartAngle(45.0);
        Paint[] paints = this.datasetStrategy.getPaintColor();
        for (int i = 0; i < dataset.getItemCount() && i < paints.length; ++i) {
            plot.setSectionPaint(i, paints[i]);
        }
    }
}

