/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.dashboard.report.plugin.beans;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.codehaus.mojo.dashboard.report.plugin.beans.AbstractReportBean;
import org.codehaus.mojo.dashboard.report.plugin.beans.IDashBoardReportBean;

public class DashBoardMavenProject {
    private String projectName;
    private String artifactId;
    private String groupId;
    private String version;
    private long id;
    private Set modules = new HashSet();
    private Set reports = new HashSet();
    private transient Map reportsByType = new Hashtable();

    public DashBoardMavenProject() {
    }

    public DashBoardMavenProject(String artifactId) {
        this.artifactId = artifactId;
    }

    public DashBoardMavenProject(String artifactId, String groupId) {
        this.artifactId = artifactId;
        this.groupId = groupId;
    }

    public DashBoardMavenProject(String artifactId, String groupId, String projectName) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.projectName = projectName;
    }

    public DashBoardMavenProject(String artifactId, String groupId, String projectName, String version) {
        this.artifactId = artifactId;
        this.groupId = groupId;
        this.projectName = projectName;
        this.version = version;
    }

    public String getProjectName() {
        return this.projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public void setArtifactId(String artifactId) {
        this.artifactId = artifactId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public void setGroupId(String groupId) {
        this.groupId = groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public Set getModules() {
        return this.modules;
    }

    public void setModules(Set modules) {
        this.modules = modules;
    }

    public void addModule(DashBoardMavenProject module) {
        this.modules.add(module);
        this.fillReports(module);
    }

    private void fillReports(DashBoardMavenProject module) {
        if (this.reports.isEmpty()) {
            Set reportsModule = module.getReports();
            Iterator iter = reportsModule.iterator();
            while (iter.hasNext()) {
                AbstractReportBean report = (AbstractReportBean)iter.next();
                if (report == null) continue;
                this.reports.add(report.clone());
            }
        } else {
            Set reportsModule = module.getReports();
            Iterator iter = reportsModule.iterator();
            while (iter.hasNext()) {
                AbstractReportBean report = (AbstractReportBean)iter.next();
                boolean isMerge = false;
                if (report == null) continue;
                Iterator iterInternal = this.reports.iterator();
                while (iterInternal.hasNext()) {
                    IDashBoardReportBean reportInternal = (IDashBoardReportBean)iterInternal.next();
                    if (reportInternal == null || !reportInternal.getClass().equals(report.getClass())) continue;
                    reportInternal.merge(report);
                    isMerge = true;
                }
                if (isMerge) continue;
                this.reports.add(report.clone());
            }
        }
    }

    public Set getReports() {
        return this.reports;
    }

    public void setReports(Set reports) {
        this.reports = reports;
    }

    public void addReport(AbstractReportBean report) {
        this.reports.add(report);
    }

    public AbstractReportBean getReportsByType(Class classname) {
        if (this.reportsByType == null || this.reportsByType.isEmpty()) {
            this.reportsByType = new Hashtable();
            Iterator iter = this.reports.iterator();
            while (iter.hasNext()) {
                IDashBoardReportBean report = (IDashBoardReportBean)iter.next();
                if (report == null) continue;
                this.reportsByType.put(report.getClass(), report);
            }
        }
        return (AbstractReportBean)this.reportsByType.get(classname);
    }
}

