/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.cobertura;

import java.io.File;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.codehaus.doxia.sink.Sink;
import org.codehaus.doxia.site.renderer.SiteRenderer;
import org.codehaus.mojo.cobertura.tasks.ReportTask;

public class CoberturaReportMojo
extends AbstractMavenReport {
    private String format;
    private String[] formats = new String[]{"html"};
    private String maxmem = "64m";
    protected File dataFile;
    protected List pluginClasspathList;
    private File outputDirectory;
    private SiteRenderer siteRenderer;
    private MavenProject project;

    public String getName(Locale locale) {
        return "Cobertura Test Coverage";
    }

    public String getDescription(Locale locale) {
        return "Cobertura Test Coverage Report.";
    }

    protected String getOutputDirectory() {
        return this.outputDirectory.getAbsolutePath();
    }

    protected MavenProject getProject() {
        return this.project;
    }

    protected SiteRenderer getSiteRenderer() {
        return this.siteRenderer;
    }

    public void generate(Sink sink, Locale locale) throws MavenReportException {
        this.executeReport(locale);
    }

    private void executeReportTask(ReportTask task, String format) throws MavenReportException {
        task.setOutputFormat(format);
        try {
            task.execute();
        }
        catch (MojoExecutionException e) {
            throw new MavenReportException("Error in Cobertura Report generation: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    protected void executeReport(Locale locale) throws MavenReportException {
        if (!this.canGenerateReport()) {
            return;
        }
        ReportTask task = new ReportTask();
        task.setLog(this.getLog());
        task.setPluginClasspathList(this.pluginClasspathList);
        task.setMaxmem(this.maxmem);
        task.setDataFile(this.dataFile);
        task.setOutputDirectory(this.outputDirectory);
        task.setCompileSourceRoots(this.getCompileSourceRoots());
        if (this.format != null) {
            this.formats = new String[]{this.format};
        }
        for (int i = 0; i < this.formats.length; ++i) {
            this.executeReportTask(task, this.formats[i]);
        }
    }

    public String getOutputName() {
        return "cobertura/index";
    }

    public boolean isExternalReport() {
        return true;
    }

    public boolean canGenerateReport() {
        boolean canGenerate = false;
        Iterator i = this.getCompileSourceRoots().iterator();
        while (i.hasNext() && !canGenerate) {
            String sourceDirectory = (String)i.next();
            canGenerate = new File(sourceDirectory).exists();
        }
        return canGenerate;
    }

    private List getCompileSourceRoots() {
        return this.project.getExecutionProject().getCompileSourceRoots();
    }
}

