/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSampleGroup;
import org.codehaus.mojo.chronos.common.model.ResponsetimeSamples;
import org.codehaus.mojo.chronos.report.chart.ChartSource;
import org.codehaus.mojo.chronos.report.chart.ChronosReportPlugin;
import org.codehaus.mojo.chronos.report.chart.DetailsHistogramChartSource;
import org.codehaus.mojo.chronos.report.chart.SummaryHistogramChartSource;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ChronosHistogramPlugin
implements ChronosReportPlugin {
    private GroupedResponsetimeSamples samples;

    public ChronosHistogramPlugin(GroupedResponsetimeSamples samples) {
        this.samples = samples;
    }

    @Override
    public ChartSource getSummaryChartSource() {
        return new SummaryHistogramChartSource((ResponsetimeSamples)this.samples);
    }

    @Override
    public Map<String, ChartSource> getDetailChartSources() {
        LinkedHashMap<String, ChartSource> testname2ChartSource = new LinkedHashMap<String, ChartSource>();
        if (this.samples == null) {
            return testname2ChartSource;
        }
        for (ResponsetimeSampleGroup sampleGroup : this.samples.getSampleGroups()) {
            testname2ChartSource.put(sampleGroup.getName(), new DetailsHistogramChartSource(sampleGroup));
        }
        return testname2ChartSource;
    }
}

