/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.chronos.report.chart;

import java.awt.Color;
import java.awt.Paint;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.codehaus.mojo.chronos.common.model.GCSamples;
import org.codehaus.mojo.chronos.common.model.GroupedResponsetimeSamples;
import org.codehaus.mojo.chronos.report.chart.ChronosGCPlugin;
import org.codehaus.mojo.chronos.report.chart.ChronosHistogramPlugin;
import org.codehaus.mojo.chronos.report.chart.ChronosReportPlugin;
import org.codehaus.mojo.chronos.report.chart.ChronosResponsetimePlugin;
import org.codehaus.mojo.chronos.report.chart.ChronosThroughputPlugin;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.DateAxis;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.axis.ValueAxis;
import org.jfree.chart.labels.StandardXYToolTipGenerator;
import org.jfree.chart.labels.XYToolTipGenerator;
import org.jfree.chart.plot.CombinedDomainXYPlot;
import org.jfree.chart.plot.Marker;
import org.jfree.chart.plot.Plot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.plot.ValueMarker;
import org.jfree.chart.plot.XYPlot;
import org.jfree.chart.renderer.xy.StandardXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.chart.renderer.xy.XYLineAndShapeRenderer;
import org.jfree.data.time.TimeSeries;
import org.jfree.data.time.TimeSeriesCollection;
import org.jfree.data.xy.XYDataset;
import org.jfree.ui.RectangleAnchor;
import org.jfree.ui.TextAnchor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChartUtil {
    private static final double GAP = 10.0;
    private static final double MARGIN = 0.02;

    public static void addDomainMarker(XYPlot xyplot, String label, double value) {
        xyplot.addDomainMarker((Marker)ChartUtil.addValueMarker(label, value, true));
    }

    public static void addRangeMarker(XYPlot xyplot, String label, double value) {
        xyplot.addRangeMarker((Marker)ChartUtil.addValueMarker(label, value, false));
    }

    public static List<ChronosReportPlugin> createDefaultPlugins(GroupedResponsetimeSamples samples, GCSamples gcSamples) {
        ArrayList<ChronosReportPlugin> plugins = new ArrayList<ChronosReportPlugin>();
        plugins.add(new ChronosResponsetimePlugin(samples));
        plugins.add(new ChronosHistogramPlugin(samples));
        plugins.add(new ChronosThroughputPlugin(samples));
        plugins.add(new ChronosGCPlugin(gcSamples));
        return plugins;
    }

    public static XYPlot newPlot(TimeSeries timeSeries, String label, boolean forceIncludeZero) {
        XYDataset dataset = ChartUtil.asDataset(timeSeries);
        return ChartUtil.newPlot(label, forceIncludeZero, dataset);
    }

    public static XYPlot setUpperBound(JFreeChart chart, double max) {
        XYPlot plot = chart.getXYPlot();
        ValueAxis axis = plot.getDomainAxis();
        axis.setUpperBound(max);
        return plot;
    }

    public static XYPlot setupXYPlot(JFreeChart chart, DateFormat dateFormat) {
        XYPlot plot = chart.getXYPlot();
        DateAxis axis = (DateAxis)plot.getDomainAxis();
        axis.setDateFormatOverride(dateFormat);
        NumberAxis rangeAxis = (NumberAxis)plot.getRangeAxis();
        rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        return plot;
    }

    static CombinedDomainXYPlot createCombinedPlot(DateAxis timeAxis, XYPlot xyplot1, XYPlot xyplot2) {
        CombinedDomainXYPlot combineddomainxyplot = new CombinedDomainXYPlot((ValueAxis)timeAxis);
        combineddomainxyplot.setGap(10.0);
        combineddomainxyplot.add(xyplot1, 2);
        combineddomainxyplot.add(xyplot2, 1);
        combineddomainxyplot.setOrientation(PlotOrientation.VERTICAL);
        return combineddomainxyplot;
    }

    static DateAxis createTimeAxis(String label, SimpleDateFormat dateFormat) {
        DateAxis timeAxis = new DateAxis(label);
        timeAxis.setDateFormatOverride((DateFormat)dateFormat);
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        return timeAxis;
    }

    static XYPlot newPlot(String verticalLabel, boolean forceIncludeZero, XYDataset dataset) {
        StandardXYItemRenderer standardxyitemrenderer = new StandardXYItemRenderer();
        NumberAxis numberaxis = new NumberAxis(verticalLabel);
        numberaxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
        numberaxis.setAutoRangeIncludesZero(forceIncludeZero);
        return new XYPlot(dataset, null, (ValueAxis)numberaxis, (XYItemRenderer)standardxyitemrenderer);
    }

    private static ValueMarker addValueMarker(String text, double x, boolean domain) {
        ValueMarker marker = new ValueMarker(x);
        marker.setPaint((Paint)Color.GRAY);
        marker.setLabel(text);
        if (domain) {
            marker.setLabelAnchor(RectangleAnchor.TOP_LEFT);
            marker.setLabelTextAnchor(TextAnchor.TOP_RIGHT);
        } else {
            marker.setLabelAnchor(RectangleAnchor.TOP_RIGHT);
            marker.setLabelTextAnchor(TextAnchor.BOTTOM_RIGHT);
        }
        return marker;
    }

    private static XYDataset asDataset(TimeSeries series) {
        TimeSeriesCollection dataset = new TimeSeriesCollection();
        dataset.addSeries(series);
        return dataset;
    }

    public static JFreeChart createTimeSeriesChart(XYDataset dataset, String title, String timeAxisLabel, String valueAxisLabel) {
        DateAxis timeAxis = new DateAxis(timeAxisLabel, TimeZone.getTimeZone("GMT"), Locale.getDefault());
        timeAxis.setLowerMargin(0.02);
        timeAxis.setUpperMargin(0.02);
        NumberAxis valueAxis = new NumberAxis(valueAxisLabel);
        valueAxis.setAutoRangeIncludesZero(false);
        XYPlot plot = new XYPlot(dataset, (ValueAxis)timeAxis, (ValueAxis)valueAxis, null);
        StandardXYToolTipGenerator toolTipGenerator = StandardXYToolTipGenerator.getTimeSeriesInstance();
        XYLineAndShapeRenderer renderer = new XYLineAndShapeRenderer(true, false);
        renderer.setBaseToolTipGenerator((XYToolTipGenerator)toolTipGenerator);
        boolean addLegend = true;
        return new JFreeChart(title, JFreeChart.DEFAULT_TITLE_FONT, (Plot)plot, addLegend);
    }
}

