/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.clearcaselib;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import org.apache.maven.changelog.AbstractChangeLogGenerator;
import org.apache.tools.ant.types.Commandline;

public class ClearcaseChangeLogGenerator
extends AbstractChangeLogGenerator {
    protected Commandline getScmLogCommand() {
        Commandline command = new Commandline();
        command.setExecutable("cleartool");
        command.createArgument().setValue("lshistory");
        StringBuffer format = new StringBuffer();
        format.append("NAME:%En\\n");
        format.append("DATE:%Nd\\n");
        format.append("COMM:%-12.12o - ");
        String commentFormat = this.getCommentFormat();
        if (commentFormat == null) {
            format.append("%Sn - %c - Activity: %[activity]p\\n");
        } else {
            format.append(commentFormat);
        }
        format.append("USER:%-8.8u\\n");
        command.createArgument().setValue("-fmt");
        command.createArgument().setValue(format.toString());
        command.createArgument().setValue("-recurse");
        command.createArgument().setValue("-nco");
        command.createArgument().setValue("-since");
        command.createArgument().setValue(this.dateRange);
        return command;
    }

    protected String getScmDateArgument(Date before, Date to) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MMM-yyyy", Locale.ENGLISH);
        String argument = sdf.format(before);
        return argument;
    }

    protected String getScmTagArgument(String tagStart, String tagEnd) {
        throw new UnsupportedOperationException("This plugin currently does not support generating logs from tags with Clearcase.");
    }
}

