/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.util.Objects;
import org.apache.maven.artifact.ArtifactUtils;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.buildhelper.AbstractDefinePropertyMojo;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

@Mojo(name="released-version", defaultPhase=LifecyclePhase.VALIDATE, threadSafe=true)
public class ReleasedVersionMojo
extends AbstractDefinePropertyMojo {
    @Component
    private RepositorySystem repoSystem;
    @Component
    private ArtifactHandlerManager artifactHandlerManager;
    @Parameter(defaultValue="${repositorySystemSession}", readonly=true)
    private RepositorySystemSession repoSession;
    @Parameter(defaultValue="releasedVersion")
    private String propertyPrefix;

    private void defineVersionProperty(String name, String value) {
        this.defineProperty(this.propertyPrefix + '.' + name, Objects.toString(value, ""));
    }

    private void defineVersionProperty(String name, int value) {
        this.defineVersionProperty(name, Integer.toString(value));
    }

    public void execute() {
        block5: {
            try {
                DefaultArtifact artifact = new DefaultArtifact(this.getProject().getGroupId(), this.getProject().getArtifactId(), this.artifactHandlerManager.getArtifactHandler(this.getProject().getPackaging()).getExtension(), "[0,)");
                this.getLog().debug((CharSequence)("Artifact for lookup released version: " + artifact));
                VersionRangeRequest request = new VersionRangeRequest((Artifact)artifact, this.getProject().getRemoteProjectRepositories(), null);
                VersionRangeResult versionRangeResult = this.repoSystem.resolveVersionRange(this.repoSession, request);
                this.getLog().debug((CharSequence)("Resolved versions: " + versionRangeResult.getVersions()));
                DefaultArtifactVersion releasedVersion = versionRangeResult.getVersions().stream().filter(v -> !ArtifactUtils.isSnapshot((String)v.toString())).map(v -> new DefaultArtifactVersion(v.toString())).max(DefaultArtifactVersion::compareTo).orElse(null);
                this.getLog().debug((CharSequence)("Released version: " + releasedVersion));
                if (releasedVersion != null) {
                    String releasedVersionValue = releasedVersion.toString();
                    int dashIndex = releasedVersionValue.indexOf(45);
                    if (dashIndex >= 0) {
                        releasedVersionValue = releasedVersionValue.substring(0, dashIndex);
                    }
                    this.defineVersionProperty("version", releasedVersionValue);
                    this.defineVersionProperty("majorVersion", releasedVersion.getMajorVersion());
                    this.defineVersionProperty("minorVersion", releasedVersion.getMinorVersion());
                    this.defineVersionProperty("incrementalVersion", releasedVersion.getIncrementalVersion());
                    this.defineVersionProperty("buildNumber", releasedVersion.getBuildNumber());
                    this.defineVersionProperty("qualifier", releasedVersion.getQualifier());
                } else {
                    this.getLog().debug((CharSequence)"No released version found.");
                }
            }
            catch (VersionRangeResolutionException e) {
                if (!this.getLog().isWarnEnabled()) break block5;
                this.getLog().warn((CharSequence)"Failed to retrieve artifacts metadata, cannot resolve the released version");
            }
        }
    }
}

