/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.buildhelper;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.ServerSocket;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Mojo(name="reserve-network-port", defaultPhase=LifecyclePhase.PROCESS_TEST_CLASSES, threadSafe=true)
public class ReserveListenerPortMojo
extends AbstractMojo {
    private static final String BUILD_HELPER_RESERVED_PORTS = "BUILD_HELPER_MIN_PORT";
    private static final Integer FIRST_NON_ROOT_PORT_NUMBER = 1024;
    private static final Integer MAX_PORT_NUMBER = 65536;
    @Parameter(required=true)
    private String[] portNames = new String[0];
    @Parameter
    private File outputFile;
    @Parameter
    private Integer minPortNumber;
    @Parameter
    private Integer maxPortNumber;
    @Component
    private MavenProject project;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        block16: {
            Properties properties = this.project.getProperties();
            if (this.outputFile != null) {
                properties = new Properties();
            }
            ArrayList<ServerSocket> sockets = new ArrayList<ServerSocket>();
            try {
                for (String portName : this.portNames) {
                    try {
                        ServerSocket socket = this.getServerSocket();
                        sockets.add(socket);
                        String unusedPort = Integer.toString(socket.getLocalPort());
                        properties.put(portName, unusedPort);
                        this.getReservedPorts().add(socket.getLocalPort());
                        this.getLog().info((CharSequence)("Reserved port " + unusedPort + " for " + portName));
                    }
                    catch (IOException e) {
                        throw new MojoExecutionException("Error getting an available port from system", (Exception)e);
                    }
                }
                if (this.outputFile == null) break block16;
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(this.outputFile);
                    properties.store(os, null);
                }
                catch (Exception e) {
                    try {
                        throw new MojoExecutionException(e.getMessage());
                    }
                    catch (Throwable throwable) {
                        IOUtil.close(os);
                        throw throwable;
                    }
                }
                IOUtil.close((OutputStream)os);
            }
            finally {
                for (ServerSocket socket : sockets) {
                    int localPort = socket.getLocalPort();
                    try {
                        socket.close();
                    }
                    catch (IOException e) {
                        this.getLog().error((CharSequence)("Cannot free reserved port " + localPort));
                    }
                }
            }
        }
    }

    private ServerSocket getServerSocket() throws IOException, MojoExecutionException {
        int min;
        if (this.minPortNumber == null && this.maxPortNumber != null) {
            this.getLog().debug((CharSequence)("minPortNumber unspecified:     using default value " + FIRST_NON_ROOT_PORT_NUMBER));
            this.minPortNumber = FIRST_NON_ROOT_PORT_NUMBER;
        }
        if (this.minPortNumber != null && this.maxPortNumber == null) {
            this.getLog().debug((CharSequence)("maxPortNumber unspecified: using default value " + MAX_PORT_NUMBER));
            this.maxPortNumber = MAX_PORT_NUMBER;
        }
        if (this.minPortNumber == null && this.maxPortNumber == null) {
            return new ServerSocket(0);
        }
        int port = min = this.getNextPortNumber();
        while (true) {
            if (port > this.maxPortNumber) {
                throw new MojoExecutionException("Unable to find an available port between " + this.minPortNumber + " and " + this.maxPortNumber);
            }
            try {
                ServerSocket serverSocket = new ServerSocket(port);
                return serverSocket;
            }
            catch (IOException ioe) {
                this.getLog().debug((CharSequence)("Tried binding to port " + port + " without success. Trying next port."), (Throwable)ioe);
                ++port;
                continue;
            }
            break;
        }
    }

    private int getNextPortNumber() {
        assert (this.minPortNumber != null);
        List<Integer> reservedPorts = this.getReservedPorts();
        int nextPort = -1;
        nextPort = reservedPorts.isEmpty() ? this.minPortNumber.intValue() : this.findAvailablePortNumber(this.minPortNumber, reservedPorts);
        reservedPorts.add(nextPort);
        this.getLog().debug((CharSequence)("Next port: " + nextPort));
        return nextPort;
    }

    private List<Integer> getReservedPorts() {
        ArrayList reservedPorts = (ArrayList)this.getPluginContext().get(BUILD_HELPER_RESERVED_PORTS);
        if (reservedPorts == null) {
            reservedPorts = new ArrayList();
            this.getPluginContext().put(BUILD_HELPER_RESERVED_PORTS, reservedPorts);
        }
        return reservedPorts;
    }

    private int findAvailablePortNumber(Integer portNumberStartingPoint, List<Integer> reservedPorts) {
        assert (portNumberStartingPoint != null);
        int candidate = portNumberStartingPoint;
        while (reservedPorts.contains(candidate)) {
            ++candidate;
        }
        return candidate;
    }
}

