/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.appassembler.daemon;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerationRequest;
import org.codehaus.mojo.appassembler.daemon.DaemonGenerator;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorException;
import org.codehaus.mojo.appassembler.daemon.DaemonGeneratorService;
import org.codehaus.mojo.appassembler.daemon.merge.DaemonMerger;
import org.codehaus.mojo.appassembler.model.Daemon;
import org.codehaus.mojo.appassembler.model.io.stax.AppassemblerModelStaxReader;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class DefaultDaemonGeneratorService
extends AbstractLogEnabled
implements DaemonGeneratorService {
    private Map generators;
    private DaemonMerger daemonMerger;

    public void generateDaemon(String platform, File stubDescriptor, File outputDirectory, MavenProject mavenProject, ArtifactRepository localRepository) throws DaemonGeneratorException {
        this.generateDaemon(platform, stubDescriptor, null, outputDirectory, mavenProject, localRepository);
    }

    public void generateDaemon(String platform, File stubDescriptor, Daemon stubDaemon, File outputDirectory, MavenProject mavenProject, ArtifactRepository localRepository) throws DaemonGeneratorException {
        DaemonGenerationRequest request = new DaemonGenerationRequest();
        request.setPlatform(platform);
        request.setStubDescriptor(stubDescriptor);
        request.setStubDaemon(stubDaemon);
        request.setOutputDirectory(outputDirectory);
        request.setMavenProject(mavenProject);
        request.setLocalRepository(localRepository);
        this.generateDaemon(request);
    }

    public void generateDaemon(DaemonGenerationRequest request) throws DaemonGeneratorException {
        String platform = request.getPlatform();
        if (platform == null || StringUtils.isEmpty((String)platform)) {
            throw new DaemonGeneratorException("Missing required property in request: platform.");
        }
        DaemonGenerator generator = (DaemonGenerator)this.generators.get(platform);
        if (generator == null) {
            throw new DaemonGeneratorException("Could not find a generator for platform '" + platform + "'.");
        }
        Daemon fileDaemon = null;
        File stubDescriptor = request.getStubDescriptor();
        if (stubDescriptor != null) {
            this.getLogger().debug("Loading daemon descriptor: " + stubDescriptor.getAbsolutePath());
            fileDaemon = this.loadModel(stubDescriptor);
        }
        Daemon mergedDaemon = this.mergeDaemons(request.getStubDaemon(), fileDaemon);
        this.validateDaemon(mergedDaemon, stubDescriptor);
        request.setDaemon(mergedDaemon);
        generator.generate(request);
    }

    public Daemon mergeDaemons(Daemon dominant, Daemon recessive) throws DaemonGeneratorException {
        return this.daemonMerger.mergeDaemons(dominant, recessive);
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Daemon loadModel(File stubDescriptor) throws DaemonGeneratorException {
        Daemon daemon;
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(stubDescriptor);
            AppassemblerModelStaxReader reader = new AppassemblerModelStaxReader();
            Daemon stubDaemon = reader.read((Reader)fileReader);
            this.validateDaemon(stubDaemon, stubDescriptor);
            daemon = stubDaemon;
        }
        catch (IOException e) {
            try {
                throw new DaemonGeneratorException("Error while loading daemon descriptor from '" + stubDescriptor.getAbsolutePath() + "'.", e);
                catch (XMLStreamException e2) {
                    throw new DaemonGeneratorException("Error while loading daemon descriptor from '" + stubDescriptor.getAbsolutePath() + "'.", e2);
                }
            }
            catch (Throwable throwable) {
                IOUtil.close(fileReader);
                throw throwable;
            }
        }
        IOUtil.close((Reader)fileReader);
        return daemon;
    }

    public void validateDaemon(Daemon daemon, File descriptor) throws DaemonGeneratorException {
        if (daemon == null) {
            throw new DaemonGeneratorException("Illegal argument: daemon must be passed.");
        }
        String mainClass = daemon.getMainClass();
        String missingRequiredField = descriptor != null ? "Missing required field from '" + descriptor.getAbsolutePath() + "': " : "Missing required field in daemon descriptor: ";
        if (StringUtils.isEmpty((String)mainClass)) {
            throw new DaemonGeneratorException(missingRequiredField + "main class.");
        }
        if (StringUtils.isEmpty((String)daemon.getId())) {
            String id = mainClass;
            int i = id.lastIndexOf(46);
            if (i > 0) {
                id = mainClass.substring(i + 1);
            }
            id = StringUtils.addAndDeHump((String)id);
            daemon.setId(id);
        }
    }
}

