/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.animal_sniffer.logging;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.codehaus.mojo.animal_sniffer.logging.Logger;

public final class PrintWriterLogger
implements Logger {
    private final PrintStream destination;

    public PrintWriterLogger(PrintStream destination) {
        this.destination = destination;
    }

    @Override
    public void info(String message) {
        this.output("[INFO]", message, null);
    }

    @Override
    public void info(String message, Throwable t) {
        this.output("[INFO]", message, t);
    }

    @Override
    public void debug(String message) {
    }

    @Override
    public void debug(String message, Throwable t) {
    }

    @Override
    public void warn(String message) {
        this.output("[WARN]", message, null);
    }

    @Override
    public void warn(String message, Throwable t) {
        this.output("[WARN]", message, t);
    }

    @Override
    public void error(String message) {
        this.output("[ERROR]", message, null);
    }

    @Override
    public void error(String message, Throwable t) {
        this.output("[ERROR]", message, t);
    }

    private void output(String prefix, String message, Throwable t) {
        StringWriter w = new StringWriter();
        PrintWriter pw = new PrintWriter(w);
        pw.print(prefix);
        pw.print(' ');
        pw.println(message);
        if (t != null) {
            t.printStackTrace(pw);
        }
        pw.close();
        this.destination.print(w.toString());
        this.destination.flush();
    }
}

