/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.db;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.codehaus.plexus.personality.plexus.lifecycle.phase.InitializationException;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;

public class SQLReservedWords
extends AbstractLogEnabled
implements Initializable {
    private Map keywords;

    public boolean isKeyword(String word) {
        if (StringUtils.isEmpty((String)word)) {
            return false;
        }
        String key = word.trim().toUpperCase();
        return this.keywords.containsKey(key);
    }

    public List getKeywordSourceList(String word) {
        if (StringUtils.isEmpty((String)word)) {
            return null;
        }
        String key = word.trim().toUpperCase();
        return (List)this.keywords.get(key);
    }

    public String getKeywordSourceString(String word) {
        if (StringUtils.isEmpty((String)word)) {
            return null;
        }
        String key = word.trim().toUpperCase();
        List sources = (List)this.keywords.get(key);
        if (sources == null) {
            return null;
        }
        StringBuffer ret = new StringBuffer();
        Iterator it = sources.iterator();
        while (it.hasNext()) {
            KeywordSource source = (KeywordSource)it.next();
            if (ret.length() > 0) {
                ret.append(", ");
            }
            ret.append(source.getName());
        }
        return ret.toString();
    }

    public void initialize() throws InitializationException {
        this.loadKeywords();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeywords() {
        this.keywords = new HashMap();
        Properties props = new Properties();
        URL definitionsURL = ((Object)((Object)this)).getClass().getResource("keywords.properties");
        if (definitionsURL == null) {
            this.getLogger().error("Unable to load definition file: keywords.properties");
            return;
        }
        InputStream is = null;
        try {
            is = definitionsURL.openStream();
            props.load(is);
            String[] sources = StringUtils.split((String)props.getProperty("keyword.sources"), (String)",");
            for (int i = 0; i < sources.length; ++i) {
                String source = sources[i];
                String sourceName = props.getProperty("keyword.source." + source + ".name");
                String sourceSeverity = props.getProperty("keyword.source." + source + ".severity");
                KeywordSource keywordSource = new KeywordSource(sourceName, sourceSeverity);
                this.loadKeywordSource(source + ".txt", keywordSource);
            }
        }
        catch (IOException e) {
            this.getLogger().error("Unable to load definitions file: keywords.properties", (Throwable)e);
            return;
        }
        finally {
            IOUtil.close((InputStream)is);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadKeywordSource(String resource, KeywordSource source) {
        URL keywordsURL = ((Object)((Object)this)).getClass().getResource(resource);
        if (keywordsURL == null) {
            this.getLogger().error("Unable to find keywords for \"" + resource + "\"");
            return;
        }
        InputStream is = null;
        InputStreamReader isr = null;
        BufferedReader reader = null;
        try {
            is = keywordsURL.openStream();
            isr = new InputStreamReader(is);
            reader = new BufferedReader(isr);
            String line = reader.readLine();
            while (line != null) {
                if ((line = line.trim()).length() > 0) {
                    this.addKeyword(line, source);
                }
                line = reader.readLine();
            }
        }
        catch (IOException e) {
            try {
                this.getLogger().warn("Unable to load keywords from " + keywordsURL.toExternalForm() + ": " + e.getMessage(), (Throwable)e);
            }
            catch (Throwable throwable) {
                IOUtil.close(reader);
                IOUtil.close(isr);
                IOUtil.close((InputStream)is);
                throw throwable;
            }
            IOUtil.close((Reader)reader);
            IOUtil.close((Reader)isr);
            IOUtil.close((InputStream)is);
        }
        IOUtil.close((Reader)reader);
        IOUtil.close((Reader)isr);
        IOUtil.close((InputStream)is);
    }

    private void addKeyword(String keyword, KeywordSource source) {
        String key = keyword.trim().toUpperCase();
        ArrayList<KeywordSource> sources = (ArrayList<KeywordSource>)this.keywords.get(key);
        if (sources == null) {
            sources = new ArrayList<KeywordSource>();
        }
        sources.add(source);
        this.keywords.put(key, sources);
    }

    public class KeywordSource {
        private String name;
        private String severity;

        public KeywordSource(String name, String severity) {
            this.name = name;
            this.severity = severity;
        }

        public String getName() {
            return this.name;
        }

        public String getSeverity() {
            return this.severity;
        }

        public String toString() {
            return this.name;
        }
    }
}

