/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jstestrunner.junit;

import java.io.File;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.net.URL;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.codehaus.jstestrunner.JSTestExecutionServer;
import org.codehaus.jstestrunner.JSTestSuiteRunnerService;
import org.codehaus.jstestrunner.jetty.JSTestResultHandler;
import org.codehaus.jstestrunner.jetty.JSTestResultServer;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTestSuiteRunner
extends ParentRunner<URL> {
    private final JSTestSuiteRunnerService jSTestSuiteRunnerService;
    private final List<URL> urls;

    public JSTestSuiteRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        TestRunnerFilePath testRunnerFilePathAnnotation;
        int port;
        String host;
        Logger logger = Logger.getLogger("org.eclipse.jetty");
        logger.setLevel(Level.WARNING);
        Host hostAnnotation = testClass.getAnnotation(Host.class);
        if (hostAnnotation == null) {
            host = "localhost";
            port = 9080;
        } else {
            String[] hostParts = hostAnnotation.value().split(":");
            if (hostParts.length != 2) {
                throw new InitializationError("Host must be of the form host:port");
            }
            host = hostParts[0];
            port = Integer.valueOf(hostParts[1]);
        }
        ContextPath contextPathAnnotation = testClass.getAnnotation(ContextPath.class);
        String contextPath = contextPathAnnotation == null ? "/" : contextPathAnnotation.value();
        ResourceBase resourceBaseAnnotation = testClass.getAnnotation(ResourceBase.class);
        String[] resourceBases = resourceBaseAnnotation == null ? new String[]{"target" + File.separator + "classes", "target" + File.separator + "test-classes"} : resourceBaseAnnotation.value();
        Include includeAnnotation = testClass.getAnnotation(Include.class);
        String[] includes = includeAnnotation == null ? new String[]{"**/*Test.html", "**/*Test.htm"} : includeAnnotation.value();
        Exclude excludeAnnotation = testClass.getAnnotation(Exclude.class);
        String[] excludes = excludeAnnotation == null ? new String[]{} : excludeAnnotation.value();
        String commandPattern = System.getProperty("org.codehaus.jstestrunner.commandPattern");
        if (commandPattern == null) {
            commandPattern = "phantomjs '%1$s' %2$s";
        }
        String testRunnerFilePath = (testRunnerFilePathAnnotation = testClass.getAnnotation(TestRunnerFilePath.class)) == null ? "target" + File.separator + "js-testrunner" : testRunnerFilePathAnnotation.value();
        this.urls = JSTestSuiteRunnerService.scanTestFiles(host, port, resourceBases, includes, excludes);
        this.jSTestSuiteRunnerService = new JSTestSuiteRunnerService();
        JSTestExecutionServer jSTestExecutionServer = new JSTestExecutionServer();
        jSTestExecutionServer.setCommandPattern(commandPattern);
        jSTestExecutionServer.setTestRunnerFilePath(testRunnerFilePath);
        jSTestExecutionServer.setUrls(this.urls);
        JSTestResultServer jSTestResultServer = new JSTestResultServer();
        jSTestResultServer.setContextPath(contextPath);
        jSTestResultServer.setPort(port);
        jSTestResultServer.setResourceBases(resourceBases);
        this.jSTestSuiteRunnerService.setjSTestExecutionServer(jSTestExecutionServer);
        this.jSTestSuiteRunnerService.setjSTestResultServer(jSTestResultServer);
    }

    private Statement afterTests(final Statement statement) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                finally {
                    JSTestSuiteRunner.this.jSTestSuiteRunnerService.afterTests();
                }
            }
        };
    }

    private Statement beforeTests(final Statement statement) {
        return new Statement(){

            public void evaluate() throws Throwable {
                JSTestSuiteRunner.this.jSTestSuiteRunnerService.beforeTests();
                statement.evaluate();
            }
        };
    }

    protected Statement classBlock(RunNotifier notifier) {
        Statement statement = super.classBlock(notifier);
        statement = this.beforeTests(statement);
        statement = this.afterTests(statement);
        return statement;
    }

    protected Description describeChild(URL url) {
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)JSTestSuiteRunnerService.getFormattedPath(url));
    }

    protected List<URL> getChildren() {
        return this.urls;
    }

    public JSTestSuiteRunnerService getjSTestSuiteRunnerService() {
        return this.jSTestSuiteRunnerService;
    }

    protected void runChild(URL url, RunNotifier notifier) {
        Description description = this.describeChild(url);
        notifier.fireTestStarted(description);
        JSTestResultHandler.JSTestResult jsTestResult = this.jSTestSuiteRunnerService.runTest(url);
        if (jsTestResult != null) {
            if (jsTestResult.failures > 0) {
                JSTestFailure failure = new JSTestFailure(description, url, "Failures: " + jsTestResult.failures + ", passes: " + jsTestResult.passes + ":\n" + jsTestResult.message);
                notifier.fireTestFailure((Failure)failure);
            } else {
                notifier.fireTestFinished(description);
            }
        } else {
            JSTestFailure failure = new JSTestFailure(description, url, "Timed out waiting for test");
            notifier.fireTestFailure((Failure)failure);
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface TestRunnerFilePath {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface ResourceBase {
        public String[] value();
    }

    private static class JSTestFailure
    extends Failure {
        private final URL url;

        public JSTestFailure(Description description, URL url, String message) {
            super(description, (Throwable)new RuntimeException(message));
            this.url = url;
        }

        public String getTestHeader() {
            return JSTestSuiteRunnerService.getFormattedPath(this.url);
        }

        public String getTrace() {
            return this.getMessage();
        }

        public String toString() {
            return this.getTestHeader();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface Include {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface Host {
        public String value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface Exclude {
        public String[] value();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface ContextPath {
        public String value();
    }
}

