/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jstestrunner.jetty;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonParser;
import org.codehaus.jackson.JsonToken;
import org.codehaus.jstestrunner.TestResultProducer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.handler.AbstractHandler;

public class JSTestResultHandler
extends AbstractHandler {
    private final Map<String, JSTestResult> jsTestResults = new HashMap<String, JSTestResult>();
    private final Lock jsTestResultsLock = new ReentrantLock();
    private final Condition newJsTestResults = this.jsTestResultsLock.newCondition();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JSTestResult getJsTestResult(URL url, TestResultProducer testResultProducer, long time, TimeUnit unit) {
        JSTestResult jsTestResult = null;
        this.jsTestResultsLock.lock();
        try {
            do {
                boolean newJsTestResult;
                if ((jsTestResult = this.jsTestResults.get(url.toString())) != null) continue;
                try {
                    newJsTestResult = testResultProducer.isAvailable() ? this.newJsTestResults.await(time, unit) : false;
                }
                catch (InterruptedException e) {
                    newJsTestResult = false;
                }
                if (newJsTestResult) continue;
                break;
            } while (jsTestResult == null);
        }
        finally {
            this.jsTestResultsLock.unlock();
        }
        return jsTestResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        if (target.equals("/testResults") && request.getMethod().equals("POST") && request.getContentType().contains("application/json")) {
            JSTestResult jsTestResult = null;
            JsonFactory f = new JsonFactory();
            JsonParser jp = f.createJsonParser((Reader)request.getReader());
            String testUrl = null;
            Integer failures = null;
            Integer passes = null;
            String message = null;
            try {
                jp.nextToken();
                while (jp.nextToken() != JsonToken.END_OBJECT) {
                    String fieldname = jp.getCurrentName();
                    jp.nextToken();
                    if (fieldname.equals("testUrl")) {
                        testUrl = jp.getText();
                        continue;
                    }
                    if (fieldname.equals("failures")) {
                        failures = jp.getIntValue();
                        continue;
                    }
                    if (fieldname.equals("passes")) {
                        passes = jp.getIntValue();
                        continue;
                    }
                    if (!fieldname.equals("message")) continue;
                    message = jp.getText();
                }
            }
            finally {
                jp.close();
            }
            if (testUrl != null && failures != null && passes != null && message != null) {
                jsTestResult = new JSTestResult();
                jsTestResult.failures = failures;
                jsTestResult.message = message;
                jsTestResult.passes = passes;
                response.setStatus(204);
            } else {
                response.setStatus(400);
            }
            response.setContentType("application/json");
            baseRequest.setHandled(true);
            this.jsTestResultsLock.lock();
            try {
                if (jsTestResult != null) {
                    this.jsTestResults.put(testUrl, jsTestResult);
                }
                this.newJsTestResults.signalAll();
            }
            finally {
                this.jsTestResultsLock.unlock();
            }
        }
    }

    public static class JSTestResult {
        public int failures;
        public int passes;
        public String message;
    }
}

