/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jstestrunner;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import org.codehaus.jstestrunner.JSTestExecutionServer;
import org.codehaus.jstestrunner.jetty.JSTestResultHandler;
import org.codehaus.jstestrunner.jetty.JSTestResultServer;
import org.codehaus.plexus.util.DirectoryScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSTestSuiteRunnerService {
    private JSTestResultServer jSTestResultServer;
    private JSTestExecutionServer jSTestExecutionServer;

    public static String getFormattedPath(URL url) {
        String urlPath = url.getPath();
        if (urlPath.length() > 0 && urlPath.charAt(0) == '/') {
            urlPath = urlPath.substring(1);
        }
        return urlPath;
    }

    private static Collection<URL> relativeFilepathsAsUrls(String host, int port, String[] includedFiles) {
        ArrayList<URL> relativeUrls = new ArrayList<URL>(includedFiles.length);
        for (String includedFile : includedFiles) {
            try {
                relativeUrls.add(new URL("http", host, port, "/" + includedFile.replace(File.separatorChar, '/')));
            }
            catch (MalformedURLException e) {
                System.out.println(e);
            }
        }
        return relativeUrls;
    }

    public static List<URL> scanTestFiles(String host, int port, String[] resourceBases, String[] includes, String[] excludes) {
        ArrayList<URL> includedUrls = new ArrayList<URL>();
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setIncludes(includes);
        scanner.setExcludes(excludes);
        for (String resourceBase : resourceBases) {
            scanner.setBasedir(resourceBase);
            scanner.scan();
            includedUrls.addAll(JSTestSuiteRunnerService.relativeFilepathsAsUrls(host, port, scanner.getIncludedFiles()));
        }
        return includedUrls;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void afterTests() throws Exception {
        try {
            this.jSTestExecutionServer.stop();
        }
        finally {
            this.jSTestResultServer.stop();
        }
    }

    public void beforeTests() throws Exception {
        this.jSTestResultServer.start();
        this.jSTestExecutionServer.start();
    }

    public JSTestExecutionServer getjSTestExecutionServer() {
        return this.jSTestExecutionServer;
    }

    public JSTestResultServer getjSTestResultServer() {
        return this.jSTestResultServer;
    }

    public JSTestResultHandler.JSTestResult runTest(URL url) {
        return this.jSTestResultServer.getJsTestResult(url, this.jSTestExecutionServer);
    }

    @Inject
    public void setjSTestExecutionServer(JSTestExecutionServer jSTestExecutionServer) {
        this.jSTestExecutionServer = jSTestExecutionServer;
    }

    @Inject
    public void setjSTestResultServer(JSTestResultServer jSTestResultServer) {
        this.jSTestResultServer = jSTestResultServer;
    }
}

