/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.jackson.map.ser;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import org.codehaus.jackson.map.JsonSerializer;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.introspect.Annotated;
import org.codehaus.jackson.map.introspect.AnnotatedField;
import org.codehaus.jackson.map.introspect.AnnotatedMethod;
import org.codehaus.jackson.map.introspect.BasicBeanDescription;
import org.codehaus.jackson.map.ser.BasicSerializerFactory;
import org.codehaus.jackson.map.ser.BeanPropertyWriter;
import org.codehaus.jackson.map.ser.BeanSerializer;
import org.codehaus.jackson.map.ser.JsonValueSerializer;
import org.codehaus.jackson.map.ser.PropertyBuilder;
import org.codehaus.jackson.map.util.ClassUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BeanSerializerFactory
extends BasicSerializerFactory {
    public static final BeanSerializerFactory instance = new BeanSerializerFactory();

    protected BeanSerializerFactory() {
    }

    @Override
    public <T> JsonSerializer<T> createSerializer(Class<T> type, SerializationConfig config) {
        JsonSerializer<Object> ser = super.findSerializerByLookup(type);
        if (ser == null && (ser = super.findSerializerByPrimaryType(type, config)) == null && (ser = this.findBeanSerializer(type, config)) == null) {
            ser = super.findSerializerByAddonType(type);
        }
        return ser;
    }

    public JsonSerializer<Object> findBeanSerializer(Class<?> type, SerializationConfig config) {
        if (!this.isPotentialBeanType(type)) {
            return null;
        }
        BasicBeanDescription beanDesc = (BasicBeanDescription)config.introspect(type);
        JsonSerializer<Object> ser = this.findSerializerFromAnnotation(config, beanDesc.getClassInfo());
        if (ser != null) {
            return ser;
        }
        AnnotatedMethod valueMethod = beanDesc.findJsonValueMethod();
        if (valueMethod != null) {
            ser = this.findSerializerFromAnnotation(config, valueMethod);
            return new JsonValueSerializer(valueMethod.getAnnotated(), ser);
        }
        return this.constructBeanSerializer(type, config, beanDesc);
    }

    protected boolean isPotentialBeanType(Class<?> type) {
        return ClassUtil.canBeABeanType(type) == null && !ClassUtil.isProxyType(type);
    }

    protected JsonSerializer<Object> constructBeanSerializer(Class<?> type, SerializationConfig config, BasicBeanDescription beanDesc) {
        Collection<BeanPropertyWriter> props = this.findBeanProperties(config, beanDesc);
        if (props == null || props.size() == 0) {
            return null;
        }
        return new BeanSerializer(type, props);
    }

    protected Collection<BeanPropertyWriter> findBeanProperties(SerializationConfig config, BasicBeanDescription beanDesc) {
        JsonSerializer<Object> annotatedSerializer;
        LinkedHashMap<String, AnnotatedMethod> methodsByProp = beanDesc.findGetters(config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_GETTERS), null);
        LinkedHashMap<String, AnnotatedField> fieldsByProp = beanDesc.findSerializableFields(config.isEnabled(SerializationConfig.Feature.AUTO_DETECT_FIELDS), methodsByProp.keySet());
        if (methodsByProp.isEmpty() && fieldsByProp.isEmpty()) {
            return null;
        }
        boolean fixAccess = config.isEnabled(SerializationConfig.Feature.CAN_OVERRIDE_ACCESS_MODIFIERS);
        PropertyBuilder pb = this.constructPropertyBuilder(config, beanDesc);
        ArrayList<BeanPropertyWriter> props = new ArrayList<BeanPropertyWriter>(methodsByProp.size());
        for (Map.Entry<String, AnnotatedField> entry : fieldsByProp.entrySet()) {
            AnnotatedField af = entry.getValue();
            if (fixAccess) {
                af.fixAccess();
            }
            annotatedSerializer = this.findSerializerFromAnnotation(config, af);
            props.add(pb.buildProperty(entry.getKey(), annotatedSerializer, af));
        }
        for (Map.Entry<String, Annotated> entry : methodsByProp.entrySet()) {
            AnnotatedMethod am = (AnnotatedMethod)entry.getValue();
            if (fixAccess) {
                am.fixAccess();
            }
            annotatedSerializer = this.findSerializerFromAnnotation(config, am);
            props.add(pb.buildProperty(entry.getKey(), annotatedSerializer, am));
        }
        return props;
    }

    protected PropertyBuilder constructPropertyBuilder(SerializationConfig config, BasicBeanDescription beanDesc) {
        return new PropertyBuilder(config, beanDesc);
    }
}

