/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.classgen;

import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.TupleExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.control.CompilationUnit;
import org.codehaus.groovy.control.SourceUnit;

public class EnumCompletionVisitor
extends ClassCodeVisitorSupport {
    private final SourceUnit sourceUnit;

    public EnumCompletionVisitor(CompilationUnit cu, SourceUnit su) {
        this.sourceUnit = su;
    }

    public void visitClass(ClassNode node) {
        if (!node.isEnum()) {
            return;
        }
        this.completeEnum(node);
    }

    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    private void completeEnum(ClassNode enumClass) {
        this.addConstructor(enumClass);
    }

    private void addConstructor(ClassNode enumClass) {
        ArrayList<ConstructorNode> ctors = new ArrayList<ConstructorNode>(enumClass.getDeclaredConstructors());
        if (ctors.size() == 0) {
            ConstructorNode init = new ConstructorNode(1, new Parameter[0], ClassNode.EMPTY_ARRAY, new BlockStatement());
            enumClass.addConstructor(init);
            ctors.add(init);
        }
        for (ConstructorNode ctor : ctors) {
            this.transformConstructor(ctor);
        }
    }

    private void transformConstructor(ConstructorNode ctor) {
        boolean chainedThisConstructorCall = false;
        ConstructorCallExpression cce = null;
        if (ctor.firstStatementIsSpecialConstructorCall()) {
            Statement code = ctor.getFirstStatement();
            cce = (ConstructorCallExpression)((ExpressionStatement)code).getExpression();
            if (cce.isSuperCall()) {
                return;
            }
            chainedThisConstructorCall = true;
        }
        Parameter[] oldP = ctor.getParameters();
        Parameter[] newP = new Parameter[oldP.length + 2];
        String stringParameterName = this.getUniqueVariableName("__str", ctor.getCode());
        newP[0] = new Parameter(ClassHelper.STRING_TYPE, stringParameterName);
        String intParameterName = this.getUniqueVariableName("__int", ctor.getCode());
        newP[1] = new Parameter(ClassHelper.int_TYPE, intParameterName);
        System.arraycopy(oldP, 0, newP, 2, oldP.length);
        ctor.setParameters(newP);
        if (chainedThisConstructorCall) {
            TupleExpression args = (TupleExpression)cce.getArguments();
            List<Expression> argsExprs = args.getExpressions();
            argsExprs.add(0, new VariableExpression(stringParameterName));
            argsExprs.add(1, new VariableExpression(intParameterName));
        } else {
            cce = new ConstructorCallExpression(ClassNode.SUPER, new ArgumentListExpression(new VariableExpression(stringParameterName), new VariableExpression(intParameterName)));
            BlockStatement code = new BlockStatement();
            code.addStatement(new ExpressionStatement(cce));
            Statement oldCode = ctor.getCode();
            if (oldCode != null) {
                code.addStatement(oldCode);
            }
            ctor.setCode(code);
        }
    }

    private String getUniqueVariableName(final String name, Statement code) {
        if (code == null) {
            return name;
        }
        final Object[] found = new Object[1];
        CodeVisitorSupport cv = new CodeVisitorSupport(){

            public void visitVariableExpression(VariableExpression expression) {
                if (expression.getName().equals(name)) {
                    found[0] = Boolean.TRUE;
                }
            }
        };
        code.visit(cv);
        if (found[0] != null) {
            return this.getUniqueVariableName("_" + name, code);
        }
        return name;
    }
}

