/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.transform.powerassert;

import java.util.List;
import org.codehaus.groovy.ast.ClassHelper;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.ConstructorNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.ModuleNode;
import org.codehaus.groovy.ast.expr.ArgumentListExpression;
import org.codehaus.groovy.ast.expr.ClassExpression;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstantExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.DeclarationExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.ast.stmt.AssertStatement;
import org.codehaus.groovy.ast.stmt.BlockStatement;
import org.codehaus.groovy.ast.stmt.ExpressionStatement;
import org.codehaus.groovy.ast.stmt.Statement;
import org.codehaus.groovy.ast.stmt.TryCatchStatement;
import org.codehaus.groovy.control.Janitor;
import org.codehaus.groovy.control.SourceUnit;
import org.codehaus.groovy.syntax.Token;
import org.codehaus.groovy.transform.powerassert.AssertionVerifier;
import org.codehaus.groovy.transform.powerassert.SourceText;
import org.codehaus.groovy.transform.powerassert.SourceTextNotAvailableException;
import org.codehaus.groovy.transform.powerassert.StatementReplacingVisitorSupport;
import org.codehaus.groovy.transform.powerassert.TruthExpressionRewriter;
import org.codehaus.groovy.transform.powerassert.ValueRecorder;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AssertionRewriter
extends StatementReplacingVisitorSupport {
    static final VariableExpression recorderVariable = new VariableExpression("$valueRecorder");
    private static final ClassNode verifierClass = ClassHelper.makeWithoutCaching(AssertionVerifier.class);
    private static final ClassNode recorderClass = ClassHelper.makeWithoutCaching(ValueRecorder.class);
    private final SourceUnit sourceUnit;
    private final Janitor janitor = new Janitor();
    private boolean assertFound;

    private AssertionRewriter(SourceUnit sourceUnit) {
        this.sourceUnit = sourceUnit;
    }

    public static void rewrite(SourceUnit sourceUnit) {
        new AssertionRewriter(sourceUnit).visitModule();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitModule() {
        ModuleNode module = this.sourceUnit.getAST();
        try {
            List<ClassNode> classes = module.getClasses();
            for (ClassNode clazz : classes) {
                this.visitClass(clazz);
            }
        }
        finally {
            this.janitor.cleanup();
        }
    }

    @Override
    public void visitClass(ClassNode node) {
        this.visitAnnotations(node);
        node.visitContents(this);
        this.visitInstanceInitializer(node.getObjectInitializerStatements());
    }

    private void visitInstanceInitializer(List<Statement> stats) {
        boolean old = this.assertFound;
        this.assertFound = false;
        for (Statement stat : stats) {
            stat.visit(this);
        }
        if (this.assertFound) {
            AssertionRewriter.defineRecorderVariable(stats);
        }
        this.assertFound = old;
    }

    @Override
    public void visitConstructor(ConstructorNode constructor) {
        boolean old = this.assertFound;
        this.assertFound = false;
        super.visitConstructor(constructor);
        if (this.assertFound) {
            AssertionRewriter.defineRecorderVariable((BlockStatement)constructor.getCode());
        }
        this.assertFound = old;
    }

    @Override
    public void visitMethod(MethodNode method) {
        boolean old = this.assertFound;
        this.assertFound = false;
        super.visitMethod(method);
        if (this.assertFound) {
            AssertionRewriter.defineRecorderVariable((BlockStatement)method.getCode());
        }
        this.assertFound = old;
    }

    @Override
    public void visitClosureExpression(ClosureExpression expr) {
        boolean old = this.assertFound;
        this.assertFound = false;
        super.visitClosureExpression(expr);
        if (this.assertFound) {
            AssertionRewriter.defineRecorderVariable((BlockStatement)expr.getCode());
        }
        this.assertFound = old;
    }

    @Override
    public void visitAssertStatement(AssertStatement stat) {
        super.visitAssertStatement(stat);
        this.rewriteAssertion(stat);
    }

    private void rewriteAssertion(AssertStatement stat) {
        SourceText text;
        if (stat.getMessageExpression() != ConstantExpression.NULL) {
            return;
        }
        try {
            text = new SourceText(stat, this.sourceUnit, this.janitor);
        }
        catch (SourceTextNotAvailableException e) {
            return;
        }
        this.assertFound = true;
        ExpressionStatement verifyCall = new ExpressionStatement(new MethodCallExpression((Expression)new ClassExpression(verifierClass), "verify", (Expression)new ArgumentListExpression(TruthExpressionRewriter.rewrite(stat.getBooleanExpression(), text, this), new ConstantExpression(text.getNormalizedText()), recorderVariable)));
        BlockStatement tryBlock = new BlockStatement();
        tryBlock.addStatement(verifyCall);
        tryBlock.setSourcePosition(stat);
        TryCatchStatement tryCatchStat = new TryCatchStatement(tryBlock, new ExpressionStatement(new MethodCallExpression((Expression)recorderVariable, "clear", (Expression)ArgumentListExpression.EMPTY_ARGUMENTS)));
        this.replaceVisitedStatementWith(tryCatchStat);
    }

    private static void defineRecorderVariable(BlockStatement block) {
        AssertionRewriter.defineRecorderVariable(block.getStatements());
    }

    private static void defineRecorderVariable(List<Statement> stats) {
        int insertPos = AssertionRewriter.startsWithConstructorCall(stats) ? 1 : 0;
        stats.add(insertPos, new ExpressionStatement(new DeclarationExpression(recorderVariable, Token.newSymbol(100, -1, -1), (Expression)new ConstructorCallExpression(recorderClass, ArgumentListExpression.EMPTY_ARGUMENTS))));
    }

    private static boolean startsWithConstructorCall(List<Statement> stats) {
        if (stats.size() == 0) {
            return false;
        }
        Statement stat = stats.get(0);
        return stat instanceof ExpressionStatement && ((ExpressionStatement)stat).getExpression() instanceof ConstructorCallExpression;
    }

    @Override
    protected SourceUnit getSourceUnit() {
        throw new UnsupportedOperationException("getSourceUnit");
    }
}

