/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.HashMap;
import java.util.StringTokenizer;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.mapping.BindingType;
import org.castor.mapping.MappingUnmarshaller;
import org.castor.xml.BackwardCompatibilityContext;
import org.castor.xml.InternalContext;
import org.castor.xml.UnmarshalListenerAdapter;
import org.exolab.castor.mapping.Mapping;
import org.exolab.castor.mapping.MappingException;
import org.exolab.castor.mapping.MappingLoader;
import org.exolab.castor.types.AnyNode;
import org.exolab.castor.util.ObjectFactory;
import org.exolab.castor.xml.BaseSax2EventFromStaxProducer;
import org.exolab.castor.xml.EventProducer;
import org.exolab.castor.xml.IDResolver;
import org.exolab.castor.xml.MarshalException;
import org.exolab.castor.xml.SAX2EventAndErrorProducer;
import org.exolab.castor.xml.SAX2EventProducer;
import org.exolab.castor.xml.UnmarshalHandler;
import org.exolab.castor.xml.UnmarshalListener;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.XMLClassDescriptorResolver;
import org.exolab.castor.xml.XMLContext;
import org.exolab.castor.xml.location.FileLocation;
import org.exolab.castor.xml.util.AnyNode2SAX2;
import org.exolab.castor.xml.util.DOMEventProducer;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class Unmarshaller {
    private static final Log LOG = LogFactory.getLog(Unmarshaller.class);
    private Class _class = null;
    private boolean _clearCollections = false;
    private IDResolver _idResolver = null;
    private boolean _ignoreExtraAtts = true;
    private boolean _ignoreExtraElements = false;
    private Object _instanceObj = null;
    EntityResolver entityResolver = null;
    private ClassLoader _loader = null;
    private boolean _reuseObjects = false;
    private org.castor.xml.UnmarshalListener _unmarshalListener = null;
    private boolean _validate = false;
    private boolean _wsPreserve = false;
    private HashMap _namespaceToPackage = null;
    private ObjectFactory _objectFactory;
    private InternalContext _internalContext;

    public Unmarshaller() {
        this((Class)null);
    }

    public Unmarshaller(Class clazz) {
        this((InternalContext)new BackwardCompatibilityContext(), clazz);
    }

    public Unmarshaller(InternalContext internalContext) {
        this(internalContext, null, null);
    }

    public Unmarshaller(InternalContext internalContext, Class c) {
        this(internalContext, c, null);
    }

    public Unmarshaller(InternalContext internalContext, Class c, ClassLoader loader) {
        if (internalContext == null) {
            String message = "InternalContext must not be null";
            LOG.warn((Object)message);
            throw new IllegalArgumentException(message);
        }
        this.setInternalContext(internalContext);
        this.setClass(c);
        this._loader = loader;
        if (loader == null && c != null) {
            this._loader = c.getClassLoader();
        }
        this._internalContext.setClassLoader(this._loader);
    }

    public Unmarshaller(Mapping mapping) throws MappingException {
        this((InternalContext)new BackwardCompatibilityContext(), mapping);
    }

    public Unmarshaller(InternalContext internalContext, Mapping mapping) throws MappingException {
        this(internalContext, null, null);
        if (mapping != null) {
            this.setMapping(mapping);
            this._loader = mapping.getClassLoader();
        }
    }

    public Unmarshaller(Object root) {
        this((InternalContext)new BackwardCompatibilityContext(), root);
    }

    public Unmarshaller(InternalContext internalContext, Object root) {
        this(internalContext, null, null);
        if (root != null) {
            Class<?> clazz = root.getClass();
            this.setClass(clazz);
            this._loader = clazz.getClassLoader();
        }
        this._instanceObj = root;
    }

    public void addNamespaceToPackageMapping(String nsURI, String packageName) {
        if (this._namespaceToPackage == null) {
            this._namespaceToPackage = new HashMap();
        }
        String iNsUri = nsURI == null ? "" : nsURI;
        String iPackageName = packageName == null ? "" : packageName;
        this._namespaceToPackage.put(iNsUri, iPackageName);
    }

    public UnmarshalHandler createHandler() {
        UnmarshalHandler handler = new UnmarshalHandler(this._internalContext, this._class);
        handler.setClearCollections(this._clearCollections);
        handler.setReuseObjects(this._reuseObjects);
        handler.setValidation(this._validate);
        handler.setIgnoreExtraAttributes(this._ignoreExtraAtts);
        handler.setIgnoreExtraElements(this._ignoreExtraElements);
        handler.setInternalContext(this._internalContext);
        handler.setWhitespacePreserve(this._wsPreserve);
        if (this._objectFactory != null) {
            handler.setObjectFactory(this._objectFactory);
        }
        if (this._namespaceToPackage != null) {
            for (String nsURI : this._namespaceToPackage.keySet()) {
                String pkgName = (String)this._namespaceToPackage.get(nsURI);
                handler.addNamespaceToPackageMapping(nsURI, pkgName);
            }
        }
        if (this._instanceObj != null) {
            handler.setRootObject(this._instanceObj);
        }
        if (this._idResolver != null) {
            handler.setIDResolver(this._idResolver);
        }
        if (this._loader != null) {
            handler.setClassLoader(this._loader);
        }
        if (this._unmarshalListener != null) {
            handler.setUnmarshalListener(this._unmarshalListener);
        }
        return handler;
    }

    public boolean isValidating() {
        return this._validate;
    }

    public void setClass(Class clazz) {
        this._class = clazz;
    }

    public void setObject(Object root) {
        this._instanceObj = root;
    }

    public void setClassLoader(ClassLoader loader) {
        this._loader = loader;
    }

    public void setClearCollections(boolean clear) {
        this._clearCollections = clear;
    }

    public void setDebug(boolean debug) {
    }

    public void setEntityResolver(EntityResolver entityResolver) {
        this.entityResolver = entityResolver;
    }

    public void setIDResolver(IDResolver idResolver) {
        this._idResolver = idResolver;
    }

    public void setIgnoreExtraAttributes(boolean ignoreExtraAtts) {
        this._ignoreExtraAtts = ignoreExtraAtts;
    }

    public void setIgnoreExtraElements(boolean ignoreExtraElements) {
        this._ignoreExtraElements = ignoreExtraElements;
    }

    public void setLogWriter(PrintWriter printWriter) {
    }

    public void setMapping(Mapping mapping) throws MappingException {
        if (this._loader == null) {
            this._loader = mapping.getClassLoader();
        }
        MappingUnmarshaller mum = new MappingUnmarshaller();
        MappingLoader resolver = mum.getMappingLoader(mapping, BindingType.XML);
        this._internalContext.getXMLClassDescriptorResolver().setMappingLoader(resolver);
    }

    public void setReuseObjects(boolean reuse) {
        this._reuseObjects = reuse;
    }

    public void setUnmarshalListener(UnmarshalListener listener) {
        if (listener == null) {
            this._unmarshalListener = null;
        } else {
            UnmarshalListenerAdapter adapter = new UnmarshalListenerAdapter();
            adapter.setOldListener(listener);
            this._unmarshalListener = adapter;
        }
    }

    public void setUnmarshalListener(org.castor.xml.UnmarshalListener listener) {
        this._unmarshalListener = listener;
    }

    public void setValidation(boolean validate) {
        this._validate = validate;
    }

    public void setWhitespacePreserve(boolean preserve) {
        this._wsPreserve = preserve;
    }

    public Object unmarshal(Reader reader) throws MarshalException, ValidationException {
        return this.unmarshal(new InputSource(reader));
    }

    public Object unmarshal(EventProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler handler = this.createHandler();
        eventProducer.setDocumentHandler(handler);
        try {
            eventProducer.start();
        }
        catch (SAXException sx) {
            this.convertSAXExceptionToMarshalException(handler, sx);
        }
        return handler.getObject();
    }

    public Object unmarshal(SAX2EventProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler handler = this.createHandler();
        eventProducer.setContentHandler(handler);
        try {
            eventProducer.start();
        }
        catch (SAXException sx) {
            this.convertSAXExceptionToMarshalException(handler, sx);
        }
        return handler.getObject();
    }

    public Object unmarshal(AnyNode anyNode) throws MarshalException {
        UnmarshalHandler handler = this.createHandler();
        try {
            AnyNode2SAX2.fireEvents(anyNode, handler);
        }
        catch (SAXException sex) {
            this.convertSAXExceptionToMarshalException(handler, sex);
        }
        return handler.getObject();
    }

    public Object unmarshal(InputSource source) throws MarshalException, ValidationException {
        XMLReader reader = null;
        Parser parser = null;
        try {
            reader = this._internalContext.getXMLReader();
            if (this.entityResolver != null) {
                reader.setEntityResolver(this.entityResolver);
            }
        }
        catch (RuntimeException rx) {
            LOG.debug((Object)"Unable to create SAX XMLReader, attempting SAX Parser.");
        }
        if (reader == null) {
            parser = this._internalContext.getParser();
            if (parser == null) {
                throw new MarshalException("Unable to create SAX Parser.");
            }
            if (this.entityResolver != null) {
                parser.setEntityResolver(this.entityResolver);
            }
        }
        UnmarshalHandler handler = this.createHandler();
        try {
            if (reader != null) {
                reader.setContentHandler(handler);
                reader.setErrorHandler(handler);
                reader.parse(source);
            } else {
                parser.setDocumentHandler(handler);
                parser.setErrorHandler(handler);
                parser.parse(source);
            }
        }
        catch (IOException ioe) {
            throw new MarshalException(ioe);
        }
        catch (SAXException sx) {
            this.convertSAXExceptionToMarshalException(handler, sx);
        }
        return handler.getObject();
    }

    public Object unmarshal(Node node) throws MarshalException, ValidationException {
        return this.unmarshal(new DOMEventProducer(node));
    }

    public Object unmarshal(XMLEventReader eventReader) throws MarshalException, ValidationException {
        return this.unmarshal(BaseSax2EventFromStaxProducer.createSax2EventFromStax(eventReader));
    }

    public Object unmarshal(XMLStreamReader streamReader) throws MarshalException, ValidationException {
        return this.unmarshal(BaseSax2EventFromStaxProducer.createSax2EventFromStax(streamReader));
    }

    public Object unmarshal(SAX2EventAndErrorProducer eventProducer) throws MarshalException, ValidationException {
        UnmarshalHandler handler = this.createHandler();
        eventProducer.setContentHandler(handler);
        eventProducer.setErrorHandler(handler);
        try {
            eventProducer.start();
        }
        catch (SAXException sx) {
            this.convertSAXExceptionToMarshalException(handler, sx);
        }
        return handler.getObject();
    }

    private void convertSAXExceptionToMarshalException(UnmarshalHandler handler, SAXException sex) throws MarshalException {
        Exception except = sex.getException();
        if (except == null) {
            except = sex;
        }
        MarshalException marshalEx = new MarshalException(except);
        if (handler.getDocumentLocator() != null) {
            FileLocation location = new FileLocation();
            location.setFilename(handler.getDocumentLocator().getSystemId());
            location.setLineNumber(handler.getDocumentLocator().getLineNumber());
            location.setColumnNumber(handler.getDocumentLocator().getColumnNumber());
            marshalEx.setLocation(location);
        }
        throw marshalEx;
    }

    public static ContentHandler getContentHandler(UnmarshalHandler handler) throws SAXException {
        return handler;
    }

    public static Object unmarshal(Class c, Reader reader) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = Unmarshaller.createUnmarshaller(c);
        return unmarshaller.unmarshal(reader);
    }

    private static Unmarshaller createUnmarshaller(Class clazz) {
        XMLContext xmlContext = new XMLContext();
        Unmarshaller unmarshaller = xmlContext.createUnmarshaller();
        unmarshaller.setClass(clazz);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"*static* unmarshal method called, this will ignore any mapping files or changes made to an Unmarshaller instance.");
        }
        unmarshaller.setWhitespacePreserve(true);
        return unmarshaller;
    }

    public static Object unmarshal(Class c, InputSource source) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = Unmarshaller.createUnmarshaller(c);
        return unmarshaller.unmarshal(source);
    }

    public static Object unmarshal(Class c, Node node) throws MarshalException, ValidationException {
        Unmarshaller unmarshaller = Unmarshaller.createUnmarshaller(c);
        return unmarshaller.unmarshal(node);
    }

    public void setObjectFactory(ObjectFactory objectFactory) {
        this._objectFactory = objectFactory;
    }

    public String getProperty(String name) {
        Object propertyValue = this._internalContext.getProperty(name);
        if (propertyValue != null && !(propertyValue instanceof String)) {
            String message = "Requested property: " + name + " is not of type String, but: " + propertyValue.getClass() + " throwing IllegalStateException.";
            LOG.warn((Object)message);
            throw new IllegalStateException(message);
        }
        return (String)propertyValue;
    }

    public void setProperty(String name, String value) {
        this._internalContext.setProperty(name, value);
    }

    public void setInternalContext(InternalContext internalContext) {
        this._internalContext = internalContext;
        this.deriveProperties();
    }

    private void deriveProperties() {
        this._validate = this._internalContext.marshallingValidation();
        this._ignoreExtraElements = !this._internalContext.strictElements();
        String mappings = this._internalContext.getStringProperty("org.exolab.castor.xml.nspackages");
        if (mappings != null && mappings.length() > 0) {
            StringTokenizer tokens = new StringTokenizer(mappings, ",");
            while (tokens.hasMoreTokens()) {
                String token = tokens.nextToken();
                int sepIdx = token.indexOf(61);
                if (sepIdx < 0) continue;
                String ns = token.substring(0, sepIdx).trim();
                String javaPackage = token.substring(sepIdx + 1).trim();
                this.addNamespaceToPackageMapping(ns, javaPackage);
            }
        }
    }

    public InternalContext getInternalContext() {
        return this._internalContext;
    }

    public void setResolver(XMLClassDescriptorResolver xmlClassDescriptorResolver) {
        this._internalContext.setResolver(xmlClassDescriptorResolver);
    }
}

