/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.xml.schema;

import java.util.Enumeration;
import java.util.Vector;
import org.exolab.castor.xml.ValidationException;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.FinalList;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.IdentityConstraint;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Referable;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.TypeReference;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.validators.ValidationUtils;

public class ElementDecl
extends Particle
implements Referable {
    private static final long serialVersionUID = -7804351635137964219L;
    private static String NULL_ARGUMENT = "A null argument was passed to the constructor of " + ElementDecl.class.getName();
    private BlockList _block = null;
    private Vector _constraints = null;
    private String _default = null;
    private String _elementRefName = null;
    private ElementDecl _referencedElement = null;
    private FinalList _final = null;
    private String _fixed = null;
    private Form _form = null;
    private String _id = null;
    private boolean _isAbstract = false;
    private String _name = null;
    private boolean _nillable = false;
    private Structure _parent = null;
    private Schema _schema = null;
    private String _substitutionGroup = null;
    private XMLType _xmlType = null;

    public ElementDecl(Schema schema) {
        this(schema, null);
    }

    public ElementDecl(Schema schema, String name) {
        this.setName(name);
        if (schema == null) {
            String err = NULL_ARGUMENT + "; 'schema' must not be null.";
            throw new IllegalArgumentException(err);
        }
        this.setSchema(schema);
        this._constraints = new Vector(3);
    }

    public void addIdentityConstraint(IdentityConstraint constraint) {
        if (constraint == null) {
            return;
        }
        this._constraints.addElement(constraint);
    }

    public BlockList getBlock() {
        return this._block;
    }

    public String getDefaultValue() {
        ElementDecl elem;
        if (this.isReference() && (elem = this.getReference()) != null) {
            return elem.getDefaultValue();
        }
        return this._default;
    }

    public FinalList getFinal() {
        return this._final;
    }

    public String getFixedValue() {
        ElementDecl elem;
        if (this.isReference() && (elem = this.getReference()) != null) {
            return elem.getFixedValue();
        }
        return this._fixed;
    }

    public Form getForm() {
        return this._form;
    }

    public String getId() {
        return this._id;
    }

    public Enumeration getIdentityConstraints() {
        return this._constraints.elements();
    }

    public String getName() {
        return this.getName(false);
    }

    public String getName(boolean ignoreRef) {
        if (this.isReference() && !ignoreRef) {
            String localName = this._elementRefName;
            int idx = localName.indexOf(58);
            if (idx > 0) {
                localName = localName.substring(idx + 1);
            }
            return localName;
        }
        return this._name;
    }

    public Structure getParent() {
        return this._parent;
    }

    public XMLType getType() {
        XMLType tempType;
        Schema tempSchema;
        XMLType result = null;
        if (this.isReference()) {
            ElementDecl element = this.getReference();
            if (element != null) {
                return element.getType();
            }
            return null;
        }
        if (this._xmlType == null) {
            return null;
        }
        if (this._xmlType.getName() == null) {
            return this._xmlType.getType();
        }
        result = this._xmlType.getType();
        if (result != null && (tempSchema = result.getSchema().getMasterSchema()) != null && (tempType = tempSchema.getType(result.getName())) != null) {
            result = tempType;
        }
        return result;
    }

    public ElementDecl getReference() {
        if (this._referencedElement != null) {
            return this._referencedElement;
        }
        ElementDecl result = null;
        if (this._elementRefName != null) {
            result = this._schema.getElementDecl(this._elementRefName);
            if (result == null) {
                String err = "Unable to find element referenced :\" ";
                err = err + this.getName();
                err = err + "\"";
                throw new IllegalStateException(err);
            }
            this._referencedElement = result;
        }
        return result;
    }

    public String getReferenceName() {
        return this._elementRefName;
    }

    public String getReferenceId() {
        if (this._name != null) {
            return "element:" + this._name;
        }
        return null;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getSubstitutionGroup() {
        if (this.isReference()) {
            return this.getReference().getSubstitutionGroup();
        }
        return this._substitutionGroup;
    }

    public Enumeration getSubstitutionGroupMembers() {
        Vector<ElementDecl> result = new Vector<ElementDecl>();
        for (ElementDecl temp : this._schema.getElementDecls()) {
            String subName = temp.getSubstitutionGroup();
            if (subName == null) continue;
            if (subName.equals(this._name)) {
                result.add(temp);
                continue;
            }
            if (!subName.endsWith(this._name) || subName.indexOf(":") <= 0) continue;
            result.add(temp);
        }
        return result.elements();
    }

    public boolean isAbstract() {
        if (this.isReference()) {
            return this._referencedElement.isAbstract();
        }
        return this._isAbstract;
    }

    public boolean isNillable() {
        if (this.isReference()) {
            return this._referencedElement.isNillable();
        }
        return this._nillable;
    }

    public boolean isReference() {
        return this._elementRefName != null;
    }

    public void setAbstract(boolean isAbstract) {
        this._isAbstract = isAbstract;
    }

    public boolean hasChildren() {
        XMLType type = this.getType();
        if (type instanceof SimpleType) {
            return false;
        }
        if (type instanceof ComplexType) {
            if (((ComplexType)type).isComplexContent()) {
                return true;
            }
            if (((ComplexType)type).getParticleCount() != 0) {
                return true;
            }
            Enumeration temp = ((ComplexType)type).getAttributeDecls();
            return temp.hasMoreElements();
        }
        return false;
    }

    public boolean removeIdentityConstraint(IdentityConstraint constraint) {
        if (constraint == null) {
            return false;
        }
        return this._constraints.removeElement(constraint);
    }

    public void setBlock(BlockList block) {
        this._block = block;
    }

    public void setBlock(String block) {
        this._block = block == null ? null : new BlockList(block);
    }

    public void setDefaultValue(String value) {
        this._default = value;
    }

    public void setFinal(FinalList finalList) {
        this._final = finalList;
    }

    public void setFinal(String finalValue) {
        this._final = finalValue == null ? null : new FinalList(finalValue);
    }

    public void setFixedValue(String value) {
        this._fixed = value;
    }

    public void setForm(Form form) {
        this._form = form;
    }

    public void setId(String id) {
        this._id = id;
    }

    public void setName(String name) {
        if (name != null && !ValidationUtils.isNCName((String)name)) {
            String err = "error: '" + name + "' is not a valid NCName.";
            throw new IllegalArgumentException(err);
        }
        this._name = name;
    }

    public void setNillable(boolean nillable) {
        this._nillable = nillable;
    }

    protected void setParent(Structure parent) {
        if (parent != null) {
            switch (parent.getStructureType()) {
                case 10: 
                case 16: 
                case 19: {
                    break;
                }
                default: {
                    String error = "Invalid parent for element.";
                    throw new IllegalArgumentException(error);
                }
            }
        }
        this._parent = parent;
    }

    public void setReference(ElementDecl reference) {
        if (reference == null) {
            this._elementRefName = null;
            this._referencedElement = null;
        } else if (reference.getSchema() == this.getSchema()) {
            this._elementRefName = reference.getName();
            this._referencedElement = reference;
        } else {
            String prefix;
            String qName = reference.getName();
            String nsURI = reference.getSchema().getTargetNamespace();
            if (nsURI != null && (prefix = this.getSchema().getNamespacePrefix(nsURI)) != null && prefix.length() > 0) {
                qName = prefix + ":" + qName;
            }
            this._elementRefName = qName;
            this._referencedElement = reference;
        }
    }

    public void setReferenceName(String referenceName) {
        if (referenceName != null && !ValidationUtils.isQName((String)referenceName)) {
            String err = "error: '" + referenceName + "' is not a valid QName.";
            throw new IllegalArgumentException(err);
        }
        this._elementRefName = referenceName;
    }

    public void setSubstitutionGroup(String substitutionGroup) {
        this._substitutionGroup = substitutionGroup;
    }

    public void setType(XMLType type) {
        if (this._xmlType != null) {
            this._xmlType.setParent(null);
        }
        if (type != null) {
            type.setParent(this);
        }
        this._xmlType = type;
    }

    public void setTypeReference(String name) {
        TypeReference reference = new TypeReference();
        reference.setName(name);
        reference.setSchema(this._schema);
        this.setType(reference);
    }

    public short getStructureType() {
        return 8;
    }

    public void validate() throws ValidationException {
        XMLType type;
        if (this._elementRefName != null) {
            if (this._schema.getElementDecl(this._elementRefName) == null) {
                String err = "<element ref=\"" + this._elementRefName + "\"> " + "is not resolvable.";
                throw new ValidationException(err);
            }
            return;
        }
        if (this._name == null) {
            String err = "<element> is missing required 'name' or 'ref' attribute.";
            throw new ValidationException(err);
        }
        if (this.getParent() != null && this.getParent().getStructureType() == 19) {
            if (this.isMinOccursSet()) {
                String err = "'minOccurs' declaration is prohibited on top level element '/" + this.getName() + "'.";
                throw new ValidationException(err);
            }
            if (this.isMaxOccursSet()) {
                String err = "'maxOccurs' declaration is prohibited on top level element '/" + this.getName() + "'.";
                throw new ValidationException(err);
            }
        }
        if ((type = this.getType()) != null) {
            if (type.isComplexType()) {
                ComplexType complexType = (ComplexType)type;
                if (!complexType.isTopLevel()) {
                    complexType.validate();
                }
            } else if (type.isSimpleType()) {
                SimpleType simpleType = (SimpleType)type;
                if (simpleType.getParent() != simpleType.getSchema()) {
                    simpleType.validate();
                }
                int typeCode = simpleType.getTypeCode();
                switch (typeCode) {
                    case 25: 
                    case 26: 
                    case 27: 
                    case 30: 
                    case 31: {
                        String err = "Warning : For XML Compatibility " + simpleType.getName() + " should be used only as attributes\n.";
                        System.out.println(err);
                        break;
                    }
                }
            }
        }
    }

    private void setSchema(Schema schema) {
        this._schema = schema;
    }

    public boolean hasXMLType() {
        return this._xmlType != null;
    }
}

