/*
 * Decompiled with CFR 0.152.
 */
package org.castor.ddlgen;

import java.util.Collection;
import java.util.Collections;
import java.util.Hashtable;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.castor.ddlgen.DDLGenConfiguration;
import org.castor.ddlgen.GeneratorException;
import org.castor.ddlgen.KeyGeneratorFactory;
import org.castor.ddlgen.schemaobject.KeyGenerator;
import org.exolab.castor.mapping.xml.KeyGeneratorDef;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyGeneratorRegistry {
    private static final Log LOG = LogFactory.getLog(KeyGeneratorRegistry.class);
    private final DDLGenConfiguration _config;
    private final Map<String, KeyGeneratorFactory> _factories = new Hashtable<String, KeyGeneratorFactory>();
    private final Map<String, KeyGenerator> _generators = new Hashtable<String, KeyGenerator>();

    public KeyGeneratorRegistry(DDLGenConfiguration config) {
        this._config = config;
        String prop = config.getStringValue("org.castor.ddlgen.KeyGeneratorFactories", "");
        StringTokenizer tokenizer = new StringTokenizer(prop, ",");
        ClassLoader loader = KeyGeneratorRegistry.class.getClassLoader();
        while (tokenizer.hasMoreTokens()) {
            String classname = tokenizer.nextToken().trim();
            try {
                Class<?> cls = loader.loadClass(classname);
                KeyGeneratorFactory factory = (KeyGeneratorFactory)cls.newInstance();
                this._factories.put(factory.getAlgorithmName(), factory);
                if (factory.hasMandatoryParameters()) continue;
                KeyGenerator generator = factory.createKeyGenerator();
                this._generators.put(generator.getAlias(), generator);
            }
            catch (Exception ex) {
                String msg = "Problem instantiating key generator factory: ";
                LOG.error((Object)(msg + classname), (Throwable)ex);
            }
        }
    }

    public KeyGenerator createKeyGenerator(KeyGeneratorDef definition) throws GeneratorException {
        String algorithm = definition.getName();
        KeyGeneratorFactory factory = this.getKeyGeneratorFactory(algorithm);
        if (factory == null) {
            LOG.warn((Object)("Unknown KeyGeneratorFactory: " + algorithm));
            throw new GeneratorException("Unknown KeyGeneratorFactory: " + algorithm);
        }
        KeyGenerator generator = factory.createKeyGenerator(definition);
        generator.setConfiguration(this._config);
        this._generators.put(generator.getAlias(), generator);
        return generator;
    }

    public KeyGeneratorFactory getKeyGeneratorFactory(String algorithm) throws GeneratorException {
        if (algorithm == null) {
            throw new GeneratorException("No algorithm specified");
        }
        KeyGeneratorFactory factory = this._factories.get(algorithm);
        if (factory == null) {
            LOG.warn((Object)("Unknown KeyGeneratorFactory: " + algorithm));
            throw new GeneratorException("Unknown KeyGeneratorFactory: " + algorithm);
        }
        return factory;
    }

    public Collection<KeyGeneratorFactory> getKeyGeneratorFactories() {
        return Collections.unmodifiableCollection(this._factories.values());
    }

    public Collection<String> getKeyGeneratorFactoryAlgorithms() {
        return Collections.unmodifiableCollection(this._factories.keySet());
    }

    public KeyGenerator getKeyGenerator(String alias) throws GeneratorException {
        if (alias == null) {
            throw new GeneratorException("No keygenerator alias specified");
        }
        KeyGenerator generator = this._generators.get(alias);
        if (generator == null) {
            LOG.warn((Object)("Unknown KeyGenerator: " + alias));
            throw new GeneratorException("Unknown KeyGenerator: " + alias);
        }
        return generator;
    }

    public Collection<KeyGenerator> getKeyGenerators() {
        return Collections.unmodifiableCollection(this._generators.values());
    }

    public Collection<String> getKeyGeneratorAliases() {
        return Collections.unmodifiableCollection(this._generators.keySet());
    }
}

