/*
 * Decompiled with CFR 0.152.
 */
package org.exolab.castor.builder.types;

import org.exolab.castor.builder.types.AbstractDigitsFacet;
import org.exolab.javasource.JClass;
import org.exolab.javasource.JSourceCode;
import org.exolab.javasource.JType;

public final class XSLong
extends AbstractDigitsFacet {
    public static final String NAME = "long";
    public static final short TYPE = 35;
    public static final String MIN_VALUE = Long.toString(Long.MIN_VALUE);
    public static final String MAX_VALUE = Long.toString(Long.MAX_VALUE);
    private final boolean _asWrapper;
    private final JType _jType;

    public XSLong() {
        this(false);
    }

    public XSLong(boolean asWrapper) {
        this._asWrapper = asWrapper;
        this._jType = this._asWrapper ? new JClass("java.lang.Long") : JType.LONG;
        this.setMinInclusive(MIN_VALUE);
        this.setMaxInclusive(MAX_VALUE);
    }

    public String getName() {
        return NAME;
    }

    public short getType() {
        return 35;
    }

    public boolean isPrimitive() {
        return true;
    }

    public boolean isDateTime() {
        return false;
    }

    public JType getJType() {
        return this._jType;
    }

    public String newInstanceCode() {
        return "new java.lang.Long(0);";
    }

    public String createDefaultValueWithString(String variableName) {
        if (this._asWrapper) {
            return "new java.lang.Long(" + variableName + ")";
        }
        return "new java.lang.Long(" + variableName + ").longValue()";
    }

    public String createToJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return variableName;
        }
        return "new java.lang.Long(" + variableName + ")";
    }

    public String createFromJavaObjectCode(String variableName) {
        if (this._asWrapper) {
            return "((java.lang.Long) " + variableName + ")";
        }
        return "((java.lang.Long) " + variableName + ").longValue()";
    }

    public void validationCode(JSourceCode jsc, String fixedValue, String validatorInstanceName) {
        jsc.add("org.exolab.castor.xml.validators.LongValidator typeValidator;\ntypeValidator = new org.exolab.castor.xml.validators.LongValidator();\n{0}.setValidator(typeValidator);", validatorInstanceName);
        if (fixedValue != null) {
            jsc.add("typeValidator.setFixed(" + fixedValue + ");");
        }
        this.codePatternFacet(jsc, "typeValidator");
        this.codeWhiteSpaceFacet(jsc, "typeValidator");
        if (this.getMinExclusive() != null) {
            jsc.add("typeValidator.setMinExclusive(" + this.getMinExclusive() + "L);");
        } else if (this.getMinInclusive() != null) {
            jsc.add("typeValidator.setMinInclusive(" + this.getMinInclusive() + "L);");
        }
        if (this.getMaxExclusive() != null) {
            jsc.add("typeValidator.setMaxExclusive(" + this.getMaxExclusive() + "L);");
        } else if (this.getMaxInclusive() != null) {
            jsc.add("typeValidator.setMaxInclusive(" + this.getMaxInclusive() + "L);");
        }
        this.codeDigitsFacet(jsc, "typeValidator");
    }
}

