/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.cargo.maven3.configuration;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.logging.Log;
import org.apache.maven.project.MavenProject;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.codehaus.cargo.container.ContainerType;
import org.codehaus.cargo.container.configuration.ConfigurationType;
import org.codehaus.cargo.container.configuration.FileConfig;
import org.codehaus.cargo.container.configuration.LocalConfiguration;
import org.codehaus.cargo.container.configuration.StandaloneLocalConfiguration;
import org.codehaus.cargo.generic.configuration.DefaultConfigurationFactory;
import org.codehaus.cargo.maven3.configuration.DataSource;
import org.codehaus.cargo.maven3.configuration.Deployable;
import org.codehaus.cargo.maven3.configuration.Resource;
import org.codehaus.cargo.maven3.configuration.User;
import org.codehaus.cargo.maven3.util.CargoProject;
import org.codehaus.cargo.util.XmlReplacement;
import org.codehaus.plexus.util.xml.Xpp3Dom;

public class Configuration {
    private String type = ConfigurationType.STANDALONE.getType();
    private String implementation;
    private String home;
    private Map<String, String> properties;
    private File propertiesFile;
    private FileConfig[] fileConfigs;
    private FileConfig[] configfiles;
    private XmlReplacement[] xmlReplacements;
    private DataSource[] datasources;
    private Resource[] resources;
    private User[] users;

    public ConfigurationType getType() {
        return ConfigurationType.toType((String)this.type);
    }

    public void setType(ConfigurationType type) {
        this.type = type.getType();
    }

    public String getHome() {
        return this.home;
    }

    public void setHome(String home) {
        this.home = home;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = properties;
    }

    public File getPropertiesFile() {
        return this.propertiesFile;
    }

    public void setPropertiesFile(File propertiesFile) {
        this.propertiesFile = propertiesFile;
    }

    public FileConfig[] getConfigfiles() {
        return this.configfiles;
    }

    public void setConfigfiles(FileConfig[] configfiles) {
        this.configfiles = configfiles;
    }

    public FileConfig[] getFiles() {
        return this.fileConfigs;
    }

    public void setFiles(FileConfig[] fileConfigs) {
        this.fileConfigs = fileConfigs;
    }

    public XmlReplacement[] getXmlReplacements() {
        return this.xmlReplacements;
    }

    public void setXmlReplacements(XmlReplacement[] xmlReplacements) {
        this.xmlReplacements = xmlReplacements;
    }

    public String getImplementation() {
        return this.implementation;
    }

    public void setImplementation(String implementation) {
        this.implementation = implementation;
    }

    public DataSource[] getDatasources() {
        return this.datasources;
    }

    public void setDatasources(DataSource[] datasources) {
        this.datasources = datasources;
    }

    public Resource[] getResources() {
        return this.resources;
    }

    public void setResources(Resource[] rlist) {
        this.resources = rlist;
    }

    public User[] getUsers() {
        return this.users;
    }

    public void setUsers(User[] users) {
        this.users = users;
    }

    public org.codehaus.cargo.container.configuration.Configuration createConfiguration(String containerId, ContainerType containerType, Deployable[] deployables, CargoProject project, MavenProject mavenProject, String contextKey, Settings mavenSettings, Log log) throws MojoExecutionException {
        org.codehaus.cargo.container.configuration.Configuration configuration;
        DefaultConfigurationFactory factory = new DefaultConfigurationFactory();
        if (this.getImplementation() != null) {
            try {
                Class<?> configurationClass = Class.forName(this.getImplementation(), true, this.getClass().getClassLoader());
                factory.registerConfiguration(containerId, containerType, this.getType(), configurationClass);
            }
            catch (ClassNotFoundException cnfe) {
                throw new MojoExecutionException("Custom configuration implementation [" + this.getImplementation() + "] cannot be loaded", (Exception)cnfe);
            }
        }
        if (this.getHome() == null) {
            if (project.isDaemonRun()) {
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), "");
            } else if (ConfigurationType.RUNTIME.equals((Object)this.getType())) {
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), null);
            } else {
                File home = new File(project.getBuildDirectory(), "cargo/configurations/" + containerId);
                configuration = factory.createConfiguration(containerId, containerType, this.getType(), home.getAbsolutePath());
            }
        } else {
            configuration = factory.createConfiguration(containerId, containerType, this.getType(), this.getHome());
        }
        if (mavenSettings != null) {
            Object serverId = null;
            if (this.getProperties() != null) {
                serverId = this.getProperties().get("cargo.server.settings");
            }
            if (serverId != null && !((String)serverId).isEmpty()) {
                log.debug((CharSequence)("Found cargo.server.settings: " + (String)serverId));
            } else if (contextKey != null) {
                serverId = contextKey;
                log.debug((CharSequence)("Found container context key: " + (String)serverId));
            }
            if (serverId != null && !((String)serverId).isEmpty()) {
                for (Server server : mavenSettings.getServers()) {
                    Xpp3Dom[] globalConfigurationOptions;
                    if (!((String)serverId).equals(server.getId())) continue;
                    log.info((CharSequence)("The Maven settings.xml file contains a reference for the server with identifier [" + (String)serverId + "], injecting configuration properties"));
                    for (Xpp3Dom option : globalConfigurationOptions = ((Xpp3Dom)server.getConfiguration()).getChildren()) {
                        log.info((CharSequence)("\tInjecting container configuration property [" + option.getName() + "] based on the Maven settings.xml reference"));
                        configuration.setProperty(option.getName(), this.transformMavenPropertyValue(option.getValue()));
                    }
                }
            }
        }
        if (mavenProject != null && mavenProject.getProperties() != null) {
            for (Map.Entry entry : mavenProject.getProperties().entrySet()) {
                String key;
                if (entry.getKey() == null || !(entry.getKey() instanceof String) || !(entry.getValue() instanceof String) || !(key = (String)entry.getKey()).startsWith("cargo.") || !configuration.getCapability().supportsProperty(key)) continue;
                log.info((CharSequence)("Injecting container configuration property [" + key + "] based on the associated Maven project property"));
                configuration.setProperty(key, this.transformMavenPropertyValue((String)entry.getValue()));
            }
        }
        if (this.getPropertiesFile() != null) {
            Properties properties = new Properties();
            try {
                try (FileInputStream fileInputStream = new FileInputStream(this.getPropertiesFile());){
                    properties.load(new BufferedInputStream(fileInputStream));
                }
                Enumeration<?> enumeration = properties.propertyNames();
                while (enumeration.hasMoreElements()) {
                    String propertyName = (String)enumeration.nextElement();
                    String propertyValue = properties.getProperty(propertyName);
                    configuration.setProperty(propertyName, propertyValue);
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                log.warn((CharSequence)("Configuration property file [" + this.getPropertiesFile() + "] does not exist, skipping"));
            }
            catch (IOException iOException) {
                throw new MojoExecutionException("Configuration property file [" + this.getPropertiesFile() + "] cannot be loaded", (Exception)iOException);
            }
        }
        if (this.getProperties() != null) {
            for (Map.Entry entry : this.getProperties().entrySet()) {
                configuration.setProperty((String)entry.getKey(), this.transformMavenPropertyValue((String)entry.getValue()));
            }
        }
        if (configuration instanceof StandaloneLocalConfiguration && this.getXmlReplacements() != null) {
            StandaloneLocalConfiguration standaloneLocalConfiguration = (StandaloneLocalConfiguration)configuration;
            for (XmlReplacement xmlReplacement : this.getXmlReplacements()) {
                standaloneLocalConfiguration.addXmlReplacement(xmlReplacement);
            }
        }
        if (configuration instanceof LocalConfiguration) {
            LocalConfiguration localConfiguration = (LocalConfiguration)configuration;
            if (deployables != null) {
                this.addStaticDeployables(containerId, localConfiguration, deployables, project);
            }
            if (this.getDatasources() != null) {
                this.addDatasources(localConfiguration);
            }
            if (this.getResources() != null) {
                this.addResources(containerId, localConfiguration, project);
            }
            if (this.getUsers() != null) {
                this.addUsers(this.getUsers(), localConfiguration);
            }
            if (this.getConfigfiles() != null) {
                for (FileConfig fileConfig : this.getConfigfiles()) {
                    localConfiguration.setConfigFileProperty(fileConfig);
                }
            }
            if (this.getFiles() != null) {
                for (FileConfig fileConfig : this.getFiles()) {
                    localConfiguration.setFileProperty(fileConfig);
                }
            }
        }
        return configuration;
    }

    private String transformMavenPropertyValue(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    private void addDatasources(LocalConfiguration configuration) throws MojoExecutionException {
        for (DataSource dataSource : this.datasources) {
            configuration.addDataSource(dataSource.createDataSource());
        }
    }

    private void addResources(String containerId, LocalConfiguration configuration, CargoProject project) throws MojoExecutionException {
        for (Resource resource : this.getResources()) {
            configuration.addResource(resource.createResource(containerId, project));
        }
    }

    private void addUsers(User[] users, LocalConfiguration configuration) {
        for (User user : users) {
            configuration.addUser(user.createUser());
        }
    }

    private void addStaticDeployables(String containerId, LocalConfiguration configuration, Deployable[] deployables, CargoProject project) throws MojoExecutionException {
        for (Deployable deployable : deployables) {
            project.getLog().debug((CharSequence)("Scheduling deployable for deployment: [groupId [" + deployable.getGroupId() + "], artifactId [" + deployable.getArtifactId() + "], type [" + deployable.getType() + "], location [" + deployable.getLocation() + "], pingURL [" + deployable.getPingURL() + "]]"));
            configuration.addDeployable(deployable.createDeployable(containerId, project));
        }
    }
}

