/*
 * Decompiled with CFR 0.152.
 */
package org.chorem.vradi.ui.thesaurus.helpers;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionListener;
import javax.swing.event.TreeWillExpandListener;
import javax.swing.tree.TreeNode;
import jaxx.runtime.swing.nav.NavDataProvider;
import jaxx.runtime.swing.nav.NavHelper;
import jaxx.runtime.swing.nav.NavNode;
import jaxx.runtime.swing.nav.treetable.NavTreeTableBridge;
import jaxx.runtime.swing.nav.treetable.NavTreeTableHelper;
import jaxx.runtime.swing.nav.treetable.NavTreeTableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.chorem.vradi.VradiContext;
import org.chorem.vradi.VradiEntitiesListener;
import org.chorem.vradi.beans.QueryParameters;
import org.chorem.vradi.entities.RootThesaurus;
import org.chorem.vradi.entities.Thesaurus;
import org.chorem.vradi.ui.thesaurus.ThesaurusDataProvider;
import org.chorem.vradi.ui.thesaurus.helpers.ThesaurusDataHelper;
import org.chorem.vradi.ui.thesaurus.loadors.RootThesaurusTreeTableNodeLoadors;
import org.chorem.vradi.ui.thesaurus.loadors.ThesaurusTreeTableNodeLoadors;
import org.chorem.vradi.ui.thesaurus.models.ThesaurusTreeTableModel;
import org.chorem.vradi.ui.tree.VradiTreeTableNode;
import org.jdesktop.swingx.JXTreeTable;

public class ThesaurusTreeTableHelper
extends NavTreeTableHelper<VradiTreeTableNode>
implements VradiEntitiesListener<Thesaurus> {
    private static final Log log = LogFactory.getLog(ThesaurusTreeTableHelper.class);
    protected RootThesaurus rootThesaurus;
    protected List<String> idsLoaded = new ArrayList<String>();
    protected VradiEntitiesListener<RootThesaurus> thesaurusVradiEntitiesListener;

    public ThesaurusTreeTableHelper() {
        this(new ThesaurusDataProvider());
    }

    public ThesaurusTreeTableHelper(QueryParameters queryParameters) {
        this.init(new ThesaurusDataProvider(queryParameters));
    }

    public ThesaurusTreeTableHelper(RootThesaurus rootThesaurus) {
        this(new ThesaurusDataProvider());
        this.rootThesaurus = rootThesaurus;
    }

    public ThesaurusTreeTableHelper(ThesaurusDataProvider dataProvider) {
        this.init(dataProvider);
    }

    protected void init(NavDataProvider dataProvider) {
        this.setDataProvider(dataProvider);
        VradiContext.get().getVradiNotifier().addVradiListener(Thesaurus.class, this);
        this.thesaurusVradiEntitiesListener = new VradiEntitiesListener<RootThesaurus>(){

            @Override
            public void entitiesAdded(Set<RootThesaurus> added) {
                for (RootThesaurus rootThesaurus : added) {
                    String wikittyId = rootThesaurus.getWikittyId();
                    VradiTreeTableNode existingNode = ThesaurusTreeTableHelper.this.findRootThesaurusNode(wikittyId);
                    if (existingNode != null) {
                        ThesaurusTreeTableHelper.this.refresh(existingNode);
                        continue;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Refresh root thesaurus : " + wikittyId));
                    }
                    VradiTreeTableNode newNode = ((RootThesaurusTreeTableNodeLoadors)NavHelper.getChildLoador(RootThesaurusTreeTableNodeLoadors.class)).createNode(wikittyId, (NavDataProvider)ThesaurusTreeTableHelper.this.getDataProvider());
                    ThesaurusTreeTableHelper.this.insertNode(ThesaurusTreeTableHelper.this.getRootNode(), (NavNode)newNode);
                }
            }

            @Override
            public void entitiesRemoved(Set<String> removed) {
            }
        };
        VradiContext.get().getVradiNotifier().addVradiListener(RootThesaurus.class, this.thesaurusVradiEntitiesListener);
    }

    public void setUI(JXTreeTable tree, boolean addExpandTreeListener, boolean addOneClickSelectionListener, TreeSelectionListener listener, TreeWillExpandListener willExpandListener) {
        super.setUI(tree, addExpandTreeListener, addOneClickSelectionListener, listener, willExpandListener);
        tree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                VradiTreeTableNode node = (VradiTreeTableNode)((Object)event.getPath().getLastPathComponent());
                ThesaurusTreeTableHelper.this.registerLoadedIds(node);
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                VradiTreeTableNode node = (VradiTreeTableNode)((Object)event.getPath().getLastPathComponent());
                Enumeration enumeration = node.children();
                while (enumeration.hasMoreElements()) {
                    VradiTreeTableNode child = (VradiTreeTableNode)((Object)enumeration.nextElement());
                    ThesaurusTreeTableHelper.this.idsLoaded.remove(child.getId());
                }
            }
        });
    }

    public void registerLoadedIds(VradiTreeTableNode node) {
        this.idsLoaded.add(node.getId());
        Enumeration enumeration = node.children();
        while (enumeration.hasMoreElements()) {
            VradiTreeTableNode child = (VradiTreeTableNode)((Object)enumeration.nextElement());
            this.idsLoaded.add(child.getId());
        }
    }

    public void tryToSelect(String id) {
        Thesaurus thesaurus = ThesaurusDataHelper.restoreThesaurus(id);
        this.tryToSelect(thesaurus);
    }

    public void tryToSelect(Thesaurus thesaurus) {
        VradiTreeTableNode nodeFound;
        if (!thesaurus.getWikittyId().equals(((VradiTreeTableNode)this.getRootNode()).getId()) && (nodeFound = this.findThesaurusNode(thesaurus)) != null) {
            this.selectNode((NavNode)nodeFound);
        }
    }

    public void tryToSelect(List<String> thesaurusIds) {
        this.tryToSelect((Collection<Thesaurus>)ThesaurusDataHelper.restoreThesaurus(thesaurusIds));
    }

    public void tryToSelect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeTableNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(((VradiTreeTableNode)this.getRootNode()).getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.selectNodes(nodes);
    }

    public void tryToUnselect(String id) {
        this.tryToUnselect(ThesaurusDataHelper.restoreThesaurus(id));
    }

    public void tryToUnselect(Thesaurus thesaurus) {
        this.tryToUnselect(thesaurus.getWikittyId());
        VradiTreeTableNode nodeFound = this.findThesaurusNode(thesaurus);
        if (nodeFound != null) {
            this.unSelectNode((NavNode)nodeFound);
        }
    }

    public void tryToUnselect(List<String> thesaurusIds) {
        this.tryToUnselect((Collection<Thesaurus>)ThesaurusDataHelper.restoreThesaurus(thesaurusIds));
    }

    public void tryToUnselect(Collection<Thesaurus> thesauruses) {
        if (thesauruses == null) {
            return;
        }
        ArrayList<VradiTreeTableNode> nodes = new ArrayList<VradiTreeTableNode>();
        for (Thesaurus thesaurus : thesauruses) {
            VradiTreeTableNode toSelect;
            String id;
            if (thesaurus == null || (id = thesaurus.getWikittyId()).equals(((VradiTreeTableNode)this.getRootNode()).getId()) || (toSelect = this.findThesaurusNode(thesaurus)) == null) continue;
            nodes.add(toSelect);
        }
        this.unSelectNodes(nodes);
    }

    public VradiTreeTableNode findRootThesaurusNode(String rootThesaurusId) {
        VradiTreeTableNode parentNode = (VradiTreeTableNode)this.getRootNode();
        return (VradiTreeTableNode)this.getChild((NavNode)parentNode, rootThesaurusId);
    }

    public VradiTreeTableNode findRootThesaurusNode(RootThesaurus rootThesaurus) {
        return this.findRootThesaurusNode(rootThesaurus.getWikittyId());
    }

    public VradiTreeTableNode findThesaurusNode(String thesaurusId) {
        Thesaurus thesaurusToFind = ThesaurusDataHelper.restoreThesaurus(thesaurusId);
        if (thesaurusToFind == null) {
            return null;
        }
        return this.findThesaurusNode(thesaurusToFind);
    }

    public VradiTreeTableNode findThesaurusNode(Thesaurus thesaurus) {
        VradiTreeTableNode parentNode = (VradiTreeTableNode)this.getRootNode();
        VradiTreeTableNode rootNode = (VradiTreeTableNode)this.getChild((NavNode)parentNode, thesaurus.getRootThesaurus());
        if (rootNode != null) {
            parentNode = rootNode;
        }
        List<Thesaurus> parentList = this.getParentsPathThesaurus(thesaurus);
        for (Thesaurus parent : parentList) {
            VradiTreeTableNode nodeFound = (VradiTreeTableNode)this.getChild((NavNode)parentNode, parent.getWikittyId());
            if (nodeFound == null) continue;
            parentNode = nodeFound;
        }
        if (!parentNode.getId().equals(thesaurus.getWikittyId())) {
            return null;
        }
        return parentNode;
    }

    protected List<Thesaurus> getParentsPathThesaurus(Thesaurus thesaurus) {
        Thesaurus parent;
        ArrayList<Thesaurus> parents = new ArrayList<Thesaurus>();
        if (!ThesaurusDataHelper.isFirstChild(thesaurus) && (parent = ThesaurusDataHelper.restoreThesaurus(thesaurus.getParent())) != null) {
            List<Thesaurus> thesauruses = this.getParentsPathThesaurus(parent);
            parents.addAll(thesauruses);
        }
        parents.add(thesaurus);
        return parents;
    }

    protected List<String> extractIds(List<Thesaurus> beans) {
        ArrayList<String> ids = new ArrayList<String>();
        if (beans != null) {
            for (Thesaurus bean : beans) {
                ids.add(bean.getWikittyId());
            }
        }
        return ids;
    }

    public ThesaurusDataProvider getDataProvider() {
        return (ThesaurusDataProvider)this.dataProvider;
    }

    public NavTreeTableModel createTreeModel() {
        NavTreeTableModel model;
        if (this.rootThesaurus != null) {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, null);
            VradiTreeTableNode rootThesaurusNode = new VradiTreeTableNode(RootThesaurus.class, this.rootThesaurus.getWikittyId(), null, new ThesaurusTreeTableNodeLoadors());
            root.add(rootThesaurusNode);
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel(this.getDataProvider())});
            rootThesaurusNode.populateChilds(this.getBridge(), this.getDataProvider());
            this.registerLoadedIds(root);
        } else {
            VradiTreeTableNode root = new VradiTreeTableNode(String.class, "Root node", null, new RootThesaurusTreeTableNodeLoadors());
            model = this.createModel(root, new Object[]{new ThesaurusTreeTableModel(this.getDataProvider())});
            root.populateChilds(this.getBridge(), this.getDataProvider());
            this.registerLoadedIds(root);
        }
        return model;
    }

    public static RootThesaurus getRootThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(RootThesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreRootThesaurus(node.getId());
    }

    public static Thesaurus getThesaurus(VradiTreeTableNode node) {
        if (!node.getInternalClass().equals(Thesaurus.class)) {
            return null;
        }
        return ThesaurusDataHelper.restoreThesaurus(node.getId());
    }

    protected void refresh(VradiTreeTableNode node) {
        if (node == null) {
            return;
        }
        ((NavTreeTableBridge)this.getBridge()).nodeChanged((TreeNode)((Object)node));
    }

    public VradiTreeTableNode createRootThesaurusAndSelect(String rootThesaurusIdToAdd) {
        VradiTreeTableNode newNode = this.createRootThesaurus(rootThesaurusIdToAdd);
        this.selectNode((NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createRootThesaurus(String rootThesaurusIdToAdd) {
        VradiTreeTableNode newNode = ((RootThesaurusTreeTableNodeLoadors)ThesaurusTreeTableHelper.getChildLoador(RootThesaurusTreeTableNodeLoadors.class)).createNode(rootThesaurusIdToAdd, (NavDataProvider)this.getDataProvider());
        this.insertNode(this.getRootNode(), (NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurusAndSelect(String parentId, String thesaurusIdToAdd) {
        VradiTreeTableNode newNode = this.createThesaurus(parentId, thesaurusIdToAdd);
        this.selectNode((NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurus(String parentId, String thesaurusIdToAdd) {
        VradiTreeTableNode parentNode = this.findThesaurusNode(parentId);
        VradiTreeTableNode newNode = ((ThesaurusTreeTableNodeLoadors)ThesaurusTreeTableHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)).createNode(thesaurusIdToAdd, (NavDataProvider)this.getDataProvider());
        this.insertNode((NavNode)parentNode, (NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurusChildOfRootAndSelect(String rootThesaurusId, String thesaurusIdToAdd) {
        VradiTreeTableNode newNode = this.createThesaurusChildOfRoot(rootThesaurusId, thesaurusIdToAdd);
        this.selectNode((NavNode)newNode);
        return newNode;
    }

    public VradiTreeTableNode createThesaurusChildOfRoot(String rootThesaurusId, String thesaurusIdToAdd) {
        VradiTreeTableNode rootNode = (VradiTreeTableNode)this.getChild(this.getRootNode(), rootThesaurusId);
        VradiTreeTableNode newNode = ((ThesaurusTreeTableNodeLoadors)ThesaurusTreeTableHelper.getChildLoador(ThesaurusTreeTableNodeLoadors.class)).createNode(thesaurusIdToAdd, (NavDataProvider)this.getDataProvider());
        this.insertNode((NavNode)rootNode, (NavNode)newNode);
        return newNode;
    }

    @Override
    public void entitiesAdded(Set<Thesaurus> added) {
        for (Thesaurus thesaurusConcerned : added) {
            String wikittyId = thesaurusConcerned.getWikittyId();
            if (!this.idsLoaded.contains(thesaurusConcerned.getParent()) && !this.idsLoaded.contains(wikittyId)) continue;
            VradiTreeTableNode existingNode = this.findThesaurusNode(wikittyId);
            if (existingNode != null) {
                VradiTreeTableNode parent = (VradiTreeTableNode)existingNode.getParent();
                String newParentId = thesaurusConcerned.getParent();
                if (parent != null && !parent.getId().equals(newParentId)) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Move case :  " + thesaurusConcerned.getName()));
                    }
                    VradiTreeTableNode newParentNode = this.findThesaurusNode(newParentId);
                    this.removeNode((NavNode)existingNode);
                    if (this.getChild((NavNode)newParentNode, wikittyId) != null) continue;
                    this.createThesaurus(newParentNode.getId(), wikittyId);
                    continue;
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Modification case :  " + thesaurusConcerned.getName()));
                }
                this.refresh(existingNode);
                continue;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creation case :  " + thesaurusConcerned.getName()));
            }
            if (this.findThesaurusNode(wikittyId) != null) continue;
            this.createThesaurus(thesaurusConcerned.getParent(), wikittyId);
        }
    }

    @Override
    public void entitiesRemoved(Set<String> removed) {
        for (String wikittyId : removed) {
            if (!this.idsLoaded.contains(wikittyId)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("Removing node " + wikittyId + " from parent"));
            }
            VradiTreeTableNode node = this.findThesaurusNode(wikittyId);
            this.idsLoaded.remove(wikittyId);
            if (node == null) continue;
            this.removeNode((NavNode)node);
        }
    }
}

